/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.scanner.CharData;
import weblogic.xml.babel.scanner.PEReference;
import weblogic.xml.babel.scanner.Reference;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;

final class EntityValue {
    private ScannerState state;
    private Reference reference;
    private PEReference peReference;
    private CharData singleQuoteData;
    private CharData doubleQuoteData;
    private String text;

    EntityValue(ScannerState scannerState) {
        this.state = scannerState;
        this.reference = new Reference(scannerState);
        this.reference.setInDTD(true);
        this.singleQuoteData = new CharData(scannerState, "%&'");
        this.doubleQuoteData = new CharData(scannerState, "%&\"");
        this.peReference = new PEReference(scannerState);
    }

    public String getText() {
        return this.text;
    }

    private void readSingleQuote() throws IOException, ScannerException {
        this.state.expect('\'');
        while (true) {
            boolean bl;
            if (bl = this.singleQuoteData.read()) {
                this.text = this.text + this.state.currentToken.getArrayAsString();
            }
            if (this.state.currentChar == '&') {
                this.reference.read();
                this.text = this.text + this.state.currentToken.text;
                bl = true;
                continue;
            }
            if (this.state.currentChar == '%') {
                this.peReference.read();
                bl = true;
                continue;
            }
            if (this.state.currentChar == '\'' || !bl) break;
        }
        this.state.expect('\'');
    }

    private void readDoubleQuote() throws IOException, ScannerException {
        this.state.expect('\"');
        while (true) {
            boolean bl;
            if (bl = this.doubleQuoteData.read()) {
                this.text = this.text + this.state.currentToken.getArrayAsString();
                bl = false;
            }
            if (this.state.currentChar == '&') {
                this.reference.read();
                this.text = this.text + this.state.currentToken.text;
                bl = true;
                continue;
            }
            if (this.state.currentChar == '%') {
                this.peReference.read();
                bl = true;
                continue;
            }
            if (this.state.currentChar == '\"' || !bl) break;
        }
        this.state.expect('\"');
    }

    void read() throws IOException, ScannerException {
        this.text = "";
        if (this.state.currentChar == '\"') {
            this.readDoubleQuote();
        } else {
            this.readSingleQuote();
        }
    }
}

