/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.utils.collections.Stack;
import weblogic.xml.babel.baseparser.BaseEntityResolver;
import weblogic.xml.babel.baseparser.CharDataElement;
import weblogic.xml.babel.baseparser.CommentElement;
import weblogic.xml.babel.baseparser.EOFElement;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.EndElement;
import weblogic.xml.babel.baseparser.NullElement;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.ProcessingInstruction;
import weblogic.xml.babel.baseparser.Space;
import weblogic.xml.babel.baseparser.StartElement;
import weblogic.xml.babel.baseparser.SymbolTable;
import weblogic.xml.babel.baseparser.SymbolTableException;
import weblogic.xml.babel.dtd.DocumentTypeDefinition;
import weblogic.xml.babel.dtd.EntityTable;
import weblogic.xml.babel.reader.XmlReader;
import weblogic.xml.babel.scanner.Scanner;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.Token;

public class BaseParser {
    Token currentToken;
    public static final boolean debug = false;
    protected static final boolean debugNS = false;
    protected static final boolean verbose = false;
    protected Scanner scanner;
    protected Stack stack;
    protected Stack prefixStack;
    protected SymbolTable nameSpaceTable;
    protected Map nameSpaceMap;
    protected static final String DEFAULTNSNAME = "";
    protected static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    protected boolean dnsSet;
    protected boolean readOneStartTag;
    protected StartElement startElement;
    protected EndElement endElement;
    protected ProcessingInstruction pi;
    protected Space space;
    protected CharDataElement cde;
    protected CommentElement comment;
    protected NullElement nullElement;
    protected EOFElement eofElement;
    protected Object[] outOfScopeNameSpace;
    protected BaseEntityResolver entityResolver;
    protected BaseParser parent;
    protected boolean isChild = false;
    protected String systemID = "";
    protected String publicID = "";
    private boolean isFragmentParser = false;

    protected BaseParser() {
    }

    public BaseParser(Reader reader) throws IOException, ScannerException {
        this.init(reader);
    }

    public BaseParser(InputStream inputStream) throws IOException, ScannerException {
        this.init(XmlReader.createReader(inputStream));
    }

    public BaseParser(InputSource inputSource) throws IOException, ScannerException {
        this.init(inputSource);
    }

    protected void init(String string) throws IOException, ScannerException {
        this.init(this.resolveSystemID(string));
    }

    protected void init(InputSource inputSource) throws IOException, ScannerException {
        this.init(this.resolveInputSource(inputSource));
    }

    protected void initScanner(Scanner scanner) throws IOException, ScannerException {
        this.prime();
    }

    public Reader resolveSystemID(String string) throws IOException {
        this.systemID = string;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            return XmlReader.createReader(fileInputStream);
        }
        catch (IOException iOException) {
            URL uRL = new URL(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            return XmlReader.createReader(bufferedInputStream);
        }
    }

    public Reader resolveInputSource(InputSource inputSource) throws IOException {
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            return XmlReader.createReader(inputSource.getByteStream());
        }
        if (inputSource.getSystemId() != null) {
            return this.resolveSystemID(inputSource.getSystemId());
        }
        throw new IOException("Unable to resolve input source.");
    }

    public Scanner createScanner(InputSource inputSource) throws IOException, ScannerException {
        return this.createScanner(this.resolveInputSource(inputSource));
    }

    public Scanner createScanner(Reader reader) throws IOException, ScannerException {
        Scanner scanner = this.isChild ? this.subScanner(reader) : this.baseScanner(reader);
        return scanner;
    }

    public Scanner baseScanner(Reader reader) throws IOException, ScannerException {
        Scanner scanner = new Scanner(reader);
        this.setEntityTables(scanner, this);
        scanner.setEntityResolver(this.entityResolver);
        return scanner;
    }

    public Scanner subScanner(Reader reader) throws IOException, ScannerException {
        Scanner scanner = this.baseScanner(reader);
        this.setEntityTables(scanner, this.parent);
        return scanner;
    }

    public void setParent(BaseParser baseParser) {
        this.parent = baseParser;
        this.isChild = true;
    }

    public void clear() {
        this.stack.clear();
        this.prefixStack.clear();
        this.nameSpaceTable.clear();
        this.nameSpaceMap.clear();
    }

    public BaseParser recycle(Reader reader) throws IOException, ScannerException {
        this.scanner.recycle(reader);
        this.clear();
        this.readOneStartTag = false;
        this.init();
        this.initScanner(this.scanner);
        return this;
    }

    protected void init(Reader reader) throws IOException, ScannerException {
        this.scanner = this.createScanner(reader);
        this.stack = new Stack();
        this.prefixStack = new Stack();
        if (this.isChild) {
            this.nameSpaceTable = this.parent.nameSpaceTable;
            this.nameSpaceMap = this.parent.nameSpaceMap;
        } else {
            this.nameSpaceTable = new SymbolTable();
            this.nameSpaceMap = new HashMap();
        }
        this.startElement = new StartElement();
        this.endElement = new EndElement();
        this.pi = new ProcessingInstruction();
        this.space = new Space();
        this.cde = new CharDataElement();
        this.comment = new CommentElement();
        this.nullElement = new NullElement();
        this.eofElement = new EOFElement();
        this.readOneStartTag = false;
        if (this.isChild) {
            this.setBaseEntityResolver(this.parent.getBaseEntityResolver());
            this.setEntityTables(this.scanner, this.parent);
        } else if (this.entityResolver == null) {
            this.setBaseEntityResolver(new BaseEntityResolver());
        }
        this.init();
        this.initScanner(this.scanner);
    }

    public void setEntityTables(Scanner scanner, BaseParser baseParser) {
    }

    public void setBaseEntityResolver(BaseEntityResolver baseEntityResolver) {
        this.entityResolver = baseEntityResolver;
        this.scanner.setEntityResolver(baseEntityResolver);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return this.entityResolver.resolveEntity(string, string2);
    }

    public void prime() throws IOException, ScannerException {
        this.currentToken = null;
        while (this.currentToken == null) {
            this.currentToken = this.scanner.scan();
        }
    }

    protected void init() {
        this.nameSpaceTable.put(DEFAULTNSNAME, null);
        this.nameSpaceTable.put("xml", XMLNS);
        this.nameSpaceMap.put("xml", XMLNS);
        this.dnsSet = false;
        this.cde.init();
    }

    protected Scanner getScanner() {
        return this.scanner;
    }

    public boolean hasNext() {
        return !this.currentToken.isEOF();
    }

    public void setFragmentParser(boolean bl) {
        this.isFragmentParser = bl;
    }

    public void addNamespaceDeclarations(Map map) {
        if (map == null) {
            return;
        }
        try {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getValue();
                String string2 = (String)entry.getKey();
                this.putNamespaceURI(string2, string);
            }
        }
        catch (SAXException sAXException) {}
    }

    public Element parseSome() throws IOException, ScannerException, ParseException {
        if (!this.isEOF()) {
            Element element = this.isFragmentParser || this.nameSpaceTable.withinElement() ? this.parseElement() : this.parseProlog();
            switch (element.type) {
                case 0: {
                    this.stack.push(element.getLocalName());
                    String string = element.getPrefix();
                    if (string == null) {
                        string = DEFAULTNSNAME;
                    }
                    this.prefixStack.push(string);
                    break;
                }
                case 3: {
                    if (this.stack.isEmpty()) {
                        throw new ParseException("Unexpected ELEMENT", this.scanner.getLine(), this.currentToken);
                    }
                    String string = (String)this.stack.pop();
                    String string2 = (String)this.prefixStack.pop();
                    String string3 = element.getLocalName();
                    String string4 = element.getPrefix();
                    if (string4 == null) {
                        string4 = DEFAULTNSNAME;
                    }
                    if (string.equals(string3) && string2.equals(string4)) break;
                    throw new ParseException("Unbalanced ELEMENT got:" + string3 + " expected:" + string, this.scanner.getLine(), this.currentToken);
                }
            }
            return element;
        }
        return null;
    }

    public BaseEntityResolver getBaseEntityResolver() {
        return this.entityResolver;
    }

    public void parse() throws IOException, ScannerException, ParseException {
        this.parseSome();
    }

    protected Element parseProlog() throws IOException, ScannerException, ParseException {
        switch (this.currentToken.tokenType) {
            case 1: {
                if (this.readOneStartTag) {
                    throw new ParseException("All tags must be contained within a single element", this.scanner.getLine(), this.currentToken);
                }
                this.readOneStartTag = true;
                return this.parseElement();
            }
            case 7: 
            case 8: {
                return this.parseElement();
            }
            case 19: {
                this.space.parse(this);
                return this.space;
            }
            case 13: {
                this.cde.parse(this);
                return this.cde;
            }
            case -1: {
                this.eofElement.parse(this);
                return this.eofElement;
            }
        }
        System.out.println("Did not get a DOCYTPE");
        throw new ParseException("Expected a PI, SPACE, OPENTAG, or COMMENT ", this.scanner.getLine(), this.currentToken);
    }

    protected Element parseElement() throws IOException, ScannerException, ParseException {
        switch (this.currentToken.tokenType) {
            case 1: {
                this.nameSpaceTable.openScope();
                this.startElement.parse(this);
                this.processAttributes(this.startElement);
                return this.startElement;
            }
            case 4: {
                this.endElement.parse(this);
                this.outOfScopeNameSpace = this.nameSpaceTable.closeScope();
                return this.endElement;
            }
            case 8: {
                this.pi.parse(this);
                return this.pi;
            }
            case 19: {
                this.space.parse(this);
                return this.space;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                this.cde.parse(this);
                return this.cde;
            }
            case 7: {
                this.comment.parse(this);
                return this.comment;
            }
        }
        throw new ParseException("Expected an ELEMENT", this.scanner.getLine(), this.currentToken);
    }

    protected void processAttributes(StartElement startElement) {
    }

    protected void parsePrint() throws IOException, ScannerException, ParseException {
        Element element = this.parseSome();
        System.out.print("[" + this.nameSpaceTable.getDepth() + "]" + element);
    }

    public void accept(int n) throws IOException, ScannerException, ParseException {
        if (this.currentToken.tokenType != n) {
            throw new ParseException("Unexpected token", this.scanner.getLine(), this.currentToken);
        }
        this.accept();
    }

    public boolean ignore(int n) throws IOException, ScannerException, ParseException {
        if (this.currentToken.tokenType == n) {
            this.accept();
            return true;
        }
        return false;
    }

    public void accept() throws IOException, ScannerException, ParseException {
        this.currentToken = this.scanner.scan();
    }

    void processEOF() throws IOException, ScannerException, ParseException {
        if (this.inDocument()) {
            throw new ParseException("Unbalanced root element in document", this.scanner.getLine(), this.currentToken);
        }
    }

    public int getLine() {
        return this.scanner.getLine();
    }

    public int getColumn() {
        return this.scanner.getColumn();
    }

    public String getSystemId() {
        return this.systemID;
    }

    public String getPublicId() {
        return this.publicID;
    }

    public void printTokenStack() {
        this.scanner.printTokenStack();
    }

    public boolean compare(int n) {
        return this.currentToken.tokenType == n;
    }

    boolean isEOF() {
        return this.currentToken.isEOF();
    }

    public boolean inDocument() {
        return !this.stack.isEmpty();
    }

    void tab() {
        int n = 0;
        while (n < this.stack.size()) {
            System.out.print("\t");
            ++n;
        }
    }

    protected void putNamespaceURI(String string, String string2) throws SAXException {
        this.nameSpaceTable.put(string, string2);
        this.nameSpaceMap.put(string, string2);
    }

    protected void removeNamespaceURI(Object[] objectArray) throws SAXException {
        int n = 0;
        while (n < objectArray.length) {
            PrefixMapping prefixMapping = (PrefixMapping)objectArray[n];
            if (prefixMapping.getUri() == null) {
                this.nameSpaceMap.remove(prefixMapping.getPrefix());
            } else {
                this.nameSpaceMap.put(prefixMapping.getPrefix(), prefixMapping.getUri());
            }
            ++n;
        }
    }

    public Token getCurrentToken() {
        return this.currentToken;
    }

    protected void setDefaultNameSpace(String string) throws SAXException {
        this.putNamespaceURI(DEFAULTNSNAME, string);
        this.dnsSet = true;
    }

    public Object[] getOutOfScopeNamespaces() {
        return this.outOfScopeNameSpace;
    }

    public Map getNameSpaceMap() {
        return this.nameSpaceMap;
    }

    public boolean isDefaultNameSpaceSet() {
        return this.dnsSet;
    }

    public String getDefaultNameSpace() throws ParseException {
        try {
            return this.nameSpaceTable.get(DEFAULTNSNAME);
        }
        catch (SymbolTableException symbolTableException) {
            throw new ParseException(symbolTableException.getMessage(), this.scanner.getLine(), this.currentToken);
        }
    }

    public String getNameSpace(String string) throws ParseException {
        try {
            return this.nameSpaceTable.get(string);
        }
        catch (SymbolTableException symbolTableException) {
            System.out.println(this.nameSpaceTable.toString());
            throw new ParseException(symbolTableException.getMessage(), this.scanner.getLine(), this.currentToken);
        }
    }

    public EntityTable getParameterEntityTable() {
        return null;
    }

    public EntityTable getInternalEntityTable() {
        return null;
    }

    public EntityTable getExternalEntityTable() {
        return null;
    }

    public DocumentTypeDefinition getDTD() {
        return null;
    }

    public static void timeTest(String string, int n) {
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                BaseParser baseParser = new BaseParser(bufferedInputStream);
                long l2 = System.currentTimeMillis();
                while (!baseParser.isEOF()) {
                    baseParser.parse();
                }
                long l3 = System.currentTimeMillis();
                l += l3 - l2;
            }
            catch (ScannerException scannerException) {
                System.out.println("-----SCANNER----");
                System.out.println(scannerException);
                scannerException.printStackTrace();
                scannerException.printTokenStack();
                scannerException.printErrorLine();
            }
            catch (ParseException parseException) {
                System.out.println("-----PARSER ----");
                System.out.println(parseException);
                parseException.printStackTrace();
            }
            catch (Exception exception) {
                System.out.println("-----JAVA   ----");
                exception.printStackTrace();
            }
            ++n2;
        }
        System.out.println("Parser took:" + l + " milliseconds for " + n + " iterations " + (float)l / (float)n + " milliseconds per iteration");
        System.out.println("Parser:" + (double)l / 1000.0 + " [s] (" + (double)n / ((double)l / 1000.0) + " [iteration/s], " + (float)l / (float)n + " [ms/iteration])");
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = false;
            if (stringArray.length == 2) {
                bl = true;
            }
            if (!bl) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("a", "http://a");
                BaseParser baseParser = new BaseParser(new BufferedInputStream(new FileInputStream(stringArray[0])));
                baseParser.setFragmentParser(true);
                baseParser.addNamespaceDeclarations(hashMap);
                while (!baseParser.isEOF()) {
                    baseParser.parsePrint();
                }
            } else {
                BaseParser.timeTest(stringArray[0], Integer.parseInt(stringArray[1]));
            }
        }
        catch (ScannerException scannerException) {
            System.out.println("-----SCANNER----");
            System.out.println(scannerException);
            scannerException.printStackTrace();
            scannerException.printTokenStack();
            scannerException.printErrorLine();
        }
        catch (ParseException parseException) {
            System.out.println("-----PARSER ----");
            System.out.println(parseException);
            parseException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("-----JAVA   ----");
            exception.printStackTrace();
        }
    }
}

