/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.util;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTextAreaUI;

public class DisplayTextArea
extends JTextArea {
    private int fontStyle;
    private Border border;
    private int maxWidth;

    public DisplayTextArea() {
        this(true, -1, -1);
    }

    public DisplayTextArea(boolean bl, int n, int n2) {
        this.fontStyle = n;
        this.maxWidth = n2;
        this.setLineWrap(bl);
        this.setWrapStyleWord(bl);
        this.setEditable(false);
        this.setRequestFocusEnabled(false);
        this.updateUI();
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int n) {
        this.fontStyle = n;
        this.updateUI();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.maxWidth > -1) {
            dimension.width = Math.min(dimension.width, this.maxWidth);
        }
        return dimension;
    }

    public void setBorder(Border border) {
        this.border = border;
        super.setBorder(border);
    }

    public void updateUI() {
        this.setUI(new BasicTextAreaUI());
        this.invalidate();
        JLabel jLabel = new JLabel();
        Font font = jLabel.getFont();
        if (this.fontStyle != -1) {
            font = font.deriveFont(this.fontStyle);
        }
        this.setFont(font);
        this.setBorder(this.border);
        this.setOpaque(false);
    }
}

