/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.search;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.search.SearchCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultsCmd
extends SearchCommand {
    public static final int CODE_DEFAULT = 5;
    public static final int SUBCODE_DEFAULT = 0;
    private final int code;
    private final int subCode;
    private final List<DirInfo> results;

    protected SearchResultsCmd(SnacPacket snacPacket) {
        super(3);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.code = BinaryTools.getUShort(byteBlock, 0);
        this.subCode = BinaryTools.getUShort(byteBlock, 2);
        if (byteBlock.getLength() >= 6) {
            int n = BinaryTools.getUShort(byteBlock, 4);
            ArrayList<DirInfo> arrayList = new ArrayList<DirInfo>();
            ByteBlock byteBlock2 = byteBlock.subBlock(6);
            for (int i = 0; i < n; ++i) {
                int n2 = BinaryTools.getUShort(byteBlock2, 0);
                ByteBlock byteBlock3 = byteBlock2.subBlock(2);
                DirInfo dirInfo = DirInfo.readDirInfo(byteBlock3, n2);
                if (dirInfo == null) break;
                arrayList.add(dirInfo);
                byteBlock2 = byteBlock2.subBlock(2 + dirInfo.getTotalSize());
            }
            this.results = DefensiveTools.getUnmodifiable(arrayList);
        } else {
            this.results = null;
        }
    }

    public SearchResultsCmd(Collection<DirInfo> collection) {
        this(5, 0, collection);
    }

    public SearchResultsCmd(int n, int n2, Collection<DirInfo> collection) {
        super(3);
        DefensiveTools.checkRange(n, "code", 0);
        DefensiveTools.checkRange(n2, "subCode", 0);
        this.code = n;
        this.subCode = n2;
        this.results = DefensiveTools.getSafeNonnullListCopy(collection, "results");
    }

    public final int getResultCode() {
        return this.code;
    }

    public final int getResultSubCode() {
        return this.subCode;
    }

    public List<DirInfo> getResults() {
        return this.results;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.code);
        BinaryTools.writeUShort(outputStream, this.subCode);
        if (this.results != null) {
            BinaryTools.writeUShort(outputStream, this.results.size());
            for (DirInfo dirInfo : this.results) {
                BinaryTools.writeUShort(outputStream, dirInfo.getTlvCount());
                dirInfo.write(outputStream);
            }
        }
    }

    public String toString() {
        return "SearchResultsCmd: " + this.results.size() + " results";
    }
}

