/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.auth.AuthCommand;

public class SecuridResponse
extends AuthCommand {
    private final String securid;

    protected SecuridResponse(SnacPacket snacPacket) {
        super(11);
        ByteBlock byteBlock = snacPacket.getData();
        short s = BinaryTools.getUByte(byteBlock, 0);
        this.securid = BinaryTools.getAsciiString(byteBlock.subBlock(1, s));
    }

    public SecuridResponse(String string) {
        super(11);
        DefensiveTools.checkNull(string, "securid");
        this.securid = string;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        DefensiveTools.checkNull(this.securid, "securid");
        BinaryTools.writeUByte(outputStream, this.securid.length());
        outputStream.write(BinaryTools.getAsciiBytes(this.securid));
    }

    public String getSecurid() {
        return this.securid;
    }
}

