/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.roster;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openymsg.addressBook.YahooAddressBookEntry;
import org.openymsg.network.ContactListType;
import org.openymsg.network.FireEvent;
import org.openymsg.network.FriendManager;
import org.openymsg.network.ServiceType;
import org.openymsg.network.Status;
import org.openymsg.network.YahooProtocol;
import org.openymsg.network.YahooUser;
import org.openymsg.network.event.SessionEvent;
import org.openymsg.network.event.SessionFriendAcceptedEvent;
import org.openymsg.network.event.SessionFriendEvent;
import org.openymsg.network.event.SessionFriendRejectedEvent;
import org.openymsg.network.event.SessionListEvent;
import org.openymsg.network.event.SessionListener;
import org.openymsg.roster.RosterEvent;
import org.openymsg.roster.RosterEventType;
import org.openymsg.roster.RosterListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Roster
implements Set<YahooUser>,
SessionListener {
    private static final Log log = LogFactory.getLog(Roster.class);
    private final Collection<RosterListener> listeners = new LinkedList<RosterListener>();
    private final Map<String, YahooUser> usersById = new ConcurrentHashMap<String, YahooUser>();
    private final Map<String, YahooAddressBookEntry> addressBookUsersById = new Hashtable<String, YahooAddressBookEntry>();
    private final FriendManager friendManager;

    public Roster(FriendManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 'manager' cannot be null");
        }
        this.friendManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterListener(RosterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 'listener' cannot be null.");
        }
        Collection<RosterListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
        log.debug((Object)"Added new RosterListener.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRosterListener(RosterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 'listener' cannot be null.");
        }
        Collection<RosterListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
        log.debug((Object)"Removed RosterListener.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void broadcastEvent(RosterEvent event) {
        RosterListener[] copies;
        Collection<RosterListener> collection = this.listeners;
        synchronized (collection) {
            copies = this.listeners.toArray(new RosterListener[this.listeners.size()]);
        }
        for (RosterListener rosterListener : copies) {
            rosterListener.rosterChanged(event);
        }
        log.trace((Object)("Broadcasted RosterEvent to " + copies.length + " listeners: " + event));
    }

    @Override
    public boolean add(YahooUser user) {
        if (user == null) {
            throw new NullPointerException();
        }
        String id = user.getId();
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("The user to be added must have a valid, non-empty String ID field set.");
        }
        if (user.getGroupIds() == null || user.getGroupIds().isEmpty()) {
            throw new IllegalArgumentException("The user to be added must have at least on groupId.");
        }
        log.trace((Object)("Adding new user: " + user));
        YahooProtocol yahooProtocol = YahooProtocol.YAHOO;
        if (user.getProtocol() == null) {
            log.debug((Object)("default protocol used for: " + id));
        } else {
            yahooProtocol = user.getProtocol();
        }
        for (String groupId : user.getGroupIds()) {
            try {
                log.trace((Object)("Adding new user: " + user + ", group: " + groupId));
                this.friendManager.sendNewFriendRequest(user.getId(), groupId, yahooProtocol);
            }
            catch (IOException ex) {
                log.error((Object)("Failed adding user: " + user), (Throwable)ex);
                throw new RuntimeException("Unexpected exception.", ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncedAdd(YahooUser user) {
        if (user == null) {
            throw new NullPointerException();
        }
        String id = user.getId();
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("The user to be added must have a valid, non-empty String ID field set.");
        }
        log.trace((Object)("Adding new user: " + user));
        YahooAddressBookEntry addressBookEntry = this.addressBookUsersById.get(id);
        Map<String, YahooUser> map = this.usersById;
        synchronized (map) {
            if (addressBookEntry != null) {
                user = this.createMergedUser(addressBookEntry, id, user);
            }
            this.usersById.put(id, user);
            log.trace((Object)("Added new user: " + user));
        }
        this.broadcastEvent(new RosterEvent(this, user, RosterEventType.add));
        return true;
    }

    @Override
    public boolean remove(Object userObject) {
        if (userObject == null) {
            throw new NullPointerException();
        }
        if (!(userObject instanceof YahooUser)) {
            throw new ClassCastException("This method needs a YahooUser value.");
        }
        YahooUser user = (YahooUser)userObject;
        if (!this.contains(user)) {
            log.trace((Object)("Cannot remove a user, because it's not on this roster: " + user));
            return false;
        }
        log.trace((Object)("Removing a user: " + user));
        for (String groupId : user.getGroupIds()) {
            try {
                this.friendManager.removeFriendFromGroup(user.getId(), groupId);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unexpected exception.", ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncedRemove(String userId) {
        YahooUser user;
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("Argument 'userId' cannot be null or an empty String.");
        }
        log.trace((Object)("Removing user by userId: " + userId));
        Map<String, YahooUser> map = this.usersById;
        synchronized (map) {
            if (!this.usersById.containsKey(userId)) {
                log.debug((Object)("Roster does not contain this userId (backend storage will not be updated): " + userId));
                return false;
            }
            user = this.usersById.remove(userId);
            log.trace((Object)("Removed user: " + user));
        }
        this.broadcastEvent(new RosterEvent(this, user, RosterEventType.remove));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncedUpdate(String userId, YahooUser user) {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("Argument 'userId' cannot be null or an empty String.");
        }
        if (user == null) {
            throw new NullPointerException();
        }
        if (!userId.equals(user.getId())) {
            throw new IllegalArgumentException("The user object that is updated must have the same userId as provided in the userId argument (updating a userID is illegal).");
        }
        YahooAddressBookEntry addressBookEntry = this.addressBookUsersById.get(userId);
        Map<String, YahooUser> map = this.usersById;
        synchronized (map) {
            if (!this.usersById.containsKey(userId)) {
                throw new IllegalStateException("No user on roster with this id: " + userId);
            }
            if (user.getGroupIds().isEmpty()) {
                for (String groupId : this.usersById.get(userId).getGroupIds()) {
                    user.addGroupId(groupId);
                }
            }
            if (addressBookEntry != null) {
                user = this.createMergedUser(addressBookEntry, userId, user);
            }
            this.usersById.put(userId, user);
        }
        log.trace((Object)("Updated user identified by userId: " + userId));
        this.broadcastEvent(new RosterEvent(this, user, RosterEventType.update));
    }

    @Override
    public boolean contains(Object user) {
        if (user == null) {
            throw new NullPointerException();
        }
        if (!(user instanceof YahooUser)) {
            throw new ClassCastException("This method needs a YahooUser value.");
        }
        return this.usersById.containsKey(((YahooUser)user).getId());
    }

    public boolean containsUser(String userId) {
        if (userId == null) {
            throw new NullPointerException();
        }
        if (userId.length() == 0) {
            throw new IllegalArgumentException("Argument 'userId' cannot be an empty String.");
        }
        for (String idOfUser : this.usersById.keySet()) {
            if (!idOfUser.toLowerCase().equals(userId.toLowerCase())) continue;
            if (!idOfUser.equals(userId)) {
                log.debug((Object)("contains user with mixed case: " + idOfUser + " looking for: " + userId));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.usersById.isEmpty();
    }

    @Override
    public int size() {
        return this.usersById.size();
    }

    @Override
    public Iterator<YahooUser> iterator() {
        return new Iterator<YahooUser>(){
            private final Iterator<YahooUser> i;
            {
                this.i = Roster.this.usersById.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public YahooUser next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public YahooUser getUser(String userId) {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("Argument 'userId' cannot be null or an empty String.");
        }
        return this.usersById.get(userId);
    }

    @Override
    public Object[] toArray() {
        return this.usersById.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.usersById.values().toArray(a);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends YahooUser> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispatch(FireEvent event) {
        SessionEvent sEvent = event.getEvent();
        ServiceType sType = event.getType();
        if (!(sEvent instanceof SessionFriendEvent) && sType != ServiceType.LIST) {
            log.trace((Object)("Ignoring non-list: " + event));
            return;
        }
        if (sType == ServiceType.LIST) {
            SessionListEvent lEvent = (SessionListEvent)sEvent;
            if (lEvent.getType() != ContactListType.Friends) {
                log.trace((Object)"Ignoring non-Friends list");
                return;
            }
            log.trace((Object)("Session just received the inital user list. Initializing this roster, as triggered by: " + event));
            Set<YahooUser> contacts = lEvent.getContacts();
            for (YahooUser contact : contacts) {
                this.syncedAdd(contact);
            }
            return;
        }
        SessionFriendEvent fEvent = (SessionFriendEvent)sEvent;
        YahooUser user = fEvent.getUser();
        if (fEvent.isFailure()) {
            return;
        }
        switch (event.getType()) {
            case FRIENDADD: {
                log.trace((Object)("Adding user to roster, as triggered by SessionFriendEvent: " + event));
                this.syncedAdd(user);
                break;
            }
            case CONTACTREJECT: 
            case FRIENDREMOVE: {
                log.trace((Object)("Removing user from roster as triggered by SessionFriendEvent: " + event));
                this.syncedRemove(user.getId());
                break;
            }
            case Y6_STATUS_UPDATE: {
                log.trace((Object)("Updating user on roster as triggered by SessionFriendEvent: " + event));
                this.syncedUpdate(user.getId(), user);
                break;
            }
            case Y7_AUTHORIZATION: {
                if (fEvent instanceof SessionFriendAcceptedEvent) {
                    log.debug((Object)("Adding user to roster, as triggered by SessionFriendAcceptedEvent: " + event));
                    this.syncedAdd(user);
                    break;
                }
                if (fEvent instanceof SessionFriendRejectedEvent) {
                    log.debug((Object)("Removing user from roster as triggered by SessionFriendRejectedEvent: " + event));
                    this.syncedRemove(user.getId());
                    break;
                }
                log.info((Object)("Ignoring SessionFriendEvent of type " + (Object)((Object)event.getType()) + " that contains an event that we" + " do not know how to process: " + fEvent));
                break;
            }
            default: {
                log.info((Object)("Ignoring SessionFriendEvent that came with an unsupported ServiceType: " + (Object)((Object)event.getType())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateAddressBook(YahooAddressBookEntry addressBookEntry) {
        String userId = addressBookEntry.getId();
        log.trace((Object)("Adding to address book: " + addressBookEntry));
        Map<String, YahooAddressBookEntry> map = this.addressBookUsersById;
        synchronized (map) {
            this.addressBookUsersById.put(userId, addressBookEntry);
        }
        boolean isUpdate = false;
        YahooUser newUser = null;
        Map<String, YahooUser> map2 = this.usersById;
        synchronized (map2) {
            YahooUser user = this.usersById.get(userId);
            if (user != null) {
                isUpdate = true;
                newUser = this.createMergedUser(addressBookEntry, userId, user);
                log.trace((Object)("updated user with addressBook: " + user));
                this.usersById.put(userId, newUser);
            }
        }
        if (isUpdate) {
            RosterEventType rosterType = RosterEventType.update;
            this.broadcastEvent(new RosterEvent(this, newUser, rosterType));
        }
        log.trace((Object)("Done Adding to address book: " + addressBookEntry));
    }

    private YahooUser createMergedUser(YahooAddressBookEntry addressBookEntry, String userId, YahooUser user) {
        HashSet<String> groupIds = new HashSet<String>(user.getGroupIds());
        YahooProtocol protocol = user.getProtocol();
        YahooUser newUser = new YahooUser(userId, groupIds, protocol, addressBookEntry);
        Status status = user.getStatus();
        String customMessage = user.getCustomStatusMessage();
        String customStatus = user.getCustomStatus();
        newUser.update(status, user.isOnChat(), user.isOnPager());
        if (status.equals((Object)Status.CUSTOM)) {
            newUser.setCustom(customMessage, customStatus);
        }
        return newUser;
    }
}

