/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.lang.ref.SoftReference;
import javax.media.Buffer;

class ShortArrayCache {
    private SoftReference<short[][]> elements;
    private int length;

    ShortArrayCache() {
    }

    public synchronized short[] allocateShortArray(int minSize) {
        short[][] elements;
        short[][] sArray = elements = this.elements == null ? (short[][])null : this.elements.get();
        if (elements != null) {
            for (int i = 0; i < this.length; ++i) {
                short[] element = elements[i];
                if (element == null || element.length < minSize) continue;
                elements[i] = null;
                return element;
            }
        }
        return new short[minSize];
    }

    public synchronized void deallocateShortArray(short[] shortArray) {
        Object elements;
        block12: {
            block11: {
                if (shortArray == null) {
                    return;
                }
                if (this.elements == null) break block11;
                short[][] sArray = this.elements.get();
                elements = sArray;
                if (sArray != null) break block12;
            }
            elements = new short[8][];
            this.elements = new SoftReference<short[][]>((short[][])elements);
            this.length = 0;
        }
        if (this.length != 0) {
            for (int i = 0; i < this.length; ++i) {
                if (elements[i] != shortArray) continue;
                return;
            }
        }
        if (this.length == ((short[][])elements).length) {
            int newLength = 0;
            for (int i = 0; i < this.length; ++i) {
                short[] element = elements[i];
                if (element == null) continue;
                if (i != newLength) {
                    elements[newLength] = element;
                    elements[i] = null;
                }
                ++newLength;
            }
            if (newLength == this.length) {
                short[][] newElements = new short[((short[][])elements).length + 4][];
                System.arraycopy(elements, 0, newElements, 0, ((short[][])elements).length);
                elements = newElements;
                this.elements = new SoftReference<short[][]>((short[][])elements);
            } else {
                this.length = newLength;
            }
        }
        elements[this.length++] = shortArray;
    }

    public short[] validateShortArraySize(Buffer buffer, int newSize) {
        short[] shortArray;
        Object data = buffer.getData();
        if (data instanceof short[]) {
            shortArray = (short[])data;
            if (shortArray.length < newSize) {
                this.deallocateShortArray(shortArray);
                shortArray = null;
            }
        } else {
            shortArray = null;
        }
        if (shortArray == null) {
            shortArray = this.allocateShortArray(newSize);
            buffer.setData(shortArray);
        }
        return shortArray;
    }
}

