/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.gsm;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.AudioFormatCompleter;
import net.sf.fmj.media.codec.audio.gsm.GSMDecoderUtil;

public class Decoder
extends AbstractCodec {
    private Buffer innerBuffer = new Buffer();
    private static final int PCM_BYTES = 320;
    private static final int GSM_BYTES = 33;
    private int innerDataLength = 0;
    byte[] innerContent;
    protected Format[] outputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 1, -1, 1, -1, -1.0, Format.byteArray)};
    private static final boolean TRACE = false;

    public Decoder() {
        this.inputFormats = new Format[]{new AudioFormat("gsm", 8000.0, 8, 1, -1, 1, 264, -1.0, Format.byteArray)};
    }

    public void close() {
    }

    public String getName() {
        return "GSM Decoder";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (!(format instanceof AudioFormat)) {
            return new Format[]{null};
        }
        AudioFormat audioFormat = (AudioFormat)format;
        if (!audioFormat.getEncoding().equals("gsm") || audioFormat.getSampleSizeInBits() != 8 && audioFormat.getSampleSizeInBits() != -1 || audioFormat.getChannels() != 1 && audioFormat.getChannels() != -1 || audioFormat.getSigned() != 1 && audioFormat.getSigned() != -1 || audioFormat.getFrameSizeInBits() != 264 && audioFormat.getFrameSizeInBits() != -1 || audioFormat.getDataType() != null && audioFormat.getDataType() != Format.byteArray) {
            return new Format[]{null};
        }
        AudioFormat audioFormat2 = new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, 1, audioFormat.getEndian(), 1, 16, -1.0, Format.byteArray);
        return new Format[]{audioFormat2};
    }

    private byte[] mergeArrays(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public void open() {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n;
        byte[] byArray = new byte[buffer.getLength()];
        System.arraycopy(buffer.getData(), buffer.getOffset(), byArray, 0, byArray.length);
        byte[] byArray2 = this.mergeArrays((byte[])this.innerBuffer.getData(), byArray);
        this.innerBuffer.setData(byArray2);
        this.innerBuffer.setLength(byArray2.length);
        this.innerDataLength = this.innerBuffer.getLength();
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        byte[] byArray3 = (byte[])buffer2.getData();
        if (byArray3 == null || byArray3.length < 320 * this.innerBuffer.getLength() / 33) {
            byArray3 = new byte[320 * (this.innerBuffer.getLength() / 33)];
            buffer2.setData(byArray3);
        }
        if (this.innerBuffer.getLength() < 33) {
            n = 4;
        } else {
            boolean bl = ((AudioFormat)this.outputFormat).getEndian() == 1;
            byArray3 = new byte[320 * (this.innerBuffer.getLength() / 33)];
            buffer2.setData(byArray3);
            buffer2.setLength(320 * (this.innerBuffer.getLength() / 33));
            GSMDecoderUtil.gsmDecode(bl, (byte[])this.innerBuffer.getData(), buffer.getOffset(), this.innerBuffer.getLength(), byArray3);
            buffer2.setFormat(this.outputFormat);
            n = 0;
            byte[] byArray4 = new byte[this.innerDataLength - this.innerDataLength / 33 * 33];
            this.innerContent = (byte[])this.innerBuffer.getData();
            System.arraycopy(this.innerContent, this.innerDataLength / 33 * 33, byArray4, 0, byArray4.length);
            buffer2.setOffset(0);
            this.innerBuffer.setLength(byArray4.length);
            this.innerBuffer.setData(byArray4);
        }
        return n;
    }

    public Format setInputFormat(Format format) {
        return super.setInputFormat(format);
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        return super.setOutputFormat(AudioFormatCompleter.complete(audioFormat));
    }
}

