/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

public class XmlConfigLocator {
    private static final ILogger LOGGER = Logger.getLogger(XmlConfigLocator.class);
    private InputStream in;
    private File configurationFile;
    private URL configurationUrl;

    public XmlConfigLocator() {
        try {
            if (this.loadFromSystemProperty()) {
                return;
            }
            if (this.loadFromWorkingDirectory()) {
                return;
            }
            if (this.loadHazelcastXmlFromClasspath()) {
                return;
            }
            this.loadDefaultConfigurationFromClasspath();
        }
        catch (RuntimeException e) {
            throw new HazelcastException(e);
        }
    }

    public InputStream getIn() {
        return this.in;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public URL getConfigurationUrl() {
        return this.configurationUrl;
    }

    private void loadDefaultConfigurationFromClasspath() {
        LOGGER.info("Loading 'hazelcast-default.xml' from classpath.");
        this.configurationUrl = Config.class.getClassLoader().getResource("hazelcast-default.xml");
        if (this.configurationUrl == null) {
            throw new HazelcastException("Could not find 'hazelcast-default.xml' in the classpath!This may be due to a wrong-packaged or corrupted jar file.");
        }
        this.in = Config.class.getClassLoader().getResourceAsStream("hazelcast-default.xml");
        if (this.in == null) {
            throw new HazelcastException("Could not load 'hazelcast-default.xml' from classpath");
        }
    }

    private boolean loadHazelcastXmlFromClasspath() {
        URL url = Config.class.getClassLoader().getResource("hazelcast.xml");
        if (url == null) {
            LOGGER.finest("Could not find 'hazelcast.xml' in classpath.");
            return false;
        }
        LOGGER.info("Loading 'hazelcast.xml' from classpath.");
        this.configurationUrl = url;
        this.in = Config.class.getClassLoader().getResourceAsStream("hazelcast.xml");
        if (this.in == null) {
            throw new HazelcastException("Could not load 'hazelcast.xml' from classpath");
        }
        return true;
    }

    private boolean loadFromWorkingDirectory() {
        File file = new File("hazelcast.xml");
        if (!file.exists()) {
            LOGGER.finest("Could not find 'hazelcast.xml' in working directory.");
            return false;
        }
        LOGGER.info("Loading 'hazelcast.xml' from working directory.");
        this.configurationFile = file;
        try {
            this.in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new HazelcastException("Failed to open file: " + file.getAbsolutePath(), e);
        }
        return true;
    }

    private boolean loadFromSystemProperty() {
        String configSystemProperty = System.getProperty("hazelcast.config");
        if (configSystemProperty == null) {
            LOGGER.finest("Could not 'hazelcast.config' System property");
            return false;
        }
        LOGGER.info("Loading configuration " + configSystemProperty + " from System property 'hazelcast.config'");
        if (configSystemProperty.startsWith("classpath:")) {
            this.loadSystemPropertyClassPathResource(configSystemProperty);
        } else {
            this.loadSystemPropertyFileResource(configSystemProperty);
        }
        return true;
    }

    private void loadSystemPropertyFileResource(String configSystemProperty) {
        this.configurationFile = new File(configSystemProperty);
        LOGGER.info("Using configuration file at " + this.configurationFile.getAbsolutePath());
        if (!this.configurationFile.exists()) {
            String msg = "Config file at '" + this.configurationFile.getAbsolutePath() + "' doesn't exist.";
            throw new HazelcastException(msg);
        }
        try {
            this.in = new FileInputStream(this.configurationFile);
        }
        catch (FileNotFoundException e) {
            throw new HazelcastException("Failed to open file: " + this.configurationFile.getAbsolutePath(), e);
        }
    }

    private void loadSystemPropertyClassPathResource(String configSystemProperty) {
        String resource = configSystemProperty.substring("classpath:".length());
        LOGGER.info("Using classpath resource at " + resource);
        if (resource.isEmpty()) {
            throw new HazelcastException("classpath resource can't be empty");
        }
        this.in = Config.class.getClassLoader().getResourceAsStream(resource);
        if (this.in == null) {
            throw new HazelcastException("Could not load classpath resource: " + resource);
        }
        this.configurationUrl = Config.class.getResource(resource);
    }
}

