/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.i18n.ErrorBundle;
import org.bouncycastle.i18n.filter.UntrustedInput;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jce.provider.PKIXPolicyNode;
import org.bouncycastle.x509.CertPathReviewerException;

public class PKIXCertPathReviewer
extends CertPathValidatorUtilities {
    private static final String QC_STATEMENT = X509Extensions.QCStatements.getId();
    private static final String CRL_DIST_POINTS = X509Extensions.CRLDistributionPoints.getId();
    private static final String AUTH_INFO_ACCESS = X509Extensions.AuthorityInfoAccess.getId();
    private static final String RESOURCE_NAME = "org.bouncycastle.x509.CertPathReviewerMessages";
    protected CertPath certPath;
    protected PKIXParameters pkixParams;
    protected Date validDate;
    protected List certs;
    protected int n;
    protected List[] notifications;
    protected List[] errors;
    protected TrustAnchor trustAnchor;
    protected PublicKey subjectPublicKey;
    protected PolicyNode policyTree;

    public PKIXCertPathReviewer(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathReviewerException {
        if (certPath == null) {
            throw new NullPointerException("certPath was null");
        }
        this.certPath = certPath;
        this.certs = certPath.getCertificates();
        this.n = this.certs.size();
        if (this.certs.isEmpty()) {
            throw new CertPathReviewerException(new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.emptyCertPath"));
        }
        this.pkixParams = (PKIXParameters)pKIXParameters.clone();
        this.validDate = PKIXCertPathReviewer.getValidDate(this.pkixParams);
        this.notifications = null;
        this.errors = null;
        this.trustAnchor = null;
        this.subjectPublicKey = null;
        this.policyTree = null;
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getCertPathSize() {
        return this.n;
    }

    public List[] getErrors() {
        this.doChecks();
        return this.errors;
    }

    public List getErrors(int n) {
        this.doChecks();
        return this.errors[n + 1];
    }

    public List[] getNotifications() {
        this.doChecks();
        return this.notifications;
    }

    public List getNotifications(int n) {
        this.doChecks();
        return this.notifications[n + 1];
    }

    public PolicyNode getPolicyTree() {
        this.doChecks();
        return this.policyTree;
    }

    public PublicKey getSubjectPublicKey() {
        this.doChecks();
        return this.subjectPublicKey;
    }

    public TrustAnchor getTrustAnchor() {
        this.doChecks();
        return this.trustAnchor;
    }

    public boolean isValidCertPath() {
        this.doChecks();
        boolean bl = true;
        for (int i = 0; i < this.errors.length; ++i) {
            if (this.errors[i].isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void addNotification(ErrorBundle errorBundle) {
        this.notifications[0].add(errorBundle);
    }

    protected void addNotification(ErrorBundle errorBundle, int n) {
        if (n < -1 || n >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.notifications[n + 1].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle) {
        this.errors[0].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle, int n) {
        if (n < -1 || n >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.errors[n + 1].add(errorBundle);
    }

    protected void doChecks() {
        if (this.notifications == null) {
            this.notifications = new List[this.n + 1];
            this.errors = new List[this.n + 1];
            for (int i = 0; i < this.notifications.length; ++i) {
                this.notifications[i] = new ArrayList();
                this.errors[i] = new ArrayList();
            }
            this.checkSignatures();
            this.checkNameConstraints();
            this.checkPathLength();
            this.checkPolicy();
            this.checkCriticalExtensions();
        }
    }

    private void checkNameConstraints() {
        X509Certificate x509Certificate = null;
        Set set = new HashSet();
        Set set2 = new HashSet();
        Set set3 = new HashSet();
        Set set4 = new HashSet();
        Set set5 = new HashSet();
        Set set6 = new HashSet();
        try {
            for (int i = this.certs.size() - 1; i > 0; --i) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                int n = this.n - i;
                x509Certificate = (X509Certificate)this.certs.get(i);
                if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                    object6 = PKIXCertPathReviewer.getSubjectPrincipal(x509Certificate);
                    object5 = new ASN1InputStream(new ByteArrayInputStream(((X500Principal)object6).getEncoded()));
                    try {
                        object4 = (ASN1Sequence)((ASN1InputStream)object5).readObject();
                    }
                    catch (IOException iOException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncSubjectNameError", new Object[]{new UntrustedInput(object6)});
                        throw new CertPathReviewerException(errorBundle, (Throwable)iOException, this.certPath, i);
                    }
                    try {
                        PKIXCertPathReviewer.checkPermittedDN(set, (ASN1Sequence)object4);
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput(((X500Principal)object6).getName())});
                        throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException, this.certPath, i);
                    }
                    try {
                        PKIXCertPathReviewer.checkExcludedDN(set4, (ASN1Sequence)object4);
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedDN", new Object[]{new UntrustedInput(((X500Principal)object6).getName())});
                        throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException, this.certPath, i);
                    }
                    try {
                        object3 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, SUBJECT_ALTERNATIVE_NAME);
                    }
                    catch (AnnotatedException annotatedException) {
                        object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.subjAltNameExtError");
                        throw new CertPathReviewerException((ErrorBundle)object2, (Throwable)annotatedException, this.certPath, i);
                    }
                    if (object3 != null) {
                        block40: for (int j = 0; j < ((ASN1Sequence)object3).size(); ++j) {
                            object2 = (ASN1TaggedObject)((ASN1Sequence)object3).getObjectAt(j);
                            switch (((ASN1TaggedObject)object2).getTagNo()) {
                                case 1: {
                                    Object object7;
                                    object = DERIA5String.getInstance((ASN1TaggedObject)object2, true).getString();
                                    try {
                                        PKIXCertPathReviewer.checkPermittedEmail(set2, (String)object);
                                    }
                                    catch (CertPathValidatorException certPathValidatorException) {
                                        object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedEmail", new Object[]{new UntrustedInput(object)});
                                        throw new CertPathReviewerException((ErrorBundle)object7, (Throwable)certPathValidatorException, this.certPath, i);
                                    }
                                    try {
                                        PKIXCertPathReviewer.checkExcludedEmail(set5, (String)object);
                                        continue block40;
                                    }
                                    catch (CertPathValidatorException certPathValidatorException) {
                                        object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedEmail", new Object[]{new UntrustedInput(object)});
                                        throw new CertPathReviewerException((ErrorBundle)object7, (Throwable)certPathValidatorException, this.certPath, i);
                                    }
                                }
                                case 4: {
                                    ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((ASN1TaggedObject)object2, true);
                                    try {
                                        PKIXCertPathReviewer.checkPermittedDN(set, aSN1Sequence);
                                    }
                                    catch (CertPathValidatorException certPathValidatorException) {
                                        X509Name x509Name = new X509Name(aSN1Sequence);
                                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput(x509Name)});
                                        throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException, this.certPath, i);
                                    }
                                    try {
                                        PKIXCertPathReviewer.checkExcludedDN(set4, aSN1Sequence);
                                        continue block40;
                                    }
                                    catch (CertPathValidatorException certPathValidatorException) {
                                        X509Name x509Name = new X509Name(aSN1Sequence);
                                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedDN", new Object[]{new UntrustedInput(x509Name)});
                                        throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException, this.certPath, i);
                                    }
                                }
                                case 7: {
                                    Object object7 = ASN1OctetString.getInstance((ASN1TaggedObject)object2, true).getOctets();
                                    try {
                                        PKIXCertPathReviewer.checkPermittedIP(set3, object7);
                                    }
                                    catch (CertPathValidatorException certPathValidatorException) {
                                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedIP", new Object[]{this.IPtoString((byte[])object7)});
                                        throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException, this.certPath, i);
                                    }
                                    try {
                                        PKIXCertPathReviewer.checkExcludedIP(set6, object7);
                                        continue block40;
                                    }
                                    catch (CertPathValidatorException certPathValidatorException) {
                                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedIP", new Object[]{this.IPtoString((byte[])object7)});
                                        throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException, this.certPath, i);
                                    }
                                }
                            }
                        }
                    }
                }
                try {
                    object6 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, NAME_CONSTRAINTS);
                }
                catch (AnnotatedException annotatedException) {
                    object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncExtError");
                    throw new CertPathReviewerException((ErrorBundle)object4, (Throwable)annotatedException, this.certPath, i);
                }
                if (object6 == null) continue;
                object5 = new NameConstraints((ASN1Sequence)object6);
                object4 = ((NameConstraints)object5).getPermittedSubtrees();
                if (object4 != null) {
                    object3 = ((ASN1Sequence)object4).getObjects();
                    while (object3.hasMoreElements()) {
                        GeneralSubtree generalSubtree = GeneralSubtree.getInstance(object3.nextElement());
                        object2 = generalSubtree.getBase();
                        switch (((GeneralName)object2).getTagNo()) {
                            case 1: {
                                set2 = PKIXCertPathReviewer.intersectEmail(set2, DERIA5String.getInstance(((GeneralName)object2).getName()).getString());
                                break;
                            }
                            case 4: {
                                set = PKIXCertPathReviewer.intersectDN(set, (ASN1Sequence)((GeneralName)object2).getName());
                                break;
                            }
                            case 7: {
                                set3 = PKIXCertPathReviewer.intersectIP(set3, ASN1OctetString.getInstance(((GeneralName)object2).getName()).getOctets());
                            }
                        }
                    }
                }
                if ((object3 = ((NameConstraints)object5).getExcludedSubtrees()) == null) continue;
                Enumeration enumeration = ((ASN1Sequence)object3).getObjects();
                while (enumeration.hasMoreElements()) {
                    object2 = GeneralSubtree.getInstance(enumeration.nextElement());
                    object = ((GeneralSubtree)object2).getBase();
                    switch (((GeneralName)object).getTagNo()) {
                        case 1: {
                            set5 = PKIXCertPathReviewer.unionEmail(set5, DERIA5String.getInstance(((GeneralName)object).getName()).getString());
                            break;
                        }
                        case 4: {
                            set4 = PKIXCertPathReviewer.unionDN(set4, (ASN1Sequence)((GeneralName)object).getName());
                            break;
                        }
                        case 7: {
                            set6 = PKIXCertPathReviewer.unionIP(set6, ASN1OctetString.getInstance(((GeneralName)object).getName()).getOctets());
                        }
                    }
                }
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
        }
    }

    private void checkPathLength() {
        int n = this.n;
        int n2 = 0;
        X509Certificate x509Certificate = null;
        for (int i = this.certs.size() - 1; i > 0; --i) {
            int n3;
            BigInteger bigInteger;
            Object object;
            int n4 = this.n - i;
            x509Certificate = (X509Certificate)this.certs.get(i);
            if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                if (n <= 0) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pathLenghtExtended");
                    this.addError((ErrorBundle)object);
                }
                --n;
                ++n2;
            }
            try {
                object = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.processLengthConstError");
                this.addError(errorBundle, i);
                object = null;
            }
            if (object == null || (bigInteger = ((BasicConstraints)object).getPathLenConstraint()) == null || (n3 = bigInteger.intValue()) >= n) continue;
            n = n3;
        }
        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.totalPathLength", new Object[]{new Integer(n2)});
        this.addNotification(errorBundle);
    }

    private void checkSignatures() {
        Object object;
        Object object2;
        Object object3;
        TrustAnchor trustAnchor = null;
        Object object4 = null;
        Object object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathValidDate", new Object[]{this.validDate, new Date()});
        this.addNotification((ErrorBundle)object5);
        try {
            object5 = (X509Certificate)this.certs.get(this.certs.size() - 1);
            object3 = this.getTrustAnchors((X509Certificate)object5, this.pkixParams.getTrustAnchors());
            if (object3.size() > 1) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.conflictingTrustAnchors", new Object[]{new Integer(object3.size()), new UntrustedInput(((X509Certificate)object5).getIssuerX500Principal())});
                this.addError((ErrorBundle)object2);
            } else if (object3.isEmpty()) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noTrustAnchorFound", new Object[]{new UntrustedInput(((X509Certificate)object5).getIssuerX500Principal()), new Integer(this.pkixParams.getTrustAnchors().size())});
                this.addError((ErrorBundle)object2);
            } else {
                trustAnchor = (TrustAnchor)object3.iterator().next();
                object2 = trustAnchor.getTrustedCert() != null ? trustAnchor.getTrustedCert().getPublicKey() : trustAnchor.getCAPublicKey();
                try {
                    ((Certificate)object5).verify((PublicKey)object2);
                }
                catch (Exception exception) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustButInvalidCert");
                    this.addError((ErrorBundle)object);
                    trustAnchor = null;
                }
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage());
        }
        if (trustAnchor != null) {
            object5 = trustAnchor.getTrustedCert();
            try {
                object4 = object5 != null ? PKIXCertPathReviewer.getSubjectPrincipal((X509Certificate)object5) : new X500Principal(trustAnchor.getCAName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustDNInvalid", new Object[]{new UntrustedInput(trustAnchor.getCAName())});
                this.addError((ErrorBundle)object2);
            }
        }
        object5 = null;
        object3 = object4;
        object2 = null;
        AlgorithmIdentifier algorithmIdentifier = null;
        object = null;
        DEREncodable dEREncodable = null;
        if (trustAnchor != null) {
            object2 = trustAnchor.getTrustedCert();
            object5 = object2 != null ? ((Certificate)object2).getPublicKey() : trustAnchor.getCAPublicKey();
            try {
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object5);
                object = algorithmIdentifier.getObjectId();
                dEREncodable = algorithmIdentifier.getParameters();
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustPubKeyError");
                this.addError(errorBundle);
                algorithmIdentifier = null;
            }
        }
        X509Certificate x509Certificate = null;
        for (int i = this.certs.size() - 1; i >= 0; --i) {
            Object object6;
            Object object7;
            Object object8;
            int n = this.n - i;
            x509Certificate = (X509Certificate)this.certs.get(i);
            if (object5 != null) {
                try {
                    x509Certificate.verify((PublicKey)object5, "BC");
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{generalSecurityException.getMessage(), generalSecurityException});
                    this.addError((ErrorBundle)object8, i);
                }
            } else {
                object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.NoIssuerPublicKey");
                this.addError((ErrorBundle)object7, i);
            }
            try {
                x509Certificate.checkValidity(this.validDate);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateNotYetValid", new Object[]{x509Certificate.getNotBefore()});
                this.addError((ErrorBundle)object8, i);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateExpired", new Object[]{x509Certificate.getNotAfter()});
                this.addError((ErrorBundle)object8, i);
            }
            if (this.pkixParams.isRevocationEnabled()) {
                ErrorBundle errorBundle;
                Object object9;
                object7 = null;
                try {
                    object8 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, CRL_DIST_POINTS);
                    if (object8 != null) {
                        object7 = CRLDistPoint.getInstance(object8);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPtExtError");
                    this.addError((ErrorBundle)object6, i);
                }
                object8 = null;
                try {
                    object6 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, AUTH_INFO_ACCESS);
                    if (object6 != null) {
                        object8 = AuthorityInformationAccess.getInstance(object6);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlAuthInfoAccError");
                    this.addError((ErrorBundle)object9, i);
                }
                object6 = this.getCRLDistUrls((CRLDistPoint)object7, (AuthorityInformationAccess)object8);
                object9 = this.getOCSPUrls((AuthorityInformationAccess)object8);
                Iterator iterator = ((Vector)object6).iterator();
                while (iterator.hasNext()) {
                    errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPoint", new Object[]{new UntrustedInput(iterator.next())});
                    this.addNotification(errorBundle, i);
                }
                iterator = ((Vector)object9).iterator();
                while (iterator.hasNext()) {
                    errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ocspLocation", new Object[]{new UntrustedInput(iterator.next())});
                    this.addNotification(errorBundle, i);
                }
                try {
                    this.checkCRLs(this.pkixParams, x509Certificate, this.validDate, (X509Certificate)object2, (PublicKey)object5, (Vector)object6, i);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addError(certPathReviewerException.getErrorMessage(), i);
                }
            }
            if (object3 != null && !x509Certificate.getIssuerX500Principal().equals(object3)) {
                object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certWrongIssuer", new Object[]{((X500Principal)object3).getName(), x509Certificate.getIssuerX500Principal().getName()});
                this.addError((ErrorBundle)object7, i);
            }
            if (n != this.n) {
                if (x509Certificate != null && x509Certificate.getVersion() == 1) {
                    object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                    this.addError((ErrorBundle)object7, i);
                }
                try {
                    object7 = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
                    if (object7 != null) {
                        if (!((BasicConstraints)object7).isCA()) {
                            object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                            this.addError((ErrorBundle)object8, i);
                        }
                    } else {
                        object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBasicConstraints");
                        this.addError((ErrorBundle)object8, i);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.errorProcesingBC");
                    this.addError((ErrorBundle)object6, i);
                }
                object8 = x509Certificate.getKeyUsage();
                if (object8 != null && object8[5] == false) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCertSign");
                    this.addError((ErrorBundle)object6, i);
                }
            }
            object2 = x509Certificate;
            object3 = x509Certificate.getSubjectX500Principal();
            object5 = x509Certificate.getPublicKey();
            try {
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object5);
                object = algorithmIdentifier.getObjectId();
                dEREncodable = algorithmIdentifier.getParameters();
                continue;
            }
            catch (CertPathValidatorException certPathValidatorException) {
                object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pubKeyError");
                this.addError((ErrorBundle)object8, i);
                algorithmIdentifier = null;
                object = null;
                dEREncodable = null;
            }
        }
        this.trustAnchor = trustAnchor;
        this.subjectPublicKey = object5;
    }

    /*
     * WARNING - void declaration
     */
    private void checkPolicy() {
        Set<String> set = this.pkixParams.getInitialPolicies();
        List[] listArray = new ArrayList[this.n + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("2.5.29.32.0");
        Object object = new PKIXPolicyNode(new ArrayList(), 0, hashSet, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(object);
        int n = this.pkixParams.isExplicitPolicyRequired() ? 0 : this.n + 1;
        int n2 = this.pkixParams.isAnyPolicyInhibited() ? 0 : this.n + 1;
        int n3 = this.pkixParams.isPolicyMappingInhibited() ? 0 : this.n + 1;
        Object object2 = null;
        X509Certificate x509Certificate = null;
        try {
            Object certPathValidatorException;
            Object object4;
            Object object5;
            Object object6;
            int n4;
            for (n4 = this.certs.size() - 1; n4 >= 0; --n4) {
                int n5 = this.n - n4;
                x509Certificate = (X509Certificate)this.certs.get(n4);
                try {
                    object6 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, CERTIFICATE_POLICIES);
                }
                catch (AnnotatedException annotatedException) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                    throw new CertPathReviewerException((ErrorBundle)object5, (Throwable)annotatedException, this.certPath, n4);
                }
                if (object6 != null && object != null) {
                    boolean n6;
                    Object object7;
                    Object object8;
                    Object object9;
                    object4 = ((ASN1Sequence)object6).getObjects();
                    object5 = new HashSet();
                    while (object4.hasMoreElements()) {
                        object9 = PolicyInformation.getInstance(object4.nextElement());
                        object8 = ((PolicyInformation)object9).getPolicyIdentifier();
                        object5.add(((DERObjectIdentifier)object8).getId());
                        if ("2.5.29.32.0".equals(((DERObjectIdentifier)object8).getId())) continue;
                        try {
                            object7 = PKIXCertPathReviewer.getQualifierSet(((PolicyInformation)object9).getPolicyQualifiers());
                        }
                        catch (CertPathValidatorException certPathValidatorException2) {
                            certPathValidatorException = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                            throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, (Throwable)certPathValidatorException2, this.certPath, n4);
                        }
                        n6 = PKIXCertPathReviewer.processCertD1i(n5, listArray, (DERObjectIdentifier)object8, object7);
                        if (n6) continue;
                        PKIXCertPathReviewer.processCertD1ii(n5, listArray, (DERObjectIdentifier)object8, object7);
                    }
                    if (object2 == null || object2.contains("2.5.29.32.0")) {
                        object2 = object5;
                    } else {
                        object9 = object2.iterator();
                        object8 = new HashSet();
                        while (object9.hasNext()) {
                            object7 = object9.next();
                            if (!object5.contains(object7)) continue;
                            object8.add(object7);
                        }
                        object2 = object8;
                    }
                    if (n2 > 0 || n5 < this.n && PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                        object4 = ((ASN1Sequence)object6).getObjects();
                        while (object4.hasMoreElements()) {
                            void pKIXPolicyNode;
                            object9 = PolicyInformation.getInstance(object4.nextElement());
                            if (!"2.5.29.32.0".equals(((PolicyInformation)object9).getPolicyIdentifier().getId())) continue;
                            try {
                                object8 = PKIXCertPathReviewer.getQualifierSet(((PolicyInformation)object9).getPolicyQualifiers());
                            }
                            catch (CertPathValidatorException certPathValidatorException3) {
                                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException3, this.certPath, n4);
                            }
                            object7 = listArray[n5 - 1];
                            n6 = false;
                            while (pKIXPolicyNode < object7.size()) {
                                certPathValidatorException = (PKIXPolicyNode)object7.get((int)pKIXPolicyNode);
                                for (Set set2 : ((PKIXPolicyNode)certPathValidatorException).getExpectedPolicies()) {
                                    Object object3;
                                    String string;
                                    if (set2 instanceof String) {
                                        string = (String)((Object)set2);
                                    } else {
                                        if (!(set2 instanceof DERObjectIdentifier)) continue;
                                        string = ((DERObjectIdentifier)((Object)set2)).getId();
                                    }
                                    boolean bl = false;
                                    Iterator iterator = ((PKIXPolicyNode)certPathValidatorException).getChildren();
                                    while (iterator.hasNext()) {
                                        object3 = (PKIXPolicyNode)iterator.next();
                                        if (!string.equals(((PKIXPolicyNode)object3).getValidPolicy())) continue;
                                        bl = true;
                                    }
                                    if (bl) continue;
                                    object3 = new HashSet();
                                    object3.add(string);
                                    PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n5, (Set)object3, (PolicyNode)certPathValidatorException, (Set)object8, string, false);
                                    ((PKIXPolicyNode)certPathValidatorException).addChild(pKIXPolicyNode2);
                                    listArray[n5].add(pKIXPolicyNode2);
                                }
                                ++pKIXPolicyNode;
                            }
                            break block30;
                        }
                    }
                    for (int i = n5 - 1; i >= 0; --i) {
                        object8 = listArray[i];
                        for (int j = 0; j < object8.size() && ((i = (PKIXPolicyNode)object8.get(j)).hasChildren() || (object = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)object, listArray, i)) != null); ++j) {
                        }
                    }
                    Set<String> set3 = x509Certificate.getCriticalExtensionOIDs();
                    if (set3 != null) {
                        void aSN1Sequence;
                        boolean bl = set3.contains(CERTIFICATE_POLICIES);
                        List list = listArray[n5];
                        boolean dERObjectIdentifier2 = false;
                        while (aSN1Sequence < list.size()) {
                            certPathValidatorException = (PKIXPolicyNode)list.get((int)aSN1Sequence);
                            ((PKIXPolicyNode)certPathValidatorException).setCritical(bl);
                            ++aSN1Sequence;
                        }
                    }
                }
                if (object6 == null) {
                    object = null;
                }
                if (n <= 0 && object == null) {
                    object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidPolicyTree");
                    throw new CertPathReviewerException((ErrorBundle)object4);
                }
                if (n5 == this.n) continue;
                try {
                    object4 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_MAPPINGS);
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyMapExtError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException, this.certPath, n4);
                }
                if (object4 != null) {
                    object5 = (ASN1Sequence)object4;
                    for (int i = 0; i < ((ASN1Sequence)object5).size(); ++i) {
                        ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object5).getObjectAt(i);
                        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
                        DERObjectIdentifier string = (DERObjectIdentifier)aSN1Sequence.getObjectAt(1);
                        if ("2.5.29.32.0".equals(dERObjectIdentifier.getId())) {
                            certPathValidatorException = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                            throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, this.certPath, n4);
                        }
                        if (!"2.5.29.32.0".equals(string.getId())) continue;
                        certPathValidatorException = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                        throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, this.certPath, n4);
                    }
                }
                if (object4 != null) {
                    Iterator iterator;
                    object5 = (ASN1Sequence)object4;
                    HashMap hashMap = new HashMap();
                    HashSet<Object> hashSet2 = new HashSet<Object>();
                    for (int i = 0; i < ((ASN1Sequence)object5).size(); ++i) {
                        Set set2;
                        ASN1Sequence iterator2 = (ASN1Sequence)((ASN1Sequence)object5).getObjectAt(i);
                        certPathValidatorException = ((DERObjectIdentifier)iterator2.getObjectAt(0)).getId();
                        iterator = ((DERObjectIdentifier)iterator2.getObjectAt(1)).getId();
                        if (!hashMap.containsKey(certPathValidatorException)) {
                            set2 = new HashSet();
                            set2.add(iterator);
                            hashMap.put(certPathValidatorException, set2);
                            hashSet2.add(certPathValidatorException);
                            continue;
                        }
                        set2 = (Set)hashMap.get(certPathValidatorException);
                        set2.add(iterator);
                    }
                    for (String pKIXPolicyNode : hashSet2) {
                        if (n3 > 0) {
                            try {
                                PKIXCertPathReviewer.prepareNextCertB1(n5, listArray, pKIXPolicyNode, hashMap, x509Certificate);
                                continue;
                            }
                            catch (AnnotatedException annotatedException) {
                                iterator = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                                throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)annotatedException, this.certPath, n4);
                            }
                            catch (CertPathValidatorException certPathValidatorException4) {
                                iterator = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)certPathValidatorException4, this.certPath, n4);
                            }
                        }
                        if (n3 > 0) continue;
                        object = PKIXCertPathReviewer.prepareNextCertB2(n5, listArray, pKIXPolicyNode, (PKIXPolicyNode)object);
                    }
                }
                if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                    if (n != 0) {
                        --n;
                    }
                    if (n3 != 0) {
                        --n3;
                    }
                    if (n2 != 0) {
                        --n2;
                    }
                }
                try {
                    object5 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS);
                    if (object5 != null) {
                        Enumeration enumeration = ((ASN1Sequence)object5).getObjects();
                        while (enumeration.hasMoreElements()) {
                            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                            switch (aSN1TaggedObject.getTagNo()) {
                                case 0: {
                                    int n7 = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                    if (n7 >= n) break;
                                    n = n7;
                                    break;
                                }
                                case 1: {
                                    int n7 = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                    if (n7 >= n3) break;
                                    n3 = n7;
                                }
                            }
                        }
                    }
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n4);
                }
                try {
                    int n8;
                    object5 = (DERInteger)PKIXCertPathReviewer.getExtensionValue(x509Certificate, INHIBIT_ANY_POLICY);
                    if (object5 == null || (n8 = ((DERInteger)object5).getValue().intValue()) >= n2) continue;
                    n2 = n8;
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyInhibitExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n4);
                }
            }
            if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate) && n > 0) {
                --n;
            }
            try {
                object6 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS);
                if (object6 != null) {
                    object4 = ((ASN1Sequence)object6).getObjects();
                    while (object4.hasMoreElements()) {
                        object5 = (ASN1TaggedObject)object4.nextElement();
                        switch (((ASN1TaggedObject)object5).getTagNo()) {
                            case 0: {
                                int n9 = DERInteger.getInstance(object5).getValue().intValue();
                                if (n9 != 0) break;
                                n = 0;
                            }
                        }
                    }
                }
            }
            catch (AnnotatedException annotatedException) {
                object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                throw new CertPathReviewerException((ErrorBundle)object4, this.certPath, n4);
            }
            if (object == null) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                    throw new CertPathReviewerException((ErrorBundle)object4, this.certPath, n4);
                }
                object6 = null;
            } else if (PKIXCertPathReviewer.isAnyPolicy(set)) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    if (object2.isEmpty()) {
                        object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                        throw new CertPathReviewerException((ErrorBundle)object4, this.certPath, n4);
                    }
                    object4 = new HashSet();
                    for (int i = 0; i < listArray.length; ++i) {
                        ArrayList arrayList = listArray[i];
                        for (int j = 0; j < arrayList.size(); ++j) {
                            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(j);
                            if (!"2.5.29.32.0".equals(pKIXPolicyNode.getValidPolicy())) continue;
                            Iterator iterator = pKIXPolicyNode.getChildren();
                            while (iterator.hasNext()) {
                                object4.add(iterator.next());
                            }
                        }
                    }
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)iterator.next();
                        String string = pKIXPolicyNode.getValidPolicy();
                        if (object2.contains(string)) continue;
                    }
                    if (object != null) {
                        for (int i = this.n - 1; i >= 0; --i) {
                            List list = listArray[i];
                            for (int j = 0; j < list.size(); ++j) {
                                PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(j);
                                if (pKIXPolicyNode.hasChildren()) continue;
                                object = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)object, listArray, pKIXPolicyNode);
                            }
                        }
                    }
                }
                object6 = object;
            } else {
                object4 = new HashSet();
                for (int i = 0; i < listArray.length; ++i) {
                    ArrayList arrayList = listArray[i];
                    for (int j = 0; j < arrayList.size(); ++j) {
                        PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(j);
                        if (!"2.5.29.32.0".equals(pKIXPolicyNode.getValidPolicy())) continue;
                        Iterator iterator = pKIXPolicyNode.getChildren();
                        while (iterator.hasNext()) {
                            certPathValidatorException = (PKIXPolicyNode)iterator.next();
                            if ("2.5.29.32.0".equals(((PKIXPolicyNode)certPathValidatorException).getValidPolicy())) continue;
                            object4.add(certPathValidatorException);
                        }
                    }
                }
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)iterator.next();
                    String string = pKIXPolicyNode.getValidPolicy();
                    if (set.contains(string)) continue;
                    object = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)object, listArray, pKIXPolicyNode);
                }
                if (object != null) {
                    for (int i = this.n - 1; i >= 0; --i) {
                        ArrayList arrayList = listArray[i];
                        for (int j = 0; j < arrayList.size(); ++j) {
                            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(j);
                            if (pKIXPolicyNode.hasChildren()) continue;
                            object = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)object, listArray, pKIXPolicyNode);
                        }
                    }
                }
                object6 = object;
            }
            if (n <= 0 && object6 == null) {
                object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicy");
                throw new CertPathReviewerException((ErrorBundle)object4);
            }
            object = object6;
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
            object = null;
        }
    }

    private void checkCriticalExtensions() {
        List<PKIXCertPathChecker> list = this.pkixParams.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> iterator = list.iterator();
        try {
            try {
                while (iterator.hasNext()) {
                    iterator.next().init(false);
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathCheckerError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException});
                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException);
            }
            X509Certificate x509Certificate = null;
            for (int i = this.certs.size() - 1; i >= 0; --i) {
                x509Certificate = (X509Certificate)this.certs.get(i);
                HashSet<String> hashSet = new HashSet<String>(x509Certificate.getCriticalExtensionOIDs());
                hashSet.remove(KEY_USAGE);
                hashSet.remove(CERTIFICATE_POLICIES);
                hashSet.remove(POLICY_MAPPINGS);
                hashSet.remove(INHIBIT_ANY_POLICY);
                hashSet.remove(ISSUING_DISTRIBUTION_POINT);
                hashSet.remove(DELTA_CRL_INDICATOR);
                hashSet.remove(POLICY_CONSTRAINTS);
                hashSet.remove(BASIC_CONSTRAINTS);
                hashSet.remove(SUBJECT_ALTERNATIVE_NAME);
                hashSet.remove(NAME_CONSTRAINTS);
                if (hashSet.contains(QC_STATEMENT) && this.processQcStatements(x509Certificate, i)) {
                    hashSet.remove(QC_STATEMENT);
                }
                Iterator<PKIXCertPathChecker> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    try {
                        iterator2.next().check(x509Certificate, hashSet);
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.criticalExtensionError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException});
                        throw new CertPathReviewerException(errorBundle, certPathValidatorException.getCause(), this.certPath, i);
                    }
                }
                if (hashSet.isEmpty()) continue;
                ErrorBundle errorBundle = hashSet.size() == 1 ? new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknownCriticalExt", new Object[]{hashSet.iterator().next()}) : new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknownCriticalExts", new Object[]{new UntrustedInput(hashSet)});
                throw new CertPathReviewerException(errorBundle, this.certPath, i);
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
        }
    }

    private boolean processQcStatements(X509Certificate x509Certificate, int n) {
        try {
            boolean bl = false;
            ASN1Sequence aSN1Sequence = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, QC_STATEMENT);
            for (int i = 0; i < aSN1Sequence.size(); ++i) {
                Object object;
                QCStatement qCStatement = QCStatement.getInstance(aSN1Sequence.getObjectAt(i));
                if (QCStatement.id_etsi_qcs_QcCompliance.equals(qCStatement.getStatementId())) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcEuCompliance");
                    this.addNotification((ErrorBundle)object, n);
                    continue;
                }
                if (QCStatement.id_qcs_pkixQCSyntax_v1.equals(qCStatement.getStatementId())) continue;
                if (QCStatement.id_etsi_qcs_QcSSCD.equals(qCStatement.getStatementId())) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcSSCD");
                    this.addNotification((ErrorBundle)object, n);
                    continue;
                }
                if (QCStatement.id_etsi_qcs_LimiteValue.equals(qCStatement.getStatementId())) {
                    object = MonetaryValue.getInstance(qCStatement.getStatementInfo());
                    Iso4217CurrencyCode iso4217CurrencyCode = ((MonetaryValue)object).getCurrency();
                    double d = ((MonetaryValue)object).getAmount().doubleValue() * Math.pow(10.0, ((MonetaryValue)object).getExponent().doubleValue());
                    ErrorBundle errorBundle = ((MonetaryValue)object).getCurrency().isAlphabetic() ? new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueAlpha", new Object[]{((MonetaryValue)object).getCurrency().getAlphabetic(), new Double(d), object}) : new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueNum", new Object[]{new Integer(((MonetaryValue)object).getCurrency().getNumeric()), new Double(d), object});
                    this.addNotification(errorBundle, n);
                    continue;
                }
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcUnknownStatement", new Object[]{qCStatement.getStatementId(), new UntrustedInput(qCStatement)});
                this.addNotification((ErrorBundle)object, n);
                bl = true;
            }
            return !bl;
        }
        catch (AnnotatedException annotatedException) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcStatementExtError");
            this.addError(errorBundle, n);
            return false;
        }
    }

    private String IPtoString(byte[] byArray) {
        String string;
        try {
            string = InetAddress.getByAddress(byArray).getHostAddress();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i != byArray.length; ++i) {
                stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private void checkCRLs(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, Vector vector, int n) throws CertPathReviewerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            x509CRLSelector.addIssuerName(PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlIssuerException");
            throw new CertPathReviewerException(errorBundle, (Throwable)iOException);
        }
        x509CRLSelector.setCertificateChecking(x509Certificate);
        try {
            Collection collection = PKIXCertPathReviewer.findCRLs(x509CRLSelector, pKIXParameters.getCertStores());
            iterator = collection.iterator();
            if (collection.isEmpty()) {
                collection = PKIXCertPathReviewer.findCRLs(new X509CRLSelector(), pKIXParameters.getCertStores());
                object4 = collection.iterator();
                object3 = new ArrayList<X500Principal>();
                while (object4.hasNext()) {
                    object3.add(((X509CRL)object4.next()).getIssuerX500Principal());
                }
                int n2 = object3.size();
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCrlInCertstore", new Object[]{new UntrustedInput(x509CRLSelector.getIssuers()), new UntrustedInput(object3), new Integer(n2)});
                this.addNotification((ErrorBundle)object2, n);
            }
        }
        catch (AnnotatedException annotatedException) {
            object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlExtractionError", new Object[]{annotatedException.getCause().getMessage(), annotatedException.getCause()});
            this.addError((ErrorBundle)object4, n);
            iterator = new ArrayList().iterator();
        }
        boolean bl = false;
        object4 = null;
        while (iterator.hasNext()) {
            object4 = (X509CRL)iterator.next();
            if (((X509CRL)object4).getNextUpdate() == null || new Date().before(((X509CRL)object4).getNextUpdate())) {
                bl = true;
                object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.localValidCRL", new Object[]{((X509CRL)object4).getThisUpdate(), ((X509CRL)object4).getNextUpdate()});
                this.addNotification((ErrorBundle)object3, n);
                break;
            }
            object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.localInvalidCRL", new Object[]{((X509CRL)object4).getThisUpdate(), ((X509CRL)object4).getNextUpdate()});
            this.addNotification((ErrorBundle)object3, n);
        }
        if (!bl) {
            object3 = null;
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                try {
                    object2 = (String)iterator2.next();
                    object3 = this.getCRL((String)object2);
                    if (object3 == null) continue;
                    if (((X509CRL)object3).getNextUpdate() == null || new Date().before(((X509CRL)object3).getNextUpdate())) {
                        bl = true;
                        object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineValidCRL", new Object[]{((X509CRL)object3).getThisUpdate(), ((X509CRL)object3).getNextUpdate(), new UntrustedInput(object2)});
                        this.addNotification((ErrorBundle)object, n);
                        object4 = object3;
                        break;
                    }
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineInvalidCRL", new Object[]{((X509CRL)object3).getThisUpdate(), ((X509CRL)object3).getNextUpdate(), new UntrustedInput(object2)});
                    this.addNotification((ErrorBundle)object, n);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addNotification(certPathReviewerException.getErrorMessage(), n);
                }
            }
        }
        if (object4 != null) {
            Object object5;
            Object object6;
            Object object7;
            boolean[] blArray;
            if (!(x509Certificate2 == null || (blArray = x509Certificate2.getKeyUsage()) == null || blArray.length >= 7 && blArray[6])) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCrlSigningPermited");
                throw new CertPathReviewerException((ErrorBundle)object2);
            }
            if (publicKey != null) {
                try {
                    ((X509CRL)object4).verify(publicKey, "BC");
                }
                catch (Exception exception) {
                    object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlVerifyFailed");
                    throw new CertPathReviewerException((ErrorBundle)object2, (Throwable)exception);
                }
            } else {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlNoIssuerPublicKey");
                throw new CertPathReviewerException(errorBundle);
            }
            object3 = ((X509CRL)object4).getRevokedCertificate(x509Certificate.getSerialNumber());
            if (object3 != null) {
                object7 = null;
                if (((X509CRLEntry)object3).hasExtensions()) {
                    try {
                        object2 = DEREnumerated.getInstance(PKIXCertPathReviewer.getExtensionValue((X509Extension)object3, X509Extensions.ReasonCode.getId()));
                    }
                    catch (AnnotatedException annotatedException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlReasonExtError");
                        throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                    }
                    if (object2 != null) {
                        object7 = crlReasons[((DEREnumerated)object2).getValue().intValue()];
                    }
                }
                if (!date.before(((X509CRLEntry)object3).getRevocationDate())) {
                    object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certRevoked", new Object[]{((X509CRLEntry)object3).getRevocationDate(), object7});
                    throw new CertPathReviewerException((ErrorBundle)object2);
                }
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.revokedAfterValidation", new Object[]{((X509CRLEntry)object3).getRevocationDate(), object7});
                this.addNotification((ErrorBundle)object2, n);
            } else {
                object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notRevoked");
                this.addNotification((ErrorBundle)object7, n);
            }
            if (((X509CRL)object4).getNextUpdate() != null && ((X509CRL)object4).getNextUpdate().before(new Date())) {
                object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlUpdateAvailable", new Object[]{((X509CRL)object4).getNextUpdate()});
                this.addNotification((ErrorBundle)object7, n);
            }
            try {
                object7 = PKIXCertPathReviewer.getExtensionValue((X509Extension)object4, ISSUING_DISTRIBUTION_POINT);
            }
            catch (AnnotatedException annotatedException) {
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.distrPtExtError");
                throw new CertPathReviewerException((ErrorBundle)object);
            }
            try {
                object2 = PKIXCertPathReviewer.getExtensionValue((X509Extension)object4, DELTA_CRL_INDICATOR);
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.deltaCrlExtError");
                throw new CertPathReviewerException(errorBundle);
            }
            if (object2 != null) {
                object = new X509CRLSelector();
                try {
                    ((X509CRLSelector)object).addIssuerName(PKIXCertPathReviewer.getIssuerPrincipal((X509CRL)object4).getEncoded());
                }
                catch (IOException iOException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlIssuerException");
                    throw new CertPathReviewerException(errorBundle, (Throwable)iOException);
                }
                ((X509CRLSelector)object).setMinCRLNumber(((DERInteger)object2).getPositiveValue());
                try {
                    ((X509CRLSelector)object).setMaxCRLNumber(((DERInteger)PKIXCertPathReviewer.getExtensionValue((X509Extension)object4, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlNbrExtError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                }
                boolean bl2 = false;
                try {
                    object6 = PKIXCertPathReviewer.findCRLs((X509CRLSelector)object, pKIXParameters.getCertStores()).iterator();
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlExtractionError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                }
                while (object6.hasNext()) {
                    DERObject dERObject;
                    object5 = (X509CRL)object6.next();
                    try {
                        dERObject = PKIXCertPathReviewer.getExtensionValue((X509Extension)object5, ISSUING_DISTRIBUTION_POINT);
                    }
                    catch (AnnotatedException annotatedException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.distrPtExtError");
                        throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                    }
                    if (object7 == null) {
                        if (dERObject != null) continue;
                        bl2 = true;
                        break;
                    }
                    if (!((DERObject)object7).equals(dERObject)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBaseCRL");
                    throw new CertPathReviewerException((ErrorBundle)object5);
                }
            }
            if (object7 != null) {
                object = IssuingDistributionPoint.getInstance(object7);
                BasicConstraints basicConstraints = null;
                try {
                    basicConstraints = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
                }
                catch (AnnotatedException annotatedException) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlBCExtError");
                    throw new CertPathReviewerException((ErrorBundle)object5, (Throwable)annotatedException);
                }
                if (((IssuingDistributionPoint)object).onlyContainsUserCerts() && basicConstraints != null && basicConstraints.isCA()) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyUserCert");
                    throw new CertPathReviewerException((ErrorBundle)object6);
                }
                if (((IssuingDistributionPoint)object).onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyCaCert");
                    throw new CertPathReviewerException((ErrorBundle)object6);
                }
                if (((IssuingDistributionPoint)object).onlyContainsAttributeCerts()) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyAttrCert");
                    throw new CertPathReviewerException((ErrorBundle)object6);
                }
            }
        }
        if (!bl) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidCrlFound");
            throw new CertPathReviewerException(errorBundle);
        }
    }

    private Vector getCRLDistUrls(CRLDistPoint cRLDistPoint, AuthorityInformationAccess authorityInformationAccess) {
        Object object;
        ASN1Encodable aSN1Encodable;
        int n;
        ASN1Encodable[] aSN1EncodableArray;
        Vector<Object> vector = new Vector<Object>();
        if (cRLDistPoint != null) {
            aSN1EncodableArray = cRLDistPoint.getDistributionPoints();
            for (n = 0; n < aSN1EncodableArray.length; ++n) {
                aSN1Encodable = ((DistributionPoint)aSN1EncodableArray[n]).getDistributionPoint();
                if (((DistributionPointName)aSN1Encodable).getType() != 0) continue;
                object = GeneralNames.getInstance(((DistributionPointName)aSN1Encodable).getName()).getNames();
                for (int i = 0; i < ((GeneralName[])object).length; ++i) {
                    if (object[i].getTagNo() != 6) continue;
                    String string = ((DERIA5String)object[i].getName()).getString();
                    vector.add(string);
                }
            }
        }
        if (authorityInformationAccess != null) {
            aSN1EncodableArray = authorityInformationAccess.getAccessDescriptions();
            for (n = 0; n < aSN1EncodableArray.length; ++n) {
                if (!((AccessDescription)aSN1EncodableArray[n]).getAccessMethod().equals(AccessDescription.id_ad_caIssuers) || ((GeneralName)(aSN1Encodable = ((AccessDescription)aSN1EncodableArray[n]).getAccessLocation())).getTagNo() != 6) continue;
                object = ((DERIA5String)((GeneralName)aSN1Encodable).getName()).getString();
                vector.add(object);
            }
        }
        return vector;
    }

    private Vector getOCSPUrls(AuthorityInformationAccess authorityInformationAccess) {
        Vector<String> vector = new Vector<String>();
        if (authorityInformationAccess != null) {
            AccessDescription[] accessDescriptionArray = authorityInformationAccess.getAccessDescriptions();
            for (int i = 0; i < accessDescriptionArray.length; ++i) {
                GeneralName generalName;
                if (!accessDescriptionArray[i].getAccessMethod().equals(AccessDescription.id_ad_ocsp) || (generalName = accessDescriptionArray[i].getAccessLocation()).getTagNo() != 6) continue;
                String string = ((DERIA5String)generalName.getName()).getString();
                vector.add(string);
            }
        }
        return vector;
    }

    private X509CRL getCRL(String string) throws CertPathReviewerException {
        X509CRL x509CRL;
        block3: {
            x509CRL = null;
            try {
                URL uRL = new URL(string);
                if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https")) break block3;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setConnectTimeout(2000);
                httpURLConnection.setDoInput(true);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                    x509CRL = (X509CRL)certificateFactory.generateCRL(httpURLConnection.getInputStream());
                    break block3;
                }
                throw new Exception(httpURLConnection.getResponseMessage());
            }
            catch (Exception exception) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.loadCrlDistPointError", new Object[]{new UntrustedInput(string), exception.getMessage(), exception});
                throw new CertPathReviewerException(errorBundle);
            }
        }
        return x509CRL;
    }

    private Collection getTrustAnchors(X509Certificate x509Certificate, Set set) throws CertPathReviewerException {
        ArrayList<TrustAnchor> arrayList = new ArrayList<TrustAnchor>();
        Iterator iterator = set.iterator();
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustAnchorIssuerError");
            throw new CertPathReviewerException(errorBundle);
        }
        while (iterator.hasNext()) {
            X500Principal x500Principal;
            X500Principal x500Principal2;
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            if (trustAnchor.getTrustedCert() != null) {
                if (!x509CertSelector.match(trustAnchor.getTrustedCert())) continue;
                arrayList.add(trustAnchor);
                continue;
            }
            if (trustAnchor.getCAName() == null || trustAnchor.getCAPublicKey() == null || !(x500Principal2 = PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate)).equals(x500Principal = new X500Principal(trustAnchor.getCAName()))) continue;
            arrayList.add(trustAnchor);
        }
        return arrayList;
    }
}

