/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ExtraInfoData;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtraInfoBlock
implements Writable {
    public static final int TYPE_ICONHASH = 1;
    public static final int TYPE_AVAILMSG = 2;
    public static final int TYPE_ITUNES_URL = 9;
    public static final int TYPE_AIMEXPINFO_A = 128;
    public static final int TYPE_AIMEXPINFO_B = 130;
    public static final int TYPE_CERTINFO_HASHA = 1026;
    public static final int TYPE_CERTINFO_HASHB = 1027;
    private final int type;
    private final ExtraInfoData extraData;
    private final int totalSize;

    public static List<ExtraInfoBlock> readExtraInfoBlocks(ByteBlock block) {
        ExtraInfoBlock info;
        DefensiveTools.checkNull((Object)block, (String)"block");
        LinkedList<ExtraInfoBlock> infos = new LinkedList<ExtraInfoBlock>();
        ByteBlock nextBlock = block;
        while ((info = ExtraInfoBlock.readExtraInfoBlock(nextBlock)) != null) {
            infos.add(info);
            nextBlock = nextBlock.subBlock(info.getTotalSize());
        }
        return DefensiveTools.getUnmodifiableCopy(infos);
    }

    @Nullable
    public static ExtraInfoBlock readExtraInfoBlock(ByteBlock block) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        if (block.getLength() < 2) {
            return null;
        }
        int code = BinaryTools.getUShort((ByteBlock)block, (int)0);
        ByteBlock hashBlock = block.subBlock(2);
        ExtraInfoData data = ExtraInfoData.readExtraInfoData(hashBlock);
        int size = 2;
        if (data != null) {
            size += data.getTotalSize();
        }
        return new ExtraInfoBlock(code, data, size);
    }

    private ExtraInfoBlock(int code, ExtraInfoData data, int totalSize) {
        DefensiveTools.checkRange((int)code, (String)"code", (int)0);
        DefensiveTools.checkRange((int)totalSize, (String)"totalSize", (int)-1);
        this.type = code;
        this.extraData = data;
        this.totalSize = totalSize;
    }

    public ExtraInfoBlock(int type, ExtraInfoData extraData) {
        this(type, extraData, -1);
    }

    public final int getType() {
        return this.type;
    }

    public final ExtraInfoData getExtraData() {
        return this.extraData;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        return 2L + (this.extraData == null ? 0L : this.extraData.getWritableLength());
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.type);
        if (this.extraData != null) {
            this.extraData.write(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtraInfoBlock that = (ExtraInfoBlock)o;
        if (this.type != that.type) {
            return false;
        }
        return !(this.extraData != null ? !this.extraData.equals(that.extraData) : that.extraData != null);
    }

    public int hashCode() {
        int result = this.type;
        result = 29 * result + (this.extraData != null ? this.extraData.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ExtraInfoBlock: type=0x" + Long.toHexString(this.type) + " (" + MiscTools.findIntField(ExtraInfoBlock.class, this.type, "TYPE_.*") + ")" + ", extraData=<" + this.extraData + ">";
    }
}

