/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.PendingSnacListener;
import net.kano.joustsim.oscar.oscar.PendingSnacMgr;

public class SnacManager {
    protected final Map<Integer, List<BasicConnection>> conns = new HashMap<Integer, List<BasicConnection>>();
    protected final PendingSnacMgr pendingSnacs = new PendingSnacMgr();
    protected final List<PendingSnacListener> listeners = new ArrayList<PendingSnacListener>();
    protected final Map<BasicConnection, int[]> supportedFamilies = new IdentityHashMap<BasicConnection, int[]>();

    public SnacManager() {
    }

    public SnacManager(PendingSnacListener listener) {
        this.addListener(listener);
    }

    public void register(BasicConnection conn) {
        int[] families = conn.getSnacFamilies();
        this.supportedFamilies.put(conn, families);
        for (int familyCode : families) {
            List<BasicConnection> handlers = this.conns.get(familyCode);
            if (handlers == null) {
                handlers = new LinkedList<BasicConnection>();
                this.conns.put(familyCode, handlers);
            }
            if (handlers.contains(conn)) continue;
            handlers.add(conn);
        }
    }

    public void dequeueSnacs(BasicConnection conn) {
        int[] infos = this.supportedFamilies.get(conn);
        if (infos != null) {
            for (int familyCode : infos) {
                if (!this.pendingSnacs.isPending(familyCode)) continue;
                this.dequeueSnacs(familyCode);
            }
        }
    }

    protected void dequeueSnacs(int familyCode) {
        SnacRequest[] pending = this.pendingSnacs.getPending(familyCode);
        this.pendingSnacs.setPending(familyCode, false);
        for (PendingSnacListener listener : this.listeners) {
            listener.dequeueSnacs(pending);
        }
    }

    public void unregister(BasicConnection conn) {
        for (List<BasicConnection> handlers : this.conns.values()) {
            handlers.remove(conn);
        }
    }

    public BasicConnection getConn(int familyCode) {
        List<BasicConnection> handlers = this.conns.get(familyCode);
        if (handlers == null || handlers.size() == 0) {
            return null;
        }
        return handlers.get(0);
    }

    public boolean isPending(int familyCode) {
        return this.pendingSnacs.isPending(familyCode);
    }

    public void addRequest(SnacRequest request) {
        int family = request.getCommand().getFamily();
        if (!this.isPending(family)) {
            throw new IllegalArgumentException("Family 0x" + Integer.toHexString(family) + " is not pending");
        }
        this.pendingSnacs.add(request);
    }

    public void addListener(PendingSnacListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(PendingSnacListener l) {
        this.listeners.remove(l);
    }

    public void setPending(int family, boolean pending) {
        this.pendingSnacs.setPending(family, pending);
    }
}

