/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableHook;
import com.hazelcast.transaction.client.ClearRemoteTransactionRequest;
import com.hazelcast.transaction.client.CollectXATransactionsRequest;
import com.hazelcast.transaction.client.CommitTransactionRequest;
import com.hazelcast.transaction.client.CommitXATransactionRequest;
import com.hazelcast.transaction.client.CreateTransactionRequest;
import com.hazelcast.transaction.client.CreateXATransactionRequest;
import com.hazelcast.transaction.client.FinalizeXATransactionRequest;
import com.hazelcast.transaction.client.PrepareXATransactionRequest;
import com.hazelcast.transaction.client.RollbackTransactionRequest;
import com.hazelcast.transaction.client.RollbackXATransactionRequest;
import java.util.Collection;

public class ClientTxnPortableHook
implements PortableHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.portable.client.txn", -19);
    public static final int CREATE = 1;
    public static final int COMMIT = 2;
    public static final int ROLLBACK = 3;
    public static final int PREPARE_XA = 4;
    public static final int CREATE_XA = 5;
    public static final int COMMIT_XA = 6;
    public static final int ROLLBACK_XA = 7;
    public static final int FINALIZE_XA = 8;
    public static final int COLLECT_XA = 9;
    public static final int CLEAR_XA = 10;

    @Override
    public int getFactoryId() {
        return F_ID;
    }

    @Override
    public PortableFactory createFactory() {
        PortableFactory factory = new PortableFactory(){

            @Override
            public Portable create(int classId) {
                switch (classId) {
                    case 1: {
                        return new CreateTransactionRequest();
                    }
                    case 2: {
                        return new CommitTransactionRequest();
                    }
                    case 3: {
                        return new RollbackTransactionRequest();
                    }
                    case 4: {
                        return new PrepareXATransactionRequest();
                    }
                    case 5: {
                        return new CreateXATransactionRequest();
                    }
                    case 6: {
                        return new CommitXATransactionRequest();
                    }
                    case 7: {
                        return new RollbackXATransactionRequest();
                    }
                    case 8: {
                        return new FinalizeXATransactionRequest();
                    }
                    case 9: {
                        return new CollectXATransactionsRequest();
                    }
                    case 10: {
                        return new ClearRemoteTransactionRequest();
                    }
                }
                return null;
            }
        };
        return factory;
    }

    @Override
    public Collection<ClassDefinition> getBuiltinDefinitions() {
        return null;
    }
}

