/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import com.hazelcast.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class StoreWorker
implements Runnable {
    private final String mapName;
    private final MapServiceContext mapServiceContext;
    private final WriteBehindProcessor writeBehindProcessor;
    private final long backupRunIntervalTime;
    private long lastRunTime;

    public StoreWorker(MapStoreContext mapStoreContext, WriteBehindProcessor writeBehindProcessor) {
        this.mapName = mapStoreContext.getMapName();
        this.mapServiceContext = mapStoreContext.getMapServiceContext();
        this.writeBehindProcessor = writeBehindProcessor;
        this.backupRunIntervalTime = this.getReplicaWaitTime();
        this.lastRunTime = Clock.currentTimeMillis();
    }

    @Override
    public void run() {
        long now = Clock.currentTimeMillis();
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        ArrayList<DelayedEntry> entries = new ArrayList<DelayedEntry>();
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            RecordStore recordStore;
            InternalPartition partition = partitionService.getPartition(partitionId, false);
            Address owner = partition.getOwnerOrNull();
            if (owner == null || (recordStore = this.getRecordStoreOrNull(this.mapName, partitionId)) == null) continue;
            List<DelayedEntry> entriesToStore = this.getEntriesToStore(now, recordStore);
            if (!partition.isLocal()) {
                if (now <= this.lastRunTime + this.backupRunIntervalTime) continue;
                this.doInBackup(entriesToStore, partitionId);
                continue;
            }
            entries.addAll(entriesToStore);
        }
        if (entries.isEmpty()) {
            return;
        }
        Map<Integer, List<DelayedEntry>> failuresPerPartition = this.writeBehindProcessor.process(entries);
        this.removeFinishedStoreOperationsFromQueues(this.mapName, entries);
        this.readdFailedStoreOperationsToQueues(this.mapName, failuresPerPartition);
        this.lastRunTime = now;
    }

    private List<DelayedEntry> getEntriesToStore(long now, RecordStore recordStore) {
        int flushCount = StoreWorker.getNumberOfFlushedEntries(recordStore);
        WriteBehindQueue<DelayedEntry> queue = StoreWorker.getWriteBehindQueue(recordStore);
        ArrayList<DelayedEntry> entries = new ArrayList<DelayedEntry>();
        this.filterWriteBehindQueue(now, flushCount, entries, queue);
        return entries;
    }

    private void filterWriteBehindQueue(long now, int count, Collection<DelayedEntry> collection, WriteBehindQueue<DelayedEntry> queue) {
        if (count > 0) {
            queue.getFrontByNumber(count, collection);
        } else {
            queue.getFrontByTime(now, collection);
        }
    }

    private void removeFinishedStoreOperationsFromQueues(String mapName, List<DelayedEntry> entries) {
        for (DelayedEntry entry : entries) {
            int partitionId = entry.getPartitionId();
            RecordStore recordStore = this.getRecordStoreOrNull(mapName, partitionId);
            if (recordStore == null) continue;
            WriteBehindQueue<DelayedEntry> queue = StoreWorker.getWriteBehindQueue(recordStore);
            queue.removeFirstOccurrence(entry);
            AtomicInteger flushCounter = StoreWorker.getFlushCounter(recordStore);
            int flushCount = flushCounter.get();
            if (flushCount <= 0) continue;
            flushCounter.addAndGet(-1);
        }
    }

    private void readdFailedStoreOperationsToQueues(String mapName, Map<Integer, List<DelayedEntry>> failuresPerPartition) {
        if (failuresPerPartition.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, List<DelayedEntry>> entry : failuresPerPartition.entrySet()) {
            RecordStore recordStore;
            Integer partitionId = entry.getKey();
            List<DelayedEntry> failures = failuresPerPartition.get(partitionId);
            if (CollectionUtil.isEmpty(failures) || (recordStore = this.getRecordStoreOrNull(mapName, partitionId)) == null) continue;
            WriteBehindQueue<DelayedEntry> queue = StoreWorker.getWriteBehindQueue(recordStore);
            queue.addFirst(failures);
        }
    }

    private void doInBackup(List<DelayedEntry> delayedEntries, int partitionId) {
        if (CollectionUtil.isEmpty(delayedEntries)) {
            return;
        }
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        ClusterService clusterService = nodeEngine.getClusterService();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        Address thisAddress = clusterService.getThisAddress();
        InternalPartition partition = partitionService.getPartition(partitionId, false);
        Address owner = partition.getOwnerOrNull();
        if (owner != null && !owner.equals(thisAddress)) {
            this.writeBehindProcessor.callBeforeStoreListeners(delayedEntries);
            this.removeFinishedStoreOperationsFromQueues(this.mapName, delayedEntries);
            this.writeBehindProcessor.callAfterStoreListeners(delayedEntries);
        }
    }

    private long getReplicaWaitTime() {
        return TimeUnit.SECONDS.toMillis(this.mapServiceContext.getNodeEngine().getGroupProperties().MAP_REPLICA_SCHEDULED_TASK_DELAY_SECONDS.getInteger());
    }

    private RecordStore getRecordStoreOrNull(String mapName, int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getExistingRecordStore(mapName);
    }

    private static WriteBehindQueue<DelayedEntry> getWriteBehindQueue(RecordStore recordStore) {
        WriteBehindStore writeBehindStore = (WriteBehindStore)recordStore.getMapDataStore();
        return writeBehindStore.getWriteBehindQueue();
    }

    private static AtomicInteger getFlushCounter(RecordStore recordStore) {
        WriteBehindStore writeBehindStore = (WriteBehindStore)recordStore.getMapDataStore();
        return writeBehindStore.getFlushCounter();
    }

    private static int getNumberOfFlushedEntries(RecordStore recordStore) {
        AtomicInteger flushCounter = StoreWorker.getFlushCounter(recordStore);
        return flushCounter.get();
    }
}

