/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.websocket.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class JsrExtension
implements Extension {
    private final String name;
    private List<Extension.Parameter> parameters = new ArrayList<Extension.Parameter>();

    public JsrExtension(ExtensionConfig cfg) {
        this.name = cfg.getName();
        if (cfg.getParameters() != null) {
            for (Map.Entry entry : cfg.getParameters().entrySet()) {
                this.parameters.add(new JsrParameter((String)entry.getKey(), (String)entry.getValue()));
            }
        }
    }

    public JsrExtension(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Extension.Parameter> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.name);
        for (Extension.Parameter param : this.parameters) {
            str.append(';');
            str.append(param.getName());
            String value = param.getValue();
            if (value == null) continue;
            str.append('=');
            QuoteUtil.quoteIfNeeded((StringBuilder)str, (String)value, (String)";=");
        }
        return str.toString();
    }

    private static class JsrParameter
    implements Extension.Parameter {
        private String name;
        private String value;

        private JsrParameter(String key, String value) {
            this.name = key;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

