/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.javasound;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.SynchronizedBoolean;
import com.lti.utils.synchronization.SynchronizedObjectHolder;
import java.awt.Component;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.Owned;
import javax.media.Time;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.control.FrameProcessingControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import net.sf.fmj.media.AbstractGainControl;
import net.sf.fmj.media.protocol.javasound.AudioFormatComparator;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.RingBuffer;

public class DataSource
extends PushBufferDataSource
implements CaptureDevice {
    private static final boolean TRACE = true;
    private static final Logger logger = LoggerSingleton.logger;
    private MyPushBufferStream pushBufferStream;
    private TargetDataLine targetDataLine;
    private javax.sound.sampled.AudioFormat javaSoundAudioFormat;
    private AudioFormat jmfAudioFormat;
    private long buflenMS = 20L;
    private int buflen;
    private RingBuffer jitterBuffer = new RingBuffer(2);
    private PeakVolumeMeter levelControl;
    protected Object[] controls;
    private boolean connected;
    private static final String CONTENT_TYPE = "raw";
    private final SynchronizedBoolean started = new SynchronizedBoolean(false);
    private Format[] formatsArray;
    private boolean enabled = true;

    public static Format[] querySupportedFormats(int n) {
        ArrayList<AudioFormat> arrayList = new ArrayList<AudioFormat>();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        if (n < 0 || n >= infoArray.length) {
            return null;
        }
        Mixer mixer = AudioSystem.getMixer(infoArray[n]);
        Line.Info[] infoArray2 = mixer.getTargetLineInfo();
        for (int i = 0; i < infoArray2.length; ++i) {
            if (!(infoArray2[i] instanceof DataLine.Info)) continue;
            javax.sound.sampled.AudioFormat[] audioFormatArray = ((DataLine.Info)infoArray2[i]).getFormats();
            for (int j = 0; j < audioFormatArray.length; ++j) {
                AudioFormat audioFormat = JavaSoundUtils.convertFormat(audioFormatArray[j]);
                if (arrayList.contains(audioFormat)) continue;
                arrayList.add(audioFormat);
            }
        }
        Collections.sort(arrayList, Collections.reverseOrder(new AudioFormatComparator()));
        return arrayList.toArray(new Format[arrayList.size()]);
    }

    public DataSource() {
        this.levelControl = new PeakVolumeMeter();
        this.levelControl.setMute(true);
    }

    public void connect() throws IOException {
        logger.fine("connect");
        if (this.connected) {
            return;
        }
        try {
            Object object;
            Object object2;
            if (null == this.jmfAudioFormat) {
                Format[] formatArray = this.getSupportedFormats();
                object2 = (AudioFormat)formatArray[0];
                if (((AudioFormat)object2).getSampleRate() == -1.0) {
                    object = new AudioFormat(((Format)object2).getEncoding(), 44100.0, -1, -1);
                    this.setJMFAudioFormat((AudioFormat)((AudioFormat)object).intersects((Format)object2));
                } else {
                    this.setJMFAudioFormat((AudioFormat)object2);
                }
            }
            int n = this.getMixerIndex();
            object2 = AudioSystem.getMixerInfo();
            object = AudioSystem.getMixer(object2[n]);
            this.targetDataLine = (TargetDataLine)object.getLine(new DataLine.Info(TargetDataLine.class, null));
            logger.fine("targetDataLine=" + this.targetDataLine);
            this.buflen = (int)((float)this.javaSoundAudioFormat.getFrameSize() * this.javaSoundAudioFormat.getSampleRate() * (float)this.buflenMS / 1000.0f);
            this.targetDataLine.open(this.javaSoundAudioFormat, this.buflen);
            logger.fine("buflen=" + this.buflen);
            this.pushBufferStream = new MyPushBufferStream();
            this.controls = new Object[]{new JavaSoundFormatControl(), new JavaSoundBufferControl(), new JitterBufferControl(), new FPC(), this.levelControl};
        }
        catch (LineUnavailableException lineUnavailableException) {
            logger.log(Level.WARNING, "" + lineUnavailableException, lineUnavailableException);
            throw new IOException("" + lineUnavailableException);
        }
        this.connected = true;
    }

    public void disconnect() {
        logger.fine("disconnect");
        if (!this.connected) {
            return;
        }
        try {
            this.stop();
            if (this.targetDataLine != null) {
                this.targetDataLine.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
        }
        finally {
            this.targetDataLine = null;
            this.pushBufferStream = null;
        }
        this.connected = false;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        int n = this.getMixerIndex();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        return new CaptureDeviceInfo(infoArray[n].getName(), this.getLocator(), this.getSupportedFormats());
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Time getDuration() {
        return DURATION_UNBOUNDED;
    }

    public FormatControl[] getFormatControls() {
        return new FormatControl[]{new JavaSoundFormatControl()};
    }

    private int getMixerIndex() {
        int n = -1;
        try {
            String string = this.getLocator().getRemainder();
            if (string.startsWith("#")) {
                string = string.substring(1);
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (-1 == n && this.getLocator().toString().startsWith("javasound://")) {
            for (int i = 0; i < 50; ++i) {
                Format[] formatArray = DataSource.querySupportedFormats(i);
                if (null == formatArray || formatArray.length <= 0) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public PushBufferStream[] getStreams() {
        logger.fine("getStreams");
        return new PushBufferStream[]{this.pushBufferStream};
    }

    private Format[] getSupportedFormats() {
        if (this.formatsArray != null) {
            return this.formatsArray;
        }
        int n = this.getMixerIndex();
        this.formatsArray = DataSource.querySupportedFormats(n);
        return this.formatsArray;
    }

    private void setJavaSoundAudioFormat(javax.sound.sampled.AudioFormat audioFormat) {
        this.javaSoundAudioFormat = audioFormat;
        this.jmfAudioFormat = JavaSoundUtils.convertFormat(this.javaSoundAudioFormat);
    }

    private void setJMFAudioFormat(AudioFormat audioFormat) {
        this.jmfAudioFormat = audioFormat;
        this.javaSoundAudioFormat = JavaSoundUtils.convertFormat(this.jmfAudioFormat);
    }

    public void start() throws IOException {
        logger.fine("start");
        if (this.started.getValue()) {
            return;
        }
        this.targetDataLine.start();
        this.pushBufferStream.startAvailabilityThread();
        this.started.setValue(true);
    }

    public void stop() throws IOException {
        logger.fine("stop");
        if (!this.started.getValue()) {
            return;
        }
        try {
            if (this.targetDataLine != null) {
                this.targetDataLine.stop();
                this.targetDataLine.flush();
            }
            if (this.pushBufferStream != null) {
                this.pushBufferStream.stopAvailabilityThread();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
        finally {
            this.started.setValue(false);
        }
    }

    private class PeakVolumeMeter
    extends AbstractGainControl {
        float peakLevel = 0.0f;

        private PeakVolumeMeter() {
        }

        public float getLevel() {
            return this.peakLevel;
        }

        public void processData(Buffer buffer) {
            if (this.getMute() || buffer.isDiscard() || buffer.getLength() <= 0) {
                return;
            }
            AudioFormat audioFormat = (AudioFormat)buffer.getFormat();
            byte[] byArray = (byte[])buffer.getData();
            if (audioFormat.getEncoding().equalsIgnoreCase("LINEAR") && audioFormat.getSampleSizeInBits() == 16) {
                int n = 0;
                int n2 = 1;
                if (audioFormat.getEndian() == 0) {
                    n = 1;
                    n2 = 0;
                }
                if (audioFormat.getSigned() == 1) {
                    int n3 = 0;
                    int n4 = byArray.length / 2;
                    for (int i = 0; i < n4; ++i) {
                        int n5 = (byArray[i * 2 + n] << 8) + (byArray[i * 2 + n2] & 0xFF);
                        if (n5 < 0) {
                            n5 = -n5;
                        }
                        if (n5 <= n3) continue;
                        n3 = n5;
                    }
                    this.peakLevel = (float)n3 / 32768.0f;
                }
            }
        }

        public float setLevel(float f) {
            float f2 = this.getLevel();
            return f2;
        }
    }

    private class MyPushBufferStream
    implements PushBufferStream {
        private long sequenceNumber = 0L;
        private AvailabilityThread availabilityThread;
        private final SynchronizedObjectHolder<BufferTransferHandler> transferHandlerHolder = new SynchronizedObjectHolder();

        private MyPushBufferStream() {
        }

        public boolean endOfStream() {
            return false;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor(DataSource.CONTENT_TYPE);
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String string) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Format getFormat() {
            return DataSource.this.jmfAudioFormat;
        }

        public void read(Buffer buffer) throws IOException {
            if (!DataSource.this.started.getValue()) {
                buffer.setOffset(0);
                buffer.setLength(0);
                buffer.setDiscard(true);
                return;
            }
            try {
                byte[] byArray = (byte[])DataSource.this.jitterBuffer.get();
                buffer.setFlags(33024);
                buffer.setOffset(0);
                buffer.setData(byArray);
                buffer.setLength(byArray.length);
                buffer.setFormat(DataSource.this.jmfAudioFormat);
                buffer.setSequenceNumber(++this.sequenceNumber);
                buffer.setTimeStamp(System.nanoTime());
                DataSource.this.levelControl.processData(buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
            this.transferHandlerHolder.setObject(bufferTransferHandler);
        }

        public void startAvailabilityThread() {
            this.availabilityThread = new AvailabilityThread();
            this.availabilityThread.setName("AvailabilityThread for " + this);
            this.availabilityThread.setDaemon(true);
            this.availabilityThread.start();
        }

        public void stopAvailabilityThread() throws InterruptedException {
            if (this.availabilityThread == null) {
                return;
            }
            this.availabilityThread.close();
            this.availabilityThread.waitUntilClosed();
            this.availabilityThread = null;
        }

        private class AvailabilityThread
        extends CloseableThread {
            private AvailabilityThread() {
            }

            public void run() {
                logger.fine("jitterbuflen=" + DataSource.this.jitterBuffer.size());
                try {
                    byte[] byArray = new byte[DataSource.this.buflen];
                    while (!this.isClosing()) {
                        BufferTransferHandler bufferTransferHandler;
                        int n = DataSource.this.targetDataLine.read(byArray, 0, byArray.length);
                        if (n <= 0 || (bufferTransferHandler = (BufferTransferHandler)MyPushBufferStream.this.transferHandlerHolder.getObject()) == null || DataSource.this.jitterBuffer.put(byArray)) continue;
                        bufferTransferHandler.transferData(MyPushBufferStream.this);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.setClosed();
            }
        }
    }

    private class JitterBufferControl
    implements BufferControl,
    Owned {
        private JitterBufferControl() {
        }

        public long getBufferLength() {
            return DataSource.this.buflenMS * (long)DataSource.this.jitterBuffer.size();
        }

        public Component getControlComponent() {
            return null;
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public long getMinimumThreshold() {
            return -1L;
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public long setBufferLength(long l) {
            int n = (int)(l / DataSource.this.buflenMS);
            if (n < 1) {
                n = 1;
            }
            DataSource.this.jitterBuffer.resize(n);
            return (long)n * DataSource.this.buflenMS;
        }

        public void setEnabledThreshold(boolean bl) {
        }

        public long setMinimumThreshold(long l) {
            return -1L;
        }
    }

    private class JavaSoundFormatControl
    implements FormatControl,
    Owned {
        private JavaSoundFormatControl() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Format getFormat() {
            return DataSource.this.jmfAudioFormat;
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public Format[] getSupportedFormats() {
            return DataSource.this.getSupportedFormats();
        }

        public boolean isEnabled() {
            return DataSource.this.enabled;
        }

        public void setEnabled(boolean bl) {
            DataSource.this.enabled = bl;
        }

        public Format setFormat(Format format) {
            DataSource.this.setJMFAudioFormat((AudioFormat)format);
            if (DataSource.this.connected) {
                DataSource.this.disconnect();
                try {
                    DataSource.this.connect();
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "" + iOException, iOException);
                    return null;
                }
            }
            return DataSource.this.jmfAudioFormat;
        }
    }

    private class JavaSoundBufferControl
    implements BufferControl,
    Owned {
        private JavaSoundBufferControl() {
        }

        public long getBufferLength() {
            return DataSource.this.buflenMS;
        }

        public Component getControlComponent() {
            return null;
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public long getMinimumThreshold() {
            return -1L;
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public long setBufferLength(long l) {
            boolean bl = false;
            if (DataSource.this.started.getValue()) {
                bl = true;
                try {
                    DataSource.this.stop();
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "" + iOException, iOException);
                }
            }
            if (l < 20L) {
                l = 20L;
            } else if (l > 5000L) {
                l = 5000L;
            }
            DataSource.this.buflenMS = l;
            if (DataSource.this.connected) {
                DataSource.this.disconnect();
                try {
                    DataSource.this.connect();
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "" + iOException, iOException);
                }
            }
            if (bl) {
                try {
                    DataSource.this.start();
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "" + iOException, iOException);
                }
            }
            return DataSource.this.buflenMS;
        }

        public void setEnabledThreshold(boolean bl) {
        }

        public long setMinimumThreshold(long l) {
            return -1L;
        }
    }

    private class FPC
    implements FrameProcessingControl,
    Owned {
        private FPC() {
        }

        public Component getControlComponent() {
            return null;
        }

        public int getFramesDropped() {
            return DataSource.this.jitterBuffer.getOverrunCounter();
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public void setFramesBehind(float f) {
        }

        public boolean setMinimalProcessing(boolean bl) {
            return false;
        }
    }
}

