/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.datasink.file;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.media.Control;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.Syncable;
import net.sf.fmj.media.datasink.BasicDataSink;
import net.sf.fmj.media.datasink.RandomAccess;

public class Handler
extends BasicDataSink
implements SourceTransferHandler,
Seekable,
Runnable,
RandomAccess,
Syncable {
    private static final boolean DEBUG = false;
    protected static final int NOT_INITIALIZED = 0;
    protected static final int OPENED = 1;
    protected static final int STARTED = 2;
    protected static final int CLOSED = 3;
    protected int state = 0;
    protected DataSource source;
    protected SourceStream[] streams;
    protected SourceStream stream;
    protected boolean push;
    protected boolean errorEncountered = false;
    protected String errorReason = null;
    protected Control[] controls;
    protected File file;
    protected File tempFile = null;
    protected RandomAccessFile raFile = null;
    protected RandomAccessFile qtStrRaFile = null;
    protected boolean fileClosed = false;
    protected FileDescriptor fileDescriptor = null;
    protected MediaLocator locator = null;
    protected String contentType = null;
    protected int fileSize = 0;
    protected int filePointer = 0;
    protected int bytesWritten = 0;
    protected static final int BUFFER_LEN = 131072;
    protected boolean syncEnabled = false;
    protected byte[] buffer1 = new byte[131072];
    protected byte[] buffer2 = new byte[131072];
    protected boolean buffer1Pending = false;
    protected long buffer1PendingLocation = -1L;
    protected int buffer1Length;
    protected boolean buffer2Pending = false;
    protected long buffer2PendingLocation = -1L;
    protected int buffer2Length;
    protected long nextLocation = 0L;
    protected Thread writeThread = null;
    private Integer bufferLock = 0;
    private boolean receivedEOS = false;
    public int WRITE_CHUNK_SIZE = 16384;
    private boolean streamingEnabled = false;
    private boolean errorCreatingStreamingFile = false;
    long lastSyncTime = -1L;

    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void close(String string) {
        Handler handler = this;
        synchronized (handler) {
            if (this.state == 3) {
                return;
            }
            this.setState(3);
        }
        if (this.push) {
            for (int i = 0; i < this.streams.length; ++i) {
                ((PushSourceStream)this.streams[i]).setTransferHandler(null);
            }
        }
        if (string != null) {
            this.errorEncountered = true;
            this.sendDataSinkErrorEvent(string);
            Integer n = this.bufferLock;
            synchronized (n) {
                this.bufferLock.notifyAll();
            }
        }
        try {
            this.source.stop();
        }
        catch (IOException iOException) {
            System.err.println("IOException when stopping source " + iOException);
        }
        try {
            if (this.raFile != null) {
                this.raFile.close();
            }
            if (this.streamingEnabled && this.qtStrRaFile != null) {
                this.qtStrRaFile.close();
            }
            if (this.source != null) {
                this.source.disconnect();
            }
            if (this.streamingEnabled && this.tempFile != null) {
                this.deleteFile(this.errorCreatingStreamingFile ? this.file : this.tempFile);
            }
        }
        catch (IOException iOException) {
            System.out.println("close: " + iOException);
        }
        this.raFile = null;
        this.qtStrRaFile = null;
        this.removeAllListeners();
    }

    private boolean deleteFile(File file) {
        boolean bl = false;
        try {
            bl = file.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public long doSeek(long l) {
        if (this.raFile != null) {
            try {
                this.raFile.seek(l);
                this.filePointer = (int)l;
                return l;
            }
            catch (IOException iOException) {
                this.close("Error in seek: " + iOException);
            }
        }
        return -1L;
    }

    public long doTell() {
        if (this.raFile != null) {
            try {
                return this.raFile.getFilePointer();
            }
            catch (IOException iOException) {
                this.close("Error in tell: " + iOException);
            }
        }
        return -1L;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[0];
        }
        return this.controls;
    }

    public MediaLocator getOutputLocator() {
        return this.locator;
    }

    public boolean isRandomAccess() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException, SecurityException {
        block14: {
            try {
                if (this.state != 0 || this.locator == null) break block14;
                String string = this.locator.getRemainder();
                while (string.charAt(0) == '/' && (string.charAt(1) == '/' || string.charAt(2) == ':')) {
                    string = string.substring(1);
                }
                String string2 = System.getProperty("file.separator");
                if (string2.equals("\\")) {
                    string = string.replace('/', '\\');
                }
                this.file = new File(string);
                if (this.file.exists() && !this.deleteFile(this.file)) {
                    System.err.println("datasink open: Existing file " + string + " cannot be deleted. Check if " + "some other process is using " + " this file");
                    if (this.push) {
                        ((PushSourceStream)this.stream).setTransferHandler(null);
                    }
                    throw new IOException("Existing file " + string + " cannot be deleted");
                }
                String string3 = this.file.getParent();
                if (string3 != null) {
                    new File(string3).mkdirs();
                }
                try {
                    if (!this.streamingEnabled) {
                        this.raFile = new RandomAccessFile(this.file, "rw");
                        this.fileDescriptor = this.raFile.getFD();
                    } else {
                        int n = string.lastIndexOf(".");
                        String string4 = n > 0 ? string.substring(0, n) + ".nonstreamable" + string.substring(n, string.length()) : this.file + ".nonstreamable.mov";
                        this.tempFile = new File(string4);
                        this.raFile = new RandomAccessFile(this.tempFile, "rw");
                        this.fileDescriptor = this.raFile.getFD();
                        this.qtStrRaFile = new RandomAccessFile(this.file, "rw");
                    }
                }
                catch (IOException iOException) {
                    System.err.println("datasink open: IOException when creating RandomAccessFile " + string + " : " + iOException);
                    if (this.push) {
                        ((PushSourceStream)this.stream).setTransferHandler(null);
                    }
                    throw iOException;
                }
                this.setState(1);
            }
            finally {
                if (this.state == 0 && this.stream != null) {
                    ((PushSourceStream)this.stream).setTransferHandler(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.state != 3 && !this.errorEncountered) {
            Integer n = this.bufferLock;
            synchronized (n) {
                while (!(this.buffer1Pending || this.buffer2Pending || this.errorEncountered || this.state == 3 || this.receivedEOS)) {
                    try {
                        this.bufferLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.buffer2Pending) {
                this.write(this.buffer2, this.buffer2PendingLocation, this.buffer2Length);
                this.buffer2Pending = false;
            }
            n = this.bufferLock;
            synchronized (n) {
                if (this.buffer1Pending) {
                    byte[] byArray = this.buffer2;
                    this.buffer2 = this.buffer1;
                    this.buffer2Pending = true;
                    this.buffer2PendingLocation = this.buffer1PendingLocation;
                    this.buffer2Length = this.buffer1Length;
                    this.buffer1Pending = false;
                    this.buffer1 = byArray;
                    this.bufferLock.notifyAll();
                } else if (this.receivedEOS) {
                    break;
                }
            }
        }
        if (this.receivedEOS) {
            if (this.raFile != null) {
                if (!this.streamingEnabled) {
                    try {
                        this.raFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.raFile = null;
                }
                this.fileClosed = true;
            }
            if (!this.streamingEnabled) {
                this.sendEndofStreamEvent();
            }
        }
        if (this.errorEncountered && this.state != 3) {
            this.close(this.errorReason);
        }
    }

    public synchronized long seek(long l) {
        this.nextLocation = l;
        return l;
    }

    public void setEnabled(boolean bl) {
        this.streamingEnabled = bl;
    }

    public void setOutputLocator(MediaLocator mediaLocator) {
        this.locator = mediaLocator;
    }

    public void setSource(DataSource dataSource) throws IncompatibleSourceException {
        if (!(dataSource instanceof PushDataSource) && !(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException("Incompatible datasource");
        }
        this.source = dataSource;
        if (this.source instanceof PushDataSource) {
            this.push = true;
            try {
                ((PushDataSource)this.source).connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.streams = ((PushDataSource)this.source).getStreams();
        } else {
            this.push = false;
            try {
                ((PullDataSource)this.source).connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.streams = ((PullDataSource)this.source).getStreams();
        }
        if (this.streams == null || this.streams.length != 1) {
            throw new IncompatibleSourceException("DataSource should have 1 stream");
        }
        this.stream = this.streams[0];
        this.contentType = this.source.getContentType();
        if (this.push) {
            ((PushSourceStream)this.stream).setTransferHandler(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int n) {
        Handler handler = this;
        synchronized (handler) {
            this.state = n;
        }
    }

    public void setSyncEnabled() {
        this.syncEnabled = true;
    }

    public void start() throws IOException {
        if (this.state == 1) {
            if (this.source != null) {
                this.source.start();
            }
            if (this.writeThread == null) {
                this.writeThread = new Thread(this);
                this.writeThread.start();
            }
            this.setState(2);
        }
    }

    public void stop() throws IOException {
        if (this.state == 2) {
            if (this.source != null) {
                this.source.stop();
            }
            this.setState(1);
        }
    }

    public long tell() {
        return this.nextLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transferData(PushSourceStream pushSourceStream) {
        Integer n;
        int n2 = 0;
        int n3 = 131072;
        int n4 = 0;
        if (this.errorEncountered) {
            return;
        }
        if (this.buffer1Pending) {
            n = this.bufferLock;
            synchronized (n) {
                while (this.buffer1Pending) {
                    try {
                        this.bufferLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        while (n3 > 0) {
            try {
                n4 = pushSourceStream.read(this.buffer1, n2, n3);
                if (n4 > 16384 && this.WRITE_CHUNK_SIZE < 32768) {
                    if (n4 > 65536 && this.WRITE_CHUNK_SIZE < 131072) {
                        this.WRITE_CHUNK_SIZE = 131072;
                    } else if (n4 > 32768 && this.WRITE_CHUNK_SIZE < 65536) {
                        this.WRITE_CHUNK_SIZE = 65536;
                    } else if (this.WRITE_CHUNK_SIZE < 32768) {
                        this.WRITE_CHUNK_SIZE = 32768;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n4 <= 0) break;
            n2 += n4;
            n3 -= n4;
        }
        if (n2 > 0) {
            n = this.bufferLock;
            synchronized (n) {
                this.buffer1Pending = true;
                this.buffer1PendingLocation = this.nextLocation;
                this.buffer1Length = n2;
                this.nextLocation = -1L;
                this.bufferLock.notifyAll();
            }
        }
        if (n4 == -1) {
            this.receivedEOS = true;
            while (!this.fileClosed && !this.errorEncountered && this.state != 3) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void write(byte[] byArray, long l, int n) {
        try {
            if (l != -1L) {
                this.doSeek(l);
            }
            int n2 = 0;
            while (n > 0) {
                int n3 = this.WRITE_CHUNK_SIZE;
                if (n < n3) {
                    n3 = n;
                }
                this.raFile.write(byArray, n2, n3);
                this.bytesWritten += n3;
                if (this.fileDescriptor != null && this.syncEnabled && this.bytesWritten >= this.WRITE_CHUNK_SIZE) {
                    this.bytesWritten -= this.WRITE_CHUNK_SIZE;
                    this.fileDescriptor.sync();
                }
                this.filePointer += n3;
                n -= n3;
                n2 += n3;
                if (this.filePointer > this.fileSize) {
                    this.fileSize = this.filePointer;
                }
                Thread.yield();
            }
        }
        catch (IOException iOException) {
            this.errorEncountered = true;
            this.errorReason = iOException.toString();
        }
    }

    public boolean write(long l, int n) {
        try {
            if (l >= 0L && n > 0) {
                int n2;
                this.raFile.seek(l);
                for (int i = n; i > 0; i -= n2) {
                    n2 = i > 131072 ? 131072 : i;
                    this.raFile.read(this.buffer1, 0, n2);
                    this.qtStrRaFile.write(this.buffer1, 0, n2);
                }
            } else if (l < 0L && n > 0) {
                this.qtStrRaFile.seek(0L);
                this.qtStrRaFile.seek(n - 1);
                this.qtStrRaFile.writeByte(0);
                this.qtStrRaFile.seek(0L);
            } else {
                this.sendEndofStreamEvent();
            }
        }
        catch (Exception exception) {
            this.errorCreatingStreamingFile = true;
            System.err.println("Exception when creating streamable version of media file: " + exception.getMessage());
            return false;
        }
        return true;
    }
}

