/*
 * Decompiled with CFR 0.152.
 */
package javax.sip;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class DialogState
implements Serializable {
    private int m_dialogState;
    private static int m_size = 4;
    private static DialogState[] m_dialogStateArray = new DialogState[m_size];
    public static final int _EARLY = 0;
    public static final DialogState EARLY = new DialogState(0);
    public static final int _CONFIRMED = 1;
    public static final DialogState CONFIRMED = new DialogState(1);
    public static final int _COMPLETED = 2;
    public static final DialogState COMPLETED = new DialogState(2);
    public static final int _TERMINATED = 3;
    public static final DialogState TERMINATED = new DialogState(3);

    private DialogState(int dialogState) {
        this.m_dialogState = dialogState;
        DialogState.m_dialogStateArray[this.m_dialogState] = this;
    }

    public static DialogState getObject(int dialogState) {
        if (dialogState >= 0 && dialogState < m_size) {
            return m_dialogStateArray[dialogState];
        }
        throw new IllegalArgumentException("Invalid dialogState value");
    }

    public int getValue() {
        return this.m_dialogState;
    }

    private Object readResolve() throws ObjectStreamException {
        return m_dialogStateArray[this.m_dialogState];
    }

    public String toString() {
        String text = "";
        switch (this.m_dialogState) {
            case 0: {
                text = "Early Dialog";
                break;
            }
            case 1: {
                text = "Confirmed Dialog";
                break;
            }
            case 2: {
                text = "Completed Dialog";
                break;
            }
            case 3: {
                text = "Terminated Dialog";
                break;
            }
            default: {
                text = "Error while printing Dialog State";
            }
        }
        return text;
    }
}

