/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import java.io.File;

public abstract class FileWatcher
extends Thread {
    private static Loggerf log = Loggerf.getLogger(FileWatcher.class);
    private File file;
    private long delay = 1000L;

    public FileWatcher(File file) {
        super("Watcher-" + file.getName());
        this.file = file;
        this.setDaemon(true);
    }

    public void run() {
        boolean lastExists = this.file.exists();
        long lastLastModified = this.file.lastModified();
        while (!this.isInterrupted()) {
            if (this.file.exists()) {
                if (!lastExists) {
                    this.doFileChanged();
                    lastExists = true;
                } else {
                    long lastModified = this.file.lastModified();
                    if (lastModified != lastLastModified) {
                        this.doFileChanged();
                        lastLastModified = lastModified;
                    }
                }
            } else if (lastExists) {
                this.doFileChanged();
                lastExists = false;
            }
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {}
        }
    }

    private void doFileChanged() {
        log.info("%s changed", this.file.getName());
        this.fileChanged(this.file);
    }

    protected abstract void fileChanged(File var1);

    public static void main(String[] args) {
        FileWatcher watcher = new FileWatcher(new File("/Users/emcee/.bash_profile")){

            protected void fileChanged(File file) {
                System.out.println(file + " changed");
            }
        };
        watcher.setDaemon(false);
        watcher.start();
    }
}

