/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Objects;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.DatagramSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.util.concurrent.ExecutorService;

public class Closer {
    private static Loggerf log = Loggerf.getLogger(Closer.class);

    public static boolean close(Object closeable) {
        if (closeable != null) {
            try {
                if (closeable instanceof Closeable) {
                    ((Closeable)closeable).close();
                } else if (closeable instanceof InputStream) {
                    ((InputStream)closeable).close();
                } else if (closeable instanceof OutputStream) {
                    ((OutputStream)closeable).close();
                } else if (closeable instanceof Writer) {
                    ((Writer)closeable).close();
                } else if (closeable instanceof Reader) {
                    ((Reader)closeable).close();
                } else if (closeable instanceof ExecutorService) {
                    ((ExecutorService)closeable).shutdown();
                } else if (closeable instanceof Socket) {
                    ((Socket)closeable).close();
                } else if (closeable instanceof DatagramSocket) {
                    ((DatagramSocket)closeable).close();
                } else if (closeable instanceof FileChannel) {
                    ((FileChannel)closeable).close();
                } else {
                    Objects.invoke(closeable, "close", new Object[0]);
                }
                return true;
            }
            catch (Exception e) {
                log.error("Error closing %s", closeable, e);
                return false;
            }
        }
        return true;
    }

    public static boolean closeAll(Object ... closeables) {
        boolean success = true;
        for (Object closeable : closeables) {
            success &= Closer.close(closeable);
        }
        return success;
    }
}

