/*
 * Decompiled with CFR 0.152.
 */
package com.sun.stun;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StunHeader {
    private static final Logger logger = Logger.getLogger(StunHeader.class.getName());
    public static final int STUN_HEADER_LENGTH = 20;
    public static final int TLV_LENGTH = 4;
    public static final int ERROR_CODE_LENGTH = 4;
    public static final int BINDING_REQUEST = 1;
    public static final int BINDING_RESPONSE = 257;
    public static final int MAPPED_ADDRESS = 1;
    public static final int MAPPED_ADDRESS_LENGTH = 8;
    public static final int RESPONSE_ADDRESS = 2;
    public static final int RESPONSE_ADDRESS_LENGTH = 8;
    public static final int CHANGE_REQUEST = 3;
    public static final int CHANGE_REQUEST_LENGTH = 4;
    public static final int CHANGE_PORT_MASK = 2;
    public static final int CHANGE_IP_MASK = 4;
    public static final int CHANGED_ADDRESS = 5;
    public static final int CHANGED_ADDRESS_LENGTH = 8;
    public static final int BAD_REQUEST = 400;
    public static final int GLOBAL_ERROR = 600;

    public static void setLogLevel(Level newLevel) {
        logger.setLevel(newLevel);
    }

    public static InetSocketAddress getAddress(byte[] request, int desiredType) {
        int attributeLength;
        InetSocketAddress isa = null;
        int offset = 20;
        logger.finest("Searching for type " + Integer.toHexString(desiredType));
        for (int length = request[2] << 8 & 0xFF00 | request[3] & 0xFF; length > 0; length -= 4 + attributeLength) {
            InetAddress ia;
            byte type = request[offset + 1];
            attributeLength = request[offset + 2] << 8 & 0xFF00 | request[offset + 3] & 0xFF;
            if (type != desiredType) {
                logger.finest("Skipping type " + type);
                offset += 4 + attributeLength;
                continue;
            }
            if (attributeLength != 8) {
                logger.warning("Invalid Response Address Length " + attributeLength);
                return null;
            }
            int port = request[offset + 6] << 8 & 0xFF00 | request[offset + 7] & 0xFF;
            try {
                byte[] address = new byte[]{request[offset + 8], request[offset + 9], request[offset + 10], request[offset + 11]};
                ia = InetAddress.getByAddress(address);
            }
            catch (UnknownHostException e) {
                logger.warning("Invalid Response Address:  " + e.getMessage());
                return null;
            }
            isa = new InetSocketAddress(ia, port);
            logger.finest("Found Address " + isa);
            break;
        }
        return isa;
    }

    public static int getChangeRequest(byte[] request) {
        int attributeLength;
        int changeRequest = 0;
        int offset = 20;
        logger.finest("Searching for change request attribute");
        for (int length = request[2] << 8 & 0xFF00 | request[3] & 0xFF; length > 0; length -= 4 + attributeLength) {
            byte type = request[offset + 1];
            attributeLength = request[offset + 2] << 8 & 0xFF00 | request[offset + 3] & 0xFF;
            if (type != 3) {
                logger.finest("Skipping type " + type);
                offset += 4 + attributeLength;
                continue;
            }
            if (attributeLength != 4) {
                logger.warning("Invalid Change Request Length " + attributeLength);
                return 0;
            }
            changeRequest = request[offset + 7];
            logger.finest("Found change request " + changeRequest);
            break;
        }
        return changeRequest;
    }

    public static void dump(String msg, byte[] data, int offset, int length) {
        logger.info(msg);
        String s = "";
        String t = "";
        char[] v = new char[1];
        for (int i = 0; i < length; ++i) {
            if (i % 16 == 0) {
                if (i > 0) {
                    logger.info(s + "\t" + t);
                }
                s = Integer.toHexString(i + offset) + ":  ";
                t = "";
            }
            s = s + Integer.toHexString(data[i] & 0xFF) + " ";
            v[0] = (char)(data[i + offset] & 0xFF);
            t = v[0] < ' ' || v[0] > '~' ? t + "." : t + String.copyValueOf(v);
        }
        logger.info(s + "\t" + t);
    }
}

