/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim;

import net.kano.joscar.DefensiveTools;

public final class Screenname
implements Comparable {
    private final String format;
    private final String normal;
    private final int hashCode;

    public Screenname(String string) {
        DefensiveTools.checkNull(string, "format");
        this.format = string;
        this.normal = Screenname.normalize(string);
        this.hashCode = this.normal.hashCode();
    }

    public String getFormatted() {
        return this.format;
    }

    public String getNormal() {
        return this.normal;
    }

    public boolean matches(String string) {
        DefensiveTools.checkNull(string, "screenname");
        return Screenname.normalize(string).equals(this.normal);
    }

    public int compareTo(Object object) {
        return this.format.compareTo(this.format);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Screenname)) {
            return false;
        }
        Screenname screenname = (Screenname)object;
        return this.hashCode() == screenname.hashCode() && this.getNormal().equals(screenname.getNormal());
    }

    public String toString() {
        return this.format;
    }

    public static String normalize(String string) {
        int n;
        DefensiveTools.checkNull(string, "str");
        boolean bl = true;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (n >= 48 && n <= 57 || n >= 97 && n <= 122) continue;
            bl = false;
            break;
        }
        if (bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c == ' ') continue;
            stringBuffer.append(Character.toLowerCase(c));
        }
        return stringBuffer.toString();
    }
}

