/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.dcc;

import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.OutCommand;
import f00f.net.irc.martyr.commands.CtcpMessage;
import f00f.net.irc.martyr.dcc.DccChatHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class ChatRequestCommand
implements OutCommand {
    static Logger log = Logger.getLogger(ChatRequestCommand.class);
    public static final int SO_TIMEOUT = 30000;
    private String rendered;

    public ChatRequestCommand(IRCConnection conn, String toWhom, DccChatHandler handler) throws IOException {
        this(conn.getLocalAddress(), toWhom, handler, 30000);
    }

    public ChatRequestCommand(InetAddress local, String toWhom, DccChatHandler handler, int timeout) throws IOException {
        byte[] raw = local.getAddress();
        long addr = 0L;
        for (byte aRaw : raw) {
            int one = aRaw & 0xFF;
            addr <<= 8;
            addr += (long)one;
        }
        ServerSocket ss = new ServerSocket(0, 1, local);
        ss.setSoTimeout(timeout);
        this.startHandlerThread(ss, handler);
        int lport = ss.getLocalPort();
        this.rendered = new CtcpMessage(toWhom, "DCC", "CHAT CHAT " + addr + " " + lport).render();
        log.debug((Object)("ChatRequestCommand: " + this.rendered));
    }

    protected void startHandlerThread(ServerSocket ss, DccChatHandler handler) {
        new HandlerStarter(ss, handler).start();
    }

    public String getIrcIdentifier() {
        return null;
    }

    public String render() {
        return this.rendered;
    }

    private static class HandlerStarter
    extends Thread {
        private ServerSocket ss;
        private DccChatHandler handler;

        public HandlerStarter(ServerSocket ss, DccChatHandler handler) {
            this.ss = ss;
            this.handler = handler;
        }

        public void run() {
            try {
                Socket s = this.ss.accept();
                this.handler.setSocket(s);
                this.handler.start();
            }
            catch (IOException ioe) {
                log.error((Object)("ChatRequestCommand: " + ioe.toString()));
                ioe.printStackTrace();
            }
        }
    }
}

