/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public abstract class SnacFamilyListCmd
extends ConnCommand {
    private final int[] snacFamilies;

    protected SnacFamilyListCmd(int command, SnacPacket packet) {
        super(command);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.snacFamilies = new int[snacData.getLength() / 2];
        int i = 0;
        while (i * 2 < snacData.getLength() - 1) {
            this.snacFamilies[i] = BinaryTools.getUShort((ByteBlock)snacData, (int)(i * 2));
            ++i;
        }
    }

    protected SnacFamilyListCmd(int command, int[] snacFamilies) {
        super(command);
        this.snacFamilies = snacFamilies == null ? null : (int[])snacFamilies.clone();
    }

    public final int[] getSnacFamilies() {
        return this.snacFamilies == null ? null : (int[])this.snacFamilies.clone();
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.snacFamilies != null) {
            for (int snacFamily : this.snacFamilies) {
                BinaryTools.writeUShort((OutputStream)out, (int)snacFamily);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(MiscTools.getClassName(this) + ": snac families: ");
        if (this.snacFamilies != null) {
            for (int i = 0; i < this.snacFamilies.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(Integer.toHexString(this.snacFamilies[i]));
            }
        }
        return buffer.toString();
    }
}

