/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.jml.net.Message;
import net.sf.jml.net.MessageRecognizer;
import net.sf.jml.net.SessionListener;
import net.sf.jml.util.ByteBufferUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Session {
    private static final Log logger = LogFactory.getLog(Session.class);
    private final Collection<SessionListener> sessionListeners = new CopyOnWriteArrayList<SessionListener>();
    private Socket socket = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean isStarted = false;
    private SocketAddress socketAddress = null;
    private Object attachment = null;
    private MessageRecognizer messagerecognizer = null;
    private boolean isClosing = false;
    private boolean isAvailable = false;
    private MsgSender msgSender = null;
    private MsgDispatcher msgDispatcher = null;
    private Timer timoutTimer = null;

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocketAddress(SocketAddress socketAddress) throws IllegalStateException {
        if (this.isStarted) {
            throw new IllegalStateException("can't set socket address after session started");
        }
        this.socketAddress = socketAddress;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object object) {
        this.attachment = object;
    }

    public void setMessageRecognizer(MessageRecognizer messageRecognizer) {
        this.messagerecognizer = messageRecognizer;
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.sessionListeners.add(sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionListeners.remove(sessionListener);
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void start(boolean bl) throws IllegalStateException {
        this.msgDispatcher = new MsgDispatcher();
        Thread thread = new Thread((Runnable)this.msgDispatcher, "net.sf.jml.net.SocketSession.msgDispatcher");
        thread.start();
        this.msgSender = new MsgSender();
        Thread thread2 = new Thread((Runnable)this.msgSender, "net.sf.jml.net.SocketSession.msgSender");
        thread2.start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block15: {
                    try {
                        Session.this.socket = new Socket();
                        Session.this.socket.connect(Session.this.socketAddress);
                        Session.this.socket.setKeepAlive(false);
                        Session.this.isAvailable = true;
                        Session.this.in = Session.this.socket.getInputStream();
                        Session.this.out = Session.this.socket.getOutputStream();
                        Session.this.fireSessionEstablished();
                    }
                    catch (Exception exception) {
                        logger.error((Object)"error establishing connection ", (Throwable)exception);
                        Session.this.firExceptionCaught(exception);
                        return;
                    }
                    ByteBuffer byteBuffer = ByteBufferUtils.allocate(131072, false);
                    try {
                        int n;
                        do {
                            ByteBuffer byteBuffer2 = byteBuffer;
                            synchronized (byteBuffer2) {
                                if (byteBuffer == null) {
                                    byteBuffer = ByteBufferUtils.allocate(131072, false);
                                } else if (!byteBuffer.hasRemaining()) {
                                    byteBuffer = ByteBufferUtils.increaseCapacity(byteBuffer, 131072);
                                }
                                byte[] byArray = new byte[4096];
                                n = Session.this.in.read(byArray);
                                if (n < 0) {
                                    return;
                                }
                                byte[] byArray2 = new byte[n];
                                System.arraycopy(byArray, 0, byArray2, 0, n);
                                byteBuffer.put(byArray2);
                                byteBuffer.flip();
                                Session.this.recognizeMessageAndDispatch(byteBuffer);
                                byteBuffer.compact();
                            }
                        } while (n > 0);
                    }
                    catch (SocketException socketException) {
                        if (Session.this.isClosing) {
                            Session.this.isClosing = false;
                        } else {
                            logger.debug((Object)"Smth happen to connection", (Throwable)socketException);
                            Session.this.fireSessionClosed();
                        }
                    }
                    catch (IOException iOException) {
                        logger.error((Object)"Smth happen to connection - IO ex", (Throwable)iOException);
                        if (Session.this.isClosing) break block15;
                        Session.this.fireSessionClosed();
                    }
                }
            }
        }, "net.sf.jml.net.SocketSession.reader").start();
    }

    protected void recognizeMessageAndDispatch(ByteBuffer byteBuffer) {
        Message message;
        while (byteBuffer.hasRemaining() && (message = this.recognizeMessage(byteBuffer)) != null) {
            this.msgDispatcher.dispacthMsg(message);
        }
    }

    protected Message recognizeMessage(ByteBuffer byteBuffer) {
        Message message = this.messagerecognizer.recognize(this, byteBuffer.asReadOnlyBuffer());
        if (message == null) {
            return null;
        }
        boolean bl = message.readFromBuffer(byteBuffer);
        if (bl) {
            return message;
        }
        return null;
    }

    private void fireMessageReceived(Message message) {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.messageReceived(this, message);
            }
            catch (Exception exception) {
                logger.error((Object)"error firing events for msg received", (Throwable)exception);
            }
        }
    }

    private void fireMessageSent(Message message) {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.messageSent(this, message);
            }
            catch (Exception exception) {
                logger.error((Object)"error firing events for msg sent", (Throwable)exception);
            }
        }
    }

    private void fireSessionClosed() {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.sessionClosed(this);
            }
            catch (Exception exception) {
                logger.error((Object)"error firing events for close", (Throwable)exception);
            }
        }
    }

    private void firExceptionCaught(Throwable throwable) {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.exceptionCaught(this, throwable);
            }
            catch (Exception exception) {
                logger.error((Object)"error firing events for firExceptionCaught", (Throwable)exception);
            }
        }
    }

    private void fireSessionEstablished() {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.sessionEstablished(this);
            }
            catch (Exception exception) {
                logger.error((Object)"error firing events for sessionEstablished", (Throwable)exception);
            }
        }
    }

    private void fireSessionTimeout() {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.sessionTimeout(this);
            }
            catch (Exception exception) {
                logger.error((Object)"error firing events for sessionEstablished", (Throwable)exception);
            }
        }
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean bl) {
        if (this.isClosing) {
            return;
        }
        this.isClosing = true;
        this.msgDispatcher.stopDispatcher();
        this.msgSender.stopSender();
        try {
            this.socket.shutdownInput();
        }
        catch (IOException iOException) {
            logger.error((Object)"error shutting down input on socket", (Throwable)iOException);
        }
        try {
            this.socket.getOutputStream().flush();
        }
        catch (IOException iOException) {
            logger.error((Object)"error flushing remaining output on socket", (Throwable)iOException);
        }
        if (this.timoutTimer != null) {
            this.timoutTimer.cancel();
            this.timoutTimer = null;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            logger.error((Object)"error closing socket", (Throwable)iOException);
        }
        this.isAvailable = false;
        this.fireSessionClosed();
    }

    public void write(Message message) throws IllegalArgumentException, IllegalStateException {
        this.msgSender.sendMsg(message);
    }

    public boolean blockWrite(Message message) throws IllegalArgumentException, IllegalStateException {
        try {
            this.sendMessage(message);
        }
        catch (IOException iOException) {
            logger.error((Object)"error sending msg", (Throwable)iOException);
            return false;
        }
        this.fireMessageSent(message);
        return true;
    }

    private synchronized void sendMessage(Message message) throws IOException {
        ByteBuffer[] byteBufferArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (ByteBuffer byteBuffer : byteBufferArray = message.toByteBuffer()) {
            byte[] byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray, 0, byArray.length);
            byteArrayOutputStream.write(byArray);
        }
        byteArrayOutputStream.writeTo(this.out);
        this.out.flush();
    }

    public void setSessionTimeout(int n) {
        logger.debug((Object)("setSessionTimeout:" + n));
        if (this.socket != null) {
            if (this.timoutTimer == null) {
                this.timoutTimer = new Timer();
            }
            this.timoutTimer.schedule((TimerTask)new TimeoutFire(), n);
        }
    }

    private class TimeoutFire
    extends TimerTask {
        private TimeoutFire() {
        }

        public void run() {
            Session.this.fireSessionTimeout();
        }
    }

    private class MsgSender
    extends Thread {
        final Vector<Message> queue = new Vector();
        boolean isRunning = true;

        private MsgSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopSender() {
            Object object;
            this.isRunning = false;
            this.interrupt();
            while (!this.queue.isEmpty()) {
                object = this.queue.remove(0);
                try {
                    Session.this.sendMessage((Message)object);
                    Session.this.fireMessageSent((Message)object);
                }
                catch (IOException iOException) {
                    logger.error((Object)("error sending msg: " + object), (Throwable)iOException);
                }
            }
            object = this.queue;
            synchronized (object) {
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.isRunning) {
                Vector<Message> vector = this.queue;
                synchronized (vector) {
                    if (this.queue.isEmpty()) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    if (this.queue.isEmpty()) {
                        return;
                    }
                    Message message = this.queue.remove(0);
                    try {
                        Session.this.sendMessage(message);
                        Session.this.fireMessageSent(message);
                    }
                    catch (IOException iOException) {
                        logger.error((Object)("error sending msg: " + message), (Throwable)iOException);
                        iOException.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMsg(Message message) {
            Vector<Message> vector = this.queue;
            synchronized (vector) {
                this.queue.add(message);
                this.queue.notifyAll();
            }
        }
    }

    private class MsgDispatcher
    extends Thread {
        final Vector<Message> queue = new Vector();
        boolean isRunning = true;
        byte[] notDispatchedBuffer = null;

        private MsgDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopDispatcher() {
            Object object;
            this.isRunning = false;
            this.interrupt();
            while (!this.queue.isEmpty()) {
                object = this.queue.remove(0);
                Session.this.fireMessageReceived((Message)object);
            }
            object = this.queue;
            synchronized (object) {
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.isRunning) {
                Object object = this.queue;
                synchronized (object) {
                    if (this.queue.isEmpty()) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
                if (this.queue.isEmpty()) continue;
                object = this.queue.remove(0);
                Session.this.fireMessageReceived((Message)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispacthMsg(Message message) {
            Vector<Message> vector = this.queue;
            synchronized (vector) {
                this.queue.add(message);
                this.queue.notifyAll();
            }
        }
    }
}

