/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class TCPInputStream
extends InputStream {
    private final List<byte[]> packets = new ArrayList<byte[]>();
    private byte[] currentPacket = null;
    private int currentPacketOffset = 0;
    private int currentPacketLength = 0;
    private final Object readSyncRoot = new Object();

    public int available() {
        return 0;
    }

    public void close() throws IOException {
        this.packets.clear();
        this.currentPacket = null;
        this.currentPacketOffset = 0;
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) {
        Object object = this.readSyncRoot;
        synchronized (object) {
            this.getNextPacket();
            int length = this.currentPacketLength;
            if (len < length) {
                length = len;
            }
            System.arraycopy(this.currentPacket, this.currentPacketOffset, b, off, length);
            this.currentPacketOffset += length;
            this.currentPacketLength -= length;
            if (this.currentPacketLength <= 0) {
                this.currentPacket = null;
                this.currentPacketOffset = 0;
                this.currentPacketLength = 0;
            }
            return length;
        }
    }

    public void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("TCPInputStream does not support reset()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        Object object = this.readSyncRoot;
        synchronized (object) {
            this.getNextPacket();
            if (n > (long)this.currentPacketLength) {
                n = this.currentPacketLength;
            }
            this.currentPacketOffset = (int)((long)this.currentPacketOffset + n);
            this.currentPacketLength = (int)((long)this.currentPacketLength - n);
            if (this.currentPacketLength <= 0) {
                this.currentPacket = null;
                this.currentPacketOffset = 0;
                this.currentPacketLength = 0;
            }
            return n;
        }
    }

    public int read() throws IOException {
        this.getNextPacket();
        byte ret = this.currentPacket[this.currentPacketOffset];
        ++this.currentPacketOffset;
        --this.currentPacketLength;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getNextPacket() {
        List<byte[]> list = this.packets;
        synchronized (list) {
            if (this.packets.size() == 0) {
                try {
                    this.packets.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.currentPacket == null) {
                this.currentPacket = this.packets.remove(0);
                this.currentPacketOffset = 0;
                this.currentPacketLength = this.currentPacket.length;
            }
        }
        return this.currentPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacket(byte[] p) {
        List<byte[]> list = this.packets;
        synchronized (list) {
            this.packets.add(p);
            this.packets.notifyAll();
        }
    }
}

