/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.lang.ref.WeakReference;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Videobridge;

class VideobridgeExpireThread
extends Thread {
    private static final Logger logger = Logger.getLogger(VideobridgeExpireThread.class);
    private final WeakReference<Videobridge> videobridge;

    public VideobridgeExpireThread(Videobridge videobridge) {
        this.videobridge = new WeakReference<Videobridge>(videobridge);
        this.setDaemon(true);
        this.setName(this.getClass().getName());
    }

    private void expire(Videobridge videobridge) {
        for (Conference conference : videobridge.getConferences()) {
            Content[] contents = conference.getContents();
            if (contents.length == 0) {
                if (conference.getLastActivityTime() + 60000L >= System.currentTimeMillis()) continue;
                try {
                    conference.expire();
                    continue;
                }
                catch (Throwable t) {
                    logger.warn((Object)("Failed to expire conference " + conference.getID() + "!"), t);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            for (Content content : conference.getContents()) {
                Channel[] channels = content.getChannels();
                if (channels.length == 0) {
                    if (content.getLastActivityTime() + 60000L >= System.currentTimeMillis()) continue;
                    try {
                        content.expire();
                        continue;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to expire content " + content.getName() + " of conference " + conference.getID() + "!"), t);
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
                for (Channel channel : channels) {
                    if (channel.getLastActivityTime() + 1000L * (long)channel.getExpire() >= System.currentTimeMillis()) continue;
                    try {
                        channel.expire();
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to expire channel " + channel.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), t);
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
            }
        }
    }

    public void run() {
        Videobridge videobridge;
        long wakeup = -1L;
        long sleep = 60000L;
        while ((videobridge = (Videobridge)this.videobridge.get()) != null) {
            long slept;
            long now = System.currentTimeMillis();
            if (wakeup != -1L && (slept = now - wakeup) < 60000L) {
                boolean interrupted = false;
                try {
                    Thread.sleep(60000L - slept);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            wakeup = now;
            try {
                this.expire(videobridge);
            }
            catch (Throwable t) {
                logger.error((Object)"Failed to complete an iteration of automatic expiry of channels, contents, and conferences!", t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }
}

