/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Endpoint
extends PropertyChangeNotifier {
    public static final String CHANNELS_PROPERTY_NAME = Endpoint.class.getName() + ".channels";
    private final List<WeakReference<RtpChannel>> channels = new LinkedList<WeakReference<RtpChannel>>();
    private WeakReference<SctpConnection> sctpConnection = new WeakReference<Object>(null);
    private final String id;

    public Endpoint(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannel(RtpChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (channel.isExpired()) {
            return false;
        }
        boolean added = false;
        boolean removed = false;
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            boolean add = true;
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                RtpChannel c = (RtpChannel)i.next().get();
                if (c == null) {
                    i.remove();
                    removed = true;
                    continue;
                }
                if (c.equals(channel)) {
                    add = false;
                    continue;
                }
                if (!c.isExpired()) continue;
                i.remove();
                removed = true;
            }
            if (add) {
                this.channels.add(new WeakReference<RtpChannel>(channel));
                added = true;
            }
        }
        if (added || removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return added;
    }

    void audioLevelChanged(Channel channel, long ssrc, int audioLevel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtpChannel> getChannels(MediaType mediaType) {
        LinkedList<RtpChannel> channels = new LinkedList<RtpChannel>();
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            for (WeakReference<RtpChannel> channel1 : this.channels) {
                RtpChannel channel = (RtpChannel)channel1.get();
                if (channel == null || mediaType != null && !mediaType.equals((Object)channel.getContent().getMediaType())) continue;
                channels.add(channel);
            }
        }
        return channels;
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannel(RtpChannel channel) {
        if (channel == null) {
            return false;
        }
        boolean removed = false;
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                Channel c = (Channel)((Object)i.next().get());
                if (c != null && !((Object)((Object)c)).equals(channel) && !c.isExpired()) continue;
                i.remove();
                removed = true;
            }
        }
        if (removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return removed;
    }

    public void setSctpConnection(SctpConnection sctpConnection) {
        this.sctpConnection = new WeakReference<SctpConnection>(sctpConnection);
    }

    public SctpConnection getSctpConnection() {
        return (SctpConnection)((Object)this.sctpConnection.get());
    }
}

