/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsClient;
import org.bouncycastle.crypto.tls.DefaultTlsSignerCredentials;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsSRTPUtils;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.tls.UseSRTPData;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.util.Logger;

public class TlsClientImpl
extends DefaultTlsClient {
    private static final Logger logger = Logger.getLogger(TlsClientImpl.class);
    private final TlsAuthentication authentication = new TlsAuthenticationImpl();
    private int chosenProtectionProfile;
    private final byte[] mki = TlsUtils.EMPTY_BYTES;
    private final DtlsPacketTransformer packetTransformer;

    public TlsClientImpl(DtlsPacketTransformer packetTransformer) {
        this.packetTransformer = packetTransformer;
    }

    public synchronized TlsAuthentication getAuthentication() throws IOException {
        return this.authentication;
    }

    int getChosenProtectionProfile() {
        return this.chosenProtectionProfile;
    }

    public int[] getCipherSuites() {
        return new int[]{49199, 49191, 49171, 156, 60, 47};
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = super.getClientExtensions();
        if (!this.getDtlsControl().isSrtpDisabled() && TlsSRTPUtils.getUseSRTPExtension((Hashtable)clientExtensions) == null) {
            if (clientExtensions == null) {
                clientExtensions = new Hashtable();
            }
            TlsSRTPUtils.addUseSRTPExtension(clientExtensions, (UseSRTPData)new UseSRTPData(DtlsControlImpl.SRTP_PROTECTION_PROFILES, this.mki));
        }
        return clientExtensions;
    }

    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.DTLSv10;
    }

    TlsContext getContext() {
        return this.context;
    }

    private DtlsControlImpl getDtlsControl() {
        return this.packetTransformer.getDtlsControl();
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.DTLSv10;
    }

    public void init(TlsClientContext context) {
        super.init(context);
    }

    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        int chosenProtectionProfile;
        if (this.getDtlsControl().isSrtpDisabled()) {
            super.processServerExtensions(serverExtensions);
            return;
        }
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)serverExtensions);
        if (useSRTPData == null) {
            String msg = "DTLS extended server hello does not include the use_srtp extension!";
            IOException ioe = new IOException(msg);
            logger.error(msg, ioe);
            throw ioe;
        }
        int[] protectionProfiles = useSRTPData.getProtectionProfiles();
        int n = chosenProtectionProfile = protectionProfiles.length == 1 ? DtlsControlImpl.chooseSRTPProtectionProfile(protectionProfiles[0]) : 0;
        if (chosenProtectionProfile == 0) {
            String msg = "No chosen SRTP protection profile!";
            TlsFatalAlert tfa = new TlsFatalAlert(47);
            logger.error(msg, (Throwable)tfa);
            throw tfa;
        }
        byte[] mki = useSRTPData.getMki();
        if (!Arrays.equals(mki, this.mki)) {
            String msg = "Server's MKI does not match the one offered by this client!";
            TlsFatalAlert tfa = new TlsFatalAlert(47);
            logger.error(msg, (Throwable)tfa);
            throw tfa;
        }
        super.processServerExtensions(serverExtensions);
        this.chosenProtectionProfile = chosenProtectionProfile;
    }

    private class TlsAuthenticationImpl
    implements TlsAuthentication {
        private TlsCredentials clientCredentials;

        private TlsAuthenticationImpl() {
        }

        public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
            if (this.clientCredentials == null) {
                DtlsControlImpl dtlsControl = TlsClientImpl.this.getDtlsControl();
                this.clientCredentials = new DefaultTlsSignerCredentials((TlsContext)TlsClientImpl.this.context, dtlsControl.getCertificate(), dtlsControl.getKeyPair().getPrivate());
            }
            return this.clientCredentials;
        }

        public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
            try {
                TlsClientImpl.this.getDtlsControl().verifyAndValidateCertificate(serverCertificate);
            }
            catch (Exception e) {
                logger.error("Failed to verify and/or validate server certificate!", e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
    }
}

