/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.device.ScreenDeviceImpl;
import org.jitsi.impl.neomedia.format.AudioMediaFormatImpl;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.impl.neomedia.format.ParameterizedVideoFormat;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.device.ScreenDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.OSUtils;

public class MediaUtils {
    public static final MediaFormat[] EMPTY_MEDIA_FORMATS;
    private static final Map<String, String> jmfEncodingToEncodings;
    public static final int MAX_AUDIO_CHANNELS;
    public static final double MAX_AUDIO_SAMPLE_RATE;
    public static final int MAX_AUDIO_SAMPLE_SIZE_IN_BITS;
    private static final List<MediaFormat> rtpPayloadTypelessMediaFormats;
    private static final Map<String, MediaFormat[]> rtpPayloadTypeStrToMediaFormats;

    private static void addMediaFormats(byte rtpPayloadType, String encoding, MediaType mediaType, String jmfEncoding, double ... clockRates) {
        MediaUtils.addMediaFormats(rtpPayloadType, encoding, mediaType, jmfEncoding, null, null, clockRates);
    }

    private static void addMediaFormats(byte rtpPayloadType, String encoding, MediaType mediaType, String jmfEncoding, Map<String, String> formatParameters, Map<String, String> advancedAttributes, double ... clockRates) {
        MediaUtils.addMediaFormats(rtpPayloadType, encoding, mediaType, jmfEncoding, 1, formatParameters, advancedAttributes, clockRates);
    }

    private static void addMediaFormats(byte rtpPayloadType, String encoding, MediaType mediaType, String jmfEncoding, int channels, Map<String, String> formatParameters, Map<String, String> advancedAttributes, double ... clockRates) {
        int clockRateCount = clockRates.length;
        ArrayList<MediaFormatImpl<Format>> mediaFormats = new ArrayList<MediaFormatImpl<Format>>(clockRateCount);
        if (clockRateCount > 0) {
            for (double clockRate : clockRates) {
                Format format;
                switch (mediaType) {
                    case AUDIO: {
                        if (channels == 1) {
                            format = new AudioFormat(jmfEncoding);
                            break;
                        }
                        format = new AudioFormat(jmfEncoding, -1.0, -1, channels);
                        break;
                    }
                    case VIDEO: {
                        format = new ParameterizedVideoFormat(jmfEncoding, formatParameters);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("mediaType");
                    }
                }
                MediaFormatImpl<Format> mediaFormat = MediaFormatImpl.createInstance(format, clockRate, formatParameters, advancedAttributes);
                if (mediaFormat == null) continue;
                mediaFormats.add(mediaFormat);
            }
        } else {
            double clockRate;
            Format format;
            switch (mediaType) {
                case AUDIO: {
                    AudioFormat audioFormat = new AudioFormat(jmfEncoding);
                    format = audioFormat;
                    clockRate = audioFormat.getSampleRate();
                    break;
                }
                case VIDEO: {
                    format = new ParameterizedVideoFormat(jmfEncoding, formatParameters);
                    clockRate = 90000.0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("mediaType");
                }
            }
            MediaFormatImpl<Format> mediaFormat = MediaFormatImpl.createInstance(format, clockRate, formatParameters, advancedAttributes);
            if (mediaFormat != null) {
                mediaFormats.add(mediaFormat);
            }
        }
        if (mediaFormats.size() > 0) {
            if (-1 == rtpPayloadType) {
                rtpPayloadTypelessMediaFormats.addAll(mediaFormats);
            } else {
                rtpPayloadTypeStrToMediaFormats.put(Byte.toString(rtpPayloadType), mediaFormats.toArray(EMPTY_MEDIA_FORMATS));
            }
            jmfEncodingToEncodings.put(((MediaFormatImpl)mediaFormats.get(0)).getJMFEncoding(), encoding);
        }
    }

    public static String createImageAttr(Dimension sendSize, Dimension maxRecvSize) {
        StringBuffer img = new StringBuffer();
        if (sendSize != null) {
            img.append("send [x=[0-");
            img.append((int)sendSize.getWidth());
            img.append("],y=[0-");
            img.append((int)sendSize.getHeight());
            img.append("]]");
        } else {
            img.append("send *");
        }
        if (maxRecvSize != null) {
            img.append(" recv [x=[0-");
            img.append((int)maxRecvSize.getWidth());
            img.append("],y=[0-");
            img.append((int)maxRecvSize.getHeight());
            img.append("]]");
        } else {
            img.append(" recv *");
        }
        return img.toString();
    }

    public static MediaFormat getMediaFormat(Format format) {
        double clockRate = format instanceof AudioFormat ? ((AudioFormat)format).getSampleRate() : (format instanceof VideoFormat ? 90000.0 : -1.0);
        byte rtpPayloadType = MediaUtils.getRTPPayloadType(format.getEncoding(), clockRate);
        if (-1 != rtpPayloadType) {
            for (MediaFormat mediaFormat : MediaUtils.getMediaFormats(rtpPayloadType)) {
                MediaFormatImpl mediaFormatImpl = (MediaFormatImpl)mediaFormat;
                if (!format.matches((Format)mediaFormatImpl.getFormat())) continue;
                return mediaFormat;
            }
        }
        return null;
    }

    public static MediaFormat getMediaFormat(String encoding, double clockRate) {
        return MediaUtils.getMediaFormat(encoding, clockRate, null);
    }

    public static MediaFormat getMediaFormat(String encoding, double clockRate, Map<String, String> fmtps) {
        for (MediaFormat format : MediaUtils.getMediaFormats(encoding)) {
            if (format.getClockRate() != clockRate || !format.formatParametersMatch(fmtps)) continue;
            return format;
        }
        return null;
    }

    public static int getMediaFormatIndex(MediaFormat mediaFormat) {
        return rtpPayloadTypelessMediaFormats.indexOf(mediaFormat);
    }

    public static MediaFormat[] getMediaFormats(byte rtpPayloadType) {
        MediaFormat[] mediaFormats = rtpPayloadTypeStrToMediaFormats.get(Byte.toString(rtpPayloadType));
        return mediaFormats == null ? EMPTY_MEDIA_FORMATS : (MediaFormat[])mediaFormats.clone();
    }

    public static MediaFormat[] getMediaFormats(MediaType mediaType) {
        ArrayList<MediaFormat> mediaFormats = new ArrayList<MediaFormat>();
        for (MediaFormat[] formats : rtpPayloadTypeStrToMediaFormats.values()) {
            for (MediaFormat format : formats) {
                if (!format.getMediaType().equals((Object)mediaType)) continue;
                mediaFormats.add(format);
            }
        }
        for (MediaFormat format : rtpPayloadTypelessMediaFormats) {
            if (!format.getMediaType().equals((Object)mediaType)) continue;
            mediaFormats.add(format);
        }
        return mediaFormats.toArray(EMPTY_MEDIA_FORMATS);
    }

    public static List<MediaFormat> getMediaFormats(String encoding) {
        String jmfEncoding = null;
        for (Map.Entry<String, String> jmfEncodingToEncoding : jmfEncodingToEncodings.entrySet()) {
            if (!jmfEncodingToEncoding.getValue().equals(encoding)) continue;
            jmfEncoding = jmfEncodingToEncoding.getKey();
            break;
        }
        ArrayList<MediaFormat> mediaFormats = new ArrayList<MediaFormat>();
        if (jmfEncoding != null) {
            for (MediaFormat[] rtpPayloadTypeMediaFormats : rtpPayloadTypeStrToMediaFormats.values()) {
                for (MediaFormat rtpPayloadTypeMediaFormat : rtpPayloadTypeMediaFormats) {
                    if (!((MediaFormatImpl)rtpPayloadTypeMediaFormat).getJMFEncoding().equals(jmfEncoding)) continue;
                    mediaFormats.add(rtpPayloadTypeMediaFormat);
                }
            }
            if (mediaFormats.size() < 1) {
                for (MediaFormat rtpPayloadTypelessMediaFormat : rtpPayloadTypelessMediaFormats) {
                    if (!((MediaFormatImpl)rtpPayloadTypelessMediaFormat).getJMFEncoding().equals(jmfEncoding)) continue;
                    mediaFormats.add(rtpPayloadTypelessMediaFormat);
                }
            }
        }
        return mediaFormats;
    }

    public static byte getRTPPayloadType(String jmfEncoding, double clockRate) {
        if (jmfEncoding == null) {
            return -1;
        }
        if (jmfEncoding.equals("ULAW/rtp")) {
            return 0;
        }
        if (jmfEncoding.equals("ALAW/rtp")) {
            return 8;
        }
        if (jmfEncoding.equals("gsm/rtp")) {
            return 3;
        }
        if (jmfEncoding.equals("g723/rtp")) {
            return 4;
        }
        if (jmfEncoding.equals("dvi/rtp") && clockRate == 8000.0) {
            return 5;
        }
        if (jmfEncoding.equals("dvi/rtp") && clockRate == 16000.0) {
            return 6;
        }
        if (jmfEncoding.equals("alaw")) {
            return 8;
        }
        if (jmfEncoding.equals("g722")) {
            return 9;
        }
        if (jmfEncoding.equals("g722/rtp")) {
            return 9;
        }
        if (jmfEncoding.equals("gsm")) {
            return 3;
        }
        if (jmfEncoding.equals("gsm/rtp")) {
            return 3;
        }
        if (jmfEncoding.equals("g728/rtp")) {
            return 15;
        }
        if (jmfEncoding.equals("g729/rtp")) {
            return 18;
        }
        if (jmfEncoding.equals("h263/rtp")) {
            return 34;
        }
        if (jmfEncoding.equals("jpeg/rtp")) {
            return 26;
        }
        if (jmfEncoding.equals("h261/rtp")) {
            return 31;
        }
        return -1;
    }

    public static String jmfEncodingToEncoding(String jmfEncoding) {
        return jmfEncodingToEncodings.get(jmfEncoding);
    }

    static {
        boolean opusDtx;
        EMPTY_MEDIA_FORMATS = new MediaFormat[0];
        jmfEncodingToEncodings = new HashMap<String, String>();
        rtpPayloadTypelessMediaFormats = new ArrayList<MediaFormat>();
        rtpPayloadTypeStrToMediaFormats = new HashMap<String, MediaFormat[]>();
        MediaUtils.addMediaFormats((byte)0, "PCMU", MediaType.AUDIO, "ULAW/rtp", 8000.0);
        if (OSUtils.IS_LINUX32 || OSUtils.IS_WINDOWS32) {
            HashMap<String, String> g723FormatParams = new HashMap<String, String>();
            g723FormatParams.put("annexa", "no");
            g723FormatParams.put("bitrate", "6.3");
            MediaUtils.addMediaFormats((byte)4, "G723", MediaType.AUDIO, "g723/rtp", g723FormatParams, null, 8000.0);
        }
        MediaUtils.addMediaFormats((byte)3, "GSM", MediaType.AUDIO, "gsm/rtp", 8000.0);
        MediaUtils.addMediaFormats((byte)8, "PCMA", MediaType.AUDIO, "ALAW/rtp", 8000.0);
        MediaUtils.addMediaFormats((byte)-1, "iLBC", MediaType.AUDIO, "ilbc/rtp", 8000.0);
        MediaUtils.addMediaFormats((byte)-1, "speex", MediaType.AUDIO, "speex/rtp", 8000.0, 16000.0, 32000.0);
        MediaUtils.addMediaFormats((byte)9, "G722", MediaType.AUDIO, "g722/rtp", 8000.0);
        MediaUtils.addMediaFormats((byte)-1, "telephone-event", MediaType.AUDIO, "telephone-event", 8000.0);
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        boolean advertiseFEC = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.silk.ADVERTISE_FEC", false);
        HashMap<String, String> silkFormatParams = new HashMap<String, String>();
        if (advertiseFEC) {
            silkFormatParams.put("useinbandfec", "1");
        }
        MediaUtils.addMediaFormats((byte)-1, "SILK", MediaType.AUDIO, "SILK/rtp", silkFormatParams, null, 8000.0, 12000.0, 16000.0, 24000.0);
        HashMap<String, String> opusFormatParams = new HashMap<String, String>();
        boolean opusFec = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.FEC", true);
        if (!opusFec) {
            opusFormatParams.put("useinbandfec", "0");
        }
        if (opusDtx = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.DTX", true)) {
            opusFormatParams.put("usedtx", "1");
        }
        MediaUtils.addMediaFormats((byte)-1, "opus", MediaType.AUDIO, "opus/rtp", 2, opusFormatParams, null, 48000.0);
        HashMap<String, String> h264FormatParams = new HashMap<String, String>();
        String packetizationMode = "packetization-mode";
        HashMap<String, String> h264AdvancedAttributes = new HashMap<String, String>();
        ScreenDevice screen = ScreenDeviceImpl.getDefaultScreenDevice();
        Dimension res = screen == null ? null : screen.getSize();
        h264AdvancedAttributes.put("imageattr", MediaUtils.createImageAttr(null, res));
        if (cfg == null || cfg.getString("net.java.sip.communicator.impl.neomedia.codec.video.h264.defaultProfile", "main").equals("main")) {
            h264FormatParams.put("profile-level-id", "4DE01f");
        } else {
            h264FormatParams.put("profile-level-id", "42E01f");
        }
        if (cfg == null || cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.video.h264.packetization-mode-1.enabled", true)) {
            h264FormatParams.put(packetizationMode, "1");
            MediaUtils.addMediaFormats((byte)-1, "H264", MediaType.VIDEO, "h264/rtp", h264FormatParams, h264AdvancedAttributes, new double[0]);
        }
        h264FormatParams.remove(packetizationMode);
        MediaUtils.addMediaFormats((byte)-1, "H264", MediaType.VIDEO, "h264/rtp", h264FormatParams, h264AdvancedAttributes, new double[0]);
        HashMap<String, String> h263FormatParams = new HashMap<String, String>();
        LinkedHashMap<String, String> h263AdvancedAttributes = new LinkedHashMap<String, String>();
        if (res != null) {
            h263FormatParams.put("CUSTOM", res.width + "," + res.height + ",2");
        }
        h263FormatParams.put("VGA", "2");
        h263FormatParams.put("CIF", "1");
        h263FormatParams.put("QCIF", "1");
        MediaUtils.addMediaFormats((byte)-1, "H263-1998", MediaType.VIDEO, "h263-1998/rtp", h263FormatParams, h263AdvancedAttributes, new double[0]);
        MediaUtils.addMediaFormats((byte)-1, "VP8", MediaType.VIDEO, "VP8/rtp", null, null, new double[0]);
        ArrayList<MediaFormat> audioMediaFormats = new ArrayList<MediaFormat>(rtpPayloadTypeStrToMediaFormats.size() + rtpPayloadTypelessMediaFormats.size());
        for (MediaFormat[] mediaFormats : rtpPayloadTypeStrToMediaFormats.values()) {
            for (MediaFormat mediaFormat : mediaFormats) {
                if (!MediaType.AUDIO.equals((Object)mediaFormat.getMediaType())) continue;
                audioMediaFormats.add(mediaFormat);
            }
        }
        for (MediaFormat mediaFormat : rtpPayloadTypelessMediaFormats) {
            if (!MediaType.AUDIO.equals((Object)mediaFormat.getMediaType())) continue;
            audioMediaFormats.add(mediaFormat);
        }
        int maxAudioChannels = -1;
        double maxAudioSampleRate = -1.0;
        int maxAudioSampleSizeInBits = -1;
        for (MediaFormat mediaFormat : audioMediaFormats) {
            AudioMediaFormatImpl audioMediaFormat = (AudioMediaFormatImpl)mediaFormat;
            int channels = audioMediaFormat.getChannels();
            if ("opus".equals(audioMediaFormat.getEncoding())) {
                channels = 1;
            }
            double sampleRate = audioMediaFormat.getClockRate();
            int sampleSizeInBits = ((AudioFormat)audioMediaFormat.getFormat()).getSampleSizeInBits();
            if (maxAudioChannels < channels) {
                maxAudioChannels = channels;
            }
            if (maxAudioSampleRate < sampleRate) {
                maxAudioSampleRate = sampleRate;
            }
            if (maxAudioSampleSizeInBits >= sampleSizeInBits) continue;
            maxAudioSampleSizeInBits = sampleSizeInBits;
        }
        MAX_AUDIO_CHANNELS = maxAudioChannels;
        MAX_AUDIO_SAMPLE_RATE = maxAudioSampleRate;
        MAX_AUDIO_SAMPLE_SIZE_IN_BITS = maxAudioSampleSizeInBits;
    }
}

