/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jitsi.service.neomedia.AbstractActiveSpeakerDetector;
import org.jitsi.util.ExecutorUtils;

public class DominantSpeakerIdentification
extends AbstractActiveSpeakerDetector {
    private static final double C1 = 3.0;
    private static final double C2 = 2.0;
    private static final double C3 = 0.0;
    private static final long DECISION_INTERVAL = 300L;
    private static final long LEVEL_IDLE_TIMEOUT = 30L;
    private static final int LONG_COUNT = 1;
    private static final int MAX_LEVEL = 127;
    private static final int MIN_LEVEL = 0;
    private static final int N1 = 13;
    private static final int N1_BASED_MEDIUM_THRESHOLD = 5;
    private static final int N2 = 5;
    private static final int N2_BASED_LONG_THRESHOLD = 4;
    private static final int N3 = 10;
    private static final long SPEAKER_IDLE_TIMEOUT = 720000L;
    private static final ExecutorService threadPool = ExecutorUtils.newCachedThreadPool(true, "DominantSpeakerIdentification");
    private DecisionMaker decisionMaker;
    private Long dominantSSRC;
    private long lastDecisionTime;
    private long lastLevelIdleTime;
    private final double[] relativeSpeechActivities = new double[3];
    private final Map<Long, Speaker> speakers = new HashMap<Long, Speaker>();

    public static long binomialCoefficient(int n, int r) {
        int m = n - r;
        if (r < m) {
            r = m;
        }
        long t = 1L;
        int i = n;
        int j = 1;
        while (i > r) {
            t = t * (long)i / (long)j;
            --i;
            ++j;
        }
        return t;
    }

    private static boolean computeBigs(byte[] littles, byte[] bigs, int threshold) {
        int bigLength = bigs.length;
        int littleLengthPerBig = littles.length / bigLength;
        boolean changed = false;
        int l = 0;
        for (int b = 0; b < bigLength; ++b) {
            byte sum = 0;
            int lEnd = l + littleLengthPerBig;
            while (l < lEnd) {
                if (littles[l] > threshold) {
                    sum = (byte)(sum + 1);
                }
                ++l;
            }
            if (bigs[b] == sum) continue;
            bigs[b] = sum;
            changed = true;
        }
        return changed;
    }

    private static double computeSpeechActivityScore(int vL, int nR, double p, double lambda) {
        double speechActivityScore = Math.log(DominantSpeakerIdentification.binomialCoefficient(nR, vL)) + (double)vL * Math.log(p) + (double)(nR - vL) * Math.log(1.0 - p) - Math.log(lambda) + lambda * (double)vL;
        if (speechActivityScore <= 0.0) {
            speechActivityScore = 1.0E-8;
        }
        return speechActivityScore;
    }

    synchronized void decisionMakerExited(DecisionMaker decisionMaker) {
        if (this.decisionMaker == decisionMaker) {
            this.decisionMaker = null;
        }
    }

    private synchronized Speaker getOrCreateSpeaker(long ssrc) {
        Long key = ssrc;
        Speaker speaker = this.speakers.get(key);
        if (speaker == null) {
            speaker = new Speaker(ssrc);
            this.speakers.put(key, speaker);
            this.maybeStartDecisionMaker();
        }
        return speaker;
    }

    @Override
    public void levelChanged(long ssrc, int level) {
        Speaker speaker = this.getOrCreateSpeaker(ssrc);
        if (speaker != null) {
            speaker.levelChanged(level);
        }
    }

    private synchronized void makeDecision() {
        Long newDominantSSRC;
        int speakerCount = this.speakers.size();
        if (speakerCount == 0) {
            newDominantSSRC = null;
        } else if (speakerCount == 1) {
            newDominantSSRC = this.speakers.keySet().iterator().next();
        } else {
            Speaker dominantSpeaker;
            Speaker speaker = dominantSpeaker = this.dominantSSRC == null ? null : this.speakers.get(this.dominantSSRC);
            if (dominantSpeaker == null) {
                Map.Entry<Long, Speaker> s = this.speakers.entrySet().iterator().next();
                dominantSpeaker = s.getValue();
                newDominantSSRC = s.getKey();
            } else {
                newDominantSSRC = null;
            }
            dominantSpeaker.evaluateSpeechActivityScores();
            double[] relativeSpeechActivities = this.relativeSpeechActivities;
            double newDominantC2 = 2.0;
            for (Map.Entry<Long, Speaker> s : this.speakers.entrySet()) {
                Speaker speaker2 = s.getValue();
                if (speaker2 == dominantSpeaker) continue;
                speaker2.evaluateSpeechActivityScores();
                for (int interval = 0; interval < relativeSpeechActivities.length; ++interval) {
                    relativeSpeechActivities[interval] = Math.log(speaker2.getSpeechActivityScore(interval) / dominantSpeaker.getSpeechActivityScore(interval));
                }
                double c1 = relativeSpeechActivities[0];
                double c2 = relativeSpeechActivities[1];
                double c3 = relativeSpeechActivities[2];
                if (!(c1 > 3.0) || !(c2 > 2.0) || !(c3 > 0.0) || !(c2 > newDominantC2)) continue;
                newDominantC2 = c2;
                newDominantSSRC = s.getKey();
            }
        }
        if (newDominantSSRC != null && newDominantSSRC != this.dominantSSRC) {
            this.dominantSSRC = newDominantSSRC;
            this.fireActiveSpeakerChanged(this.dominantSSRC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void maybeStartDecisionMaker() {
        if (this.decisionMaker == null && !this.speakers.isEmpty()) {
            DecisionMaker decisionMaker = new DecisionMaker(this);
            boolean scheduled = false;
            this.decisionMaker = decisionMaker;
            try {
                threadPool.execute(decisionMaker);
                scheduled = true;
            }
            finally {
                if (!scheduled && this.decisionMaker == decisionMaker) {
                    this.decisionMaker = null;
                }
            }
        }
    }

    private long runInDecisionMaker() {
        long now = System.currentTimeMillis();
        long levelIdleTimeout = 30L - (now - this.lastLevelIdleTime);
        long sleep = 0L;
        if (levelIdleTimeout <= 0L) {
            if (this.lastLevelIdleTime != 0L) {
                this.timeoutIdleLevels(now);
            }
            this.lastLevelIdleTime = now;
        } else {
            sleep = levelIdleTimeout;
        }
        long decisionTimeout = 300L - (now - this.lastDecisionTime);
        if (decisionTimeout <= 0L) {
            this.lastDecisionTime = now;
            this.makeDecision();
            decisionTimeout = 300L - (now - this.lastDecisionTime);
        }
        if (decisionTimeout > 0L && sleep > decisionTimeout) {
            sleep = decisionTimeout;
        }
        return sleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long runInDecisionMaker(DecisionMaker decisionMaker) {
        DominantSpeakerIdentification dominantSpeakerIdentification = this;
        synchronized (dominantSpeakerIdentification) {
            if (this.decisionMaker != decisionMaker) {
                return -1L;
            }
        }
        return this.runInDecisionMaker();
    }

    private synchronized void timeoutIdleLevels(long now) {
        Iterator<Map.Entry<Long, Speaker>> i = this.speakers.entrySet().iterator();
        while (i.hasNext()) {
            Speaker speaker = i.next().getValue();
            long lastLevelChangedTime = speaker.getLastLevelChangedTime();
            if (lastLevelChangedTime + 720000L < now && (this.dominantSSRC == null || speaker.ssrc != this.dominantSSRC)) {
                i.remove();
                continue;
            }
            if (lastLevelChangedTime + 30L >= now) continue;
            speaker.levelTimedOut();
        }
    }

    private static class Speaker {
        private final byte[] immediates = new byte[50];
        private double immediateSpeechActivityScore;
        private long lastLevelChangedTime = System.currentTimeMillis();
        private final byte[] longs = new byte[1];
        private double longSpeechActivityScore;
        private final byte[] mediums = new byte[10];
        private double mediumSpeechActivityScore;
        public final long ssrc;

        public Speaker(long ssrc) {
            this.ssrc = ssrc;
        }

        private void computeImmediates(int level) {
            if (level < 0) {
                level = 0;
            } else if (level > 127) {
                level = 127;
            }
            System.arraycopy(this.immediates, 0, this.immediates, 1, this.immediates.length - 1);
            this.immediates[0] = (byte)(level / 13);
        }

        private void computeImmediateSpeechActivityScore() {
            this.immediateSpeechActivityScore = DominantSpeakerIdentification.computeSpeechActivityScore(this.immediates[0], 13, 0.5, 0.78);
        }

        private boolean computeLongs() {
            return DominantSpeakerIdentification.computeBigs(this.mediums, this.longs, 4);
        }

        private void computeLongSpeechActivityScore() {
            this.longSpeechActivityScore = DominantSpeakerIdentification.computeSpeechActivityScore(this.longs[0], 10, 0.5, 47.0);
        }

        private boolean computeMediums() {
            return DominantSpeakerIdentification.computeBigs(this.immediates, this.mediums, 5);
        }

        private void computeMediumSpeechActivityScore() {
            this.mediumSpeechActivityScore = DominantSpeakerIdentification.computeSpeechActivityScore(this.mediums[0], 5, 0.5, 24.0);
        }

        synchronized void evaluateSpeechActivityScores() {
            this.computeImmediateSpeechActivityScore();
            if (this.computeMediums()) {
                this.computeMediumSpeechActivityScore();
                if (this.computeLongs()) {
                    this.computeLongSpeechActivityScore();
                }
            }
        }

        public synchronized long getLastLevelChangedTime() {
            return this.lastLevelChangedTime;
        }

        double getSpeechActivityScore(int index) {
            switch (index) {
                case 0: {
                    return this.immediateSpeechActivityScore;
                }
                case 1: {
                    return this.mediumSpeechActivityScore;
                }
                case 2: {
                    return this.longSpeechActivityScore;
                }
            }
            throw new IllegalArgumentException("index " + index);
        }

        public void levelChanged(int level) {
            this.levelChanged(level, System.currentTimeMillis());
        }

        private synchronized void levelChanged(int level, long time) {
            this.lastLevelChangedTime = time;
            this.computeImmediates(level);
        }

        public synchronized void levelTimedOut() {
            this.levelChanged(0, this.lastLevelChangedTime);
        }
    }

    private static class DecisionMaker
    implements Runnable {
        private final WeakReference<DominantSpeakerIdentification> algorithm;

        public DecisionMaker(DominantSpeakerIdentification algorithm) {
            this.algorithm = new WeakReference<DominantSpeakerIdentification>(algorithm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                DominantSpeakerIdentification algorithm;
                block5: while (true) {
                    while (true) {
                        if ((algorithm = (DominantSpeakerIdentification)this.algorithm.get()) == null) {
                            break block10;
                        }
                        long sleep = algorithm.runInDecisionMaker(this);
                        if (sleep < 0L) {
                            break block10;
                        }
                        if (sleep <= 0L) continue;
                        algorithm = null;
                        try {
                            Thread.sleep(sleep);
                            continue block5;
                        }
                        catch (InterruptedException ie) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    algorithm = (DominantSpeakerIdentification)this.algorithm.get();
                    if (algorithm != null) {
                        algorithm.decisionMakerExited(this);
                    }
                }
            }
        }
    }
}

