/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.impl.DescribeInstances;
import com.hazelcast.config.AwsConfig;
import java.util.List;

public class AWSClient {
    private String endpoint;
    private final AwsConfig awsConfig;

    public AWSClient(AwsConfig awsConfig) {
        if (awsConfig == null) {
            throw new IllegalArgumentException("AwsConfig is required!");
        }
        if (awsConfig.getAccessKey() == null) {
            throw new IllegalArgumentException("AWS access key is required!");
        }
        if (awsConfig.getSecretKey() == null) {
            throw new IllegalArgumentException("AWS secret key is required!");
        }
        this.awsConfig = awsConfig;
        this.endpoint = awsConfig.getHostHeader();
    }

    public List<String> getPrivateIpAddresses() throws Exception {
        return (List)new DescribeInstances(this.awsConfig).execute(this.endpoint);
    }

    public void setEndpoint(String s) {
        this.endpoint = s;
    }
}

