/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.impl.SpiPortableHook;
import java.io.IOException;

public class PortableEntryEvent
implements Portable {
    private Data key;
    private Data value;
    private Data oldValue;
    private EntryEventType eventType;
    private String uuid;

    public PortableEntryEvent() {
    }

    public PortableEntryEvent(Data key, Data value, Data oldValue, EntryEventType eventType, String uuid) {
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.eventType = eventType;
        this.uuid = uuid;
    }

    public Data getKey() {
        return this.key;
    }

    public Data getValue() {
        return this.value;
    }

    public Data getOldValue() {
        return this.oldValue;
    }

    public EntryEventType getEventType() {
        return this.eventType;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public int getFactoryId() {
        return SpiPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("e", this.eventType.getType());
        writer.writeUTF("u", this.uuid);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        IOUtil.writeNullableData(out, this.value);
        IOUtil.writeNullableData(out, this.oldValue);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.eventType = EntryEventType.getByType(reader.readInt("e"));
        this.uuid = reader.readUTF("u");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.value = IOUtil.readNullableData(in);
        this.oldValue = IOUtil.readNullableData(in);
    }
}

