/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MemcacheEntry
implements DataSerializable,
TextCommandConstants {
    byte[] bytes;
    int flag;

    public MemcacheEntry(String key, byte[] value, int flag) {
        byte[] flagBytes = new String(" " + flag + " ").getBytes();
        byte[] valueLen = String.valueOf(value.length).getBytes();
        byte[] keyBytes = key.getBytes();
        int size = VALUE_SPACE.length + keyBytes.length + flagBytes.length + valueLen.length + RETURN.length + value.length + RETURN.length;
        ByteBuffer entryBuffer = ByteBuffer.allocate(size);
        entryBuffer.put(VALUE_SPACE);
        entryBuffer.put(keyBytes);
        entryBuffer.put(flagBytes);
        entryBuffer.put(valueLen);
        entryBuffer.put(RETURN);
        entryBuffer.put(value);
        entryBuffer.put(RETURN);
        this.bytes = entryBuffer.array();
        this.flag = flag;
    }

    public MemcacheEntry() {
    }

    public void readData(DataInput in) throws IOException {
        int size = in.readInt();
        this.bytes = new byte[size];
        in.readFully(this.bytes);
        this.flag = in.readInt();
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.bytes.length);
        out.write(this.bytes);
        out.writeInt(this.flag);
    }

    public ByteBuffer toNewBuffer() {
        return ByteBuffer.wrap(this.bytes);
    }

    public int getFlag() {
        return this.flag;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return "MemcacheEntry{bytes=" + new String(this.bytes) + ", flag=" + this.flag + '}';
    }
}

