/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.LinkedList;
import net.kano.joscar.flap.AbstractFlapProcessor;
import net.kano.joscar.flap.FlapPacket;

public class AsynchronousFlapProcessor
extends AbstractFlapProcessor {
    private final Object lock = new Object();
    private final LinkedList<FlapPacket> list = new LinkedList();
    private final Thread thread = new Thread((Runnable)new BackgroundPacketProcessor(this), "FLAP processor");
    private static final FlapPacket[] EMPTY_FLAP_ARRAY = new FlapPacket[0];

    public AsynchronousFlapProcessor() {
        this.thread.start();
    }

    public AsynchronousFlapProcessor(Socket socket) throws IOException {
        super(socket);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePacket(FlapPacket packet) {
        Object object = this.lock;
        synchronized (object) {
            this.list.add(packet);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlapPacket[] waitForPackets(long wait) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.list.isEmpty()) {
                return this.clearPackets();
            }
            this.lock.wait(wait);
            if (!this.list.isEmpty()) {
                return this.clearPackets();
            }
        }
        return EMPTY_FLAP_ARRAY;
    }

    private FlapPacket[] clearPackets() {
        assert (Thread.holdsLock(this.lock));
        FlapPacket[] packets = this.list.toArray(EMPTY_FLAP_ARRAY);
        this.list.clear();
        return packets;
    }

    private static class BackgroundPacketProcessor
    implements Runnable {
        private final WeakReference<AsynchronousFlapProcessor> processorReference;

        public BackgroundPacketProcessor(AsynchronousFlapProcessor processor) {
            this.processorReference = new WeakReference<AsynchronousFlapProcessor>(processor);
        }

        public void run() {
            while (this.tryProcessingPackets()) {
            }
        }

        private boolean tryProcessingPackets() {
            AsynchronousFlapProcessor processor = (AsynchronousFlapProcessor)this.processorReference.get();
            if (processor == null) {
                return false;
            }
            try {
                for (FlapPacket packet : processor.waitForPackets(100L)) {
                    processor.processPacketSynchronously(packet);
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }
    }
}

