/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import net.sf.cindy.Message;
import net.sf.cindy.impl.ChannelSession;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.spi.EventGeneratorSpi;
import net.sf.cindy.spi.SessionStatisticSpi;
import net.sf.cindy.util.ByteBufferUtils;

public abstract class StreamChannelSession
extends ChannelSession {
    protected void readFromChannel(SelectableChannel selectableChannel) throws IOException {
        if (!this.readBuffer.hasRemaining()) {
            this.readBuffer = ByteBufferUtils.increaseCapacity(this.readBuffer, Constants.BUFFER_CAPACITY);
        }
        int n = -1;
        int n2 = 0;
        while ((n = ((ReadableByteChannel)((Object)selectableChannel)).read(this.readBuffer)) > 0) {
            n2 += n;
        }
        if (n2 > 0) {
            if (this.getStatistic() != null) {
                ((SessionStatisticSpi)this.getStatistic()).received(n2);
            }
            this.readBuffer.flip();
            this.recognizeMessageAndDispatch(this.readBuffer);
            this.readBuffer.compact();
            if (this.readBuffer.position() >= this.getBufferCapacityLimit()) {
                this.dispatchException(new RuntimeException("ReadBuffer reaches it's max capacity. To prevent attack, session will be closed."));
                this.close(false);
                return;
            }
        }
        if (n < 0) {
            selectableChannel.close();
            this.close();
        } else {
            ((EventGeneratorSpi)this.getEventGenerator()).register(this, Constants.EV_ENABLE_READ);
        }
    }

    protected void recognizeMessageAndDispatch(ByteBuffer byteBuffer) {
        Message message;
        while (byteBuffer.hasRemaining() && (message = this.recognizeMessage(byteBuffer)) != null) {
            this.dispatchMessageReceived(message);
        }
    }

    protected final Object transMessage(Message message) {
        return new WriteMessage(message);
    }

    protected ByteBuffer[] messageToByteBuffer(Message message) {
        return message.toByteBuffer();
    }

    protected Message writeToChannel(SelectableChannel selectableChannel, Object object) throws IOException {
        long l;
        ByteBuffer[] byteBufferArray;
        WriteMessage writeMessage = (WriteMessage)object;
        if (writeMessage.buffer == null) {
            WriteMessage.access$102(writeMessage, this.messageToByteBuffer(writeMessage.message));
        }
        if ((byteBufferArray = writeMessage.buffer) == null || byteBufferArray.length == 0) {
            return writeMessage.message;
        }
        do {
            l = this.doRealWrite(selectableChannel, byteBufferArray);
            if (this.getStatistic() != null) {
                ((SessionStatisticSpi)this.getStatistic()).sent(l);
            }
            if (ByteBufferUtils.hasRemaining(byteBufferArray)) continue;
            return writeMessage.message;
        } while (l != 0L);
        return null;
    }

    private long doRealWrite(SelectableChannel selectableChannel, ByteBuffer[] byteBufferArray) throws IOException {
        if (Constants.SUPPORT_WRITE_BUFFER_ARRAY) {
            return ((GatheringByteChannel)((Object)selectableChannel)).write(byteBufferArray);
        }
        long l = 0L;
        for (int i = 0; i < byteBufferArray.length; ++i) {
            if (byteBufferArray[i] == null) continue;
            while (byteBufferArray[i].hasRemaining()) {
                int n = ((WritableByteChannel)((Object)selectableChannel)).write(byteBufferArray[i]);
                if (n == 0) {
                    return l;
                }
                l += (long)n;
            }
        }
        return l;
    }

    private static class WriteMessage {
        private Message message;
        private ByteBuffer[] buffer;

        private WriteMessage(Message message) {
            this.message = message;
        }

        public ByteBuffer[] getBuffer() {
            return this.buffer;
        }

        public Message getMessage() {
            return this.message;
        }

        static /* synthetic */ ByteBuffer[] access$102(WriteMessage writeMessage, ByteBuffer[] byteBufferArray) {
            writeMessage.buffer = byteBufferArray;
            return byteBufferArray;
        }
    }
}

