/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class EscapedFunctions {
    public static final String ABS = "abs";
    public static final String ACOS = "acos";
    public static final String ASIN = "asin";
    public static final String ATAN = "atan";
    public static final String ATAN2 = "atan2";
    public static final String CEILING = "ceiling";
    public static final String COS = "cos";
    public static final String COT = "cot";
    public static final String DEGREES = "degrees";
    public static final String EXP = "exp";
    public static final String FLOOR = "floor";
    public static final String LOG = "log";
    public static final String LOG10 = "log10";
    public static final String MOD = "mod";
    public static final String PI = "pi";
    public static final String POWER = "power";
    public static final String RADIANS = "radians";
    public static final String RAND = "rand";
    public static final String ROUND = "round";
    public static final String SIGN = "sign";
    public static final String SIN = "sin";
    public static final String SQRT = "sqrt";
    public static final String TAN = "tan";
    public static final String TRUNCATE = "truncate";
    public static final String ASCII = "ascii";
    public static final String CHAR = "char";
    public static final String CONCAT = "concat";
    public static final String INSERT = "insert";
    public static final String LCASE = "lcase";
    public static final String LEFT = "left";
    public static final String LENGTH = "length";
    public static final String LOCATE = "locate";
    public static final String LTRIM = "ltrim";
    public static final String REPEAT = "repeat";
    public static final String REPLACE = "replace";
    public static final String RIGHT = "right";
    public static final String RTRIM = "rtrim";
    public static final String SPACE = "space";
    public static final String SUBSTRING = "substring";
    public static final String UCASE = "ucase";
    public static final String CURDATE = "curdate";
    public static final String CURTIME = "curtime";
    public static final String DAYNAME = "dayname";
    public static final String DAYOFMONTH = "dayofmonth";
    public static final String DAYOFWEEK = "dayofweek";
    public static final String DAYOFYEAR = "dayofyear";
    public static final String HOUR = "hour";
    public static final String MINUTE = "minute";
    public static final String MONTH = "month";
    public static final String MONTHNAME = "monthname";
    public static final String NOW = "now";
    public static final String QUARTER = "quarter";
    public static final String SECOND = "second";
    public static final String WEEK = "week";
    public static final String YEAR = "year";
    public static final String DATABASE = "database";
    public static final String IFNULL = "ifnull";
    public static final String USER = "user";
    private static Map functionMap = null;
    static /* synthetic */ Class class$org$postgresql$jdbc2$EscapedFunctions;

    public static Method getFunction(String functionName) {
        if (functionMap == null) {
            Method[] arrayMeths = (class$org$postgresql$jdbc2$EscapedFunctions == null ? (class$org$postgresql$jdbc2$EscapedFunctions = EscapedFunctions.class$("org.postgresql.jdbc2.EscapedFunctions")) : class$org$postgresql$jdbc2$EscapedFunctions).getDeclaredMethods();
            functionMap = new HashMap(arrayMeths.length * 2);
            int i = 0;
            while (i < arrayMeths.length) {
                Method meth = arrayMeths[i];
                if (meth.getName().startsWith("sql")) {
                    functionMap.put(meth.getName().toLowerCase(), meth);
                }
                ++i;
            }
        }
        return (Method)functionMap.get("sql" + functionName.toLowerCase());
    }

    public static String sqlceiling(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("ceil(");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", CEILING), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqllog(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("ln(");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LOG), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqllog10(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("log(");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LOG10), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlpower(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("pow(");
        if (parsedArgs.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", POWER), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0)).append(',').append(parsedArgs.get(1));
        return buf.append(')').toString();
    }

    public static String sqlrand(List parsedArgs) throws SQLException {
        if (parsedArgs.size() == 0) {
            return "random()";
        }
        if (parsedArgs.size() == 1) {
            return "(setseed(" + parsedArgs.get(0) + ")*0+random())";
        }
        throw new PSQLException(GT.tr("rand function only takes zero or one argument(the seed)."), PSQLState.SYNTAX_ERROR);
    }

    public static String sqltruncate(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("trunc(");
        if (parsedArgs.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", TRUNCATE), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0)).append(',').append(parsedArgs.get(1));
        return buf.append(')').toString();
    }

    public static String sqlchar(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("chr(");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", CHAR), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlconcat(List parsedArgs) {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        int iArg = 0;
        while (iArg < parsedArgs.size()) {
            buf.append(parsedArgs.get(iArg));
            if (iArg != parsedArgs.size() - 1) {
                buf.append(" || ");
            }
            ++iArg;
        }
        return buf.append(')').toString();
    }

    public static String sqlinsert(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("overlay(");
        if (parsedArgs.size() != 4) {
            throw new PSQLException(GT.tr("{0} function takes four and only four argument.", INSERT), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0)).append(" placing ").append(parsedArgs.get(3));
        buf.append(" from ").append(parsedArgs.get(1)).append(" for ").append(parsedArgs.get(2));
        return buf.append(')').toString();
    }

    public static String sqllcase(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("lower(");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LCASE), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlleft(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("substring(");
        if (parsedArgs.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", LEFT), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0)).append(" for ").append(parsedArgs.get(1));
        return buf.append(')').toString();
    }

    public static String sqllength(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("length(trim(trailing from ");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LENGTH), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append("))").toString();
    }

    public static String sqllocate(List parsedArgs) throws SQLException {
        if (parsedArgs.size() == 2) {
            return "position(" + parsedArgs.get(0) + " in " + parsedArgs.get(1) + ")";
        }
        if (parsedArgs.size() == 3) {
            String tmp = "position(" + parsedArgs.get(0) + " in substring(" + parsedArgs.get(1) + " from " + parsedArgs.get(2) + "))";
            return "(" + parsedArgs.get(2) + "*sign(" + tmp + ")+" + tmp + ")";
        }
        throw new PSQLException(GT.tr("{0} function takes two or three arguments.", LOCATE), PSQLState.SYNTAX_ERROR);
    }

    public static String sqlltrim(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("trim(leading from ");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LTRIM), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlright(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("substring(");
        if (parsedArgs.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", RIGHT), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0)).append(" from (length(").append(parsedArgs.get(0)).append(")+1-").append(parsedArgs.get(1));
        return buf.append("))").toString();
    }

    public static String sqlrtrim(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("trim(trailing from ");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", RTRIM), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlspace(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("repeat(' ',");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", SPACE), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlsubstring(List parsedArgs) throws SQLException {
        if (parsedArgs.size() == 2) {
            return "substr(" + parsedArgs.get(0) + "," + parsedArgs.get(1) + ")";
        }
        if (parsedArgs.size() == 3) {
            return "substr(" + parsedArgs.get(0) + "," + parsedArgs.get(1) + "," + parsedArgs.get(2) + ")";
        }
        throw new PSQLException(GT.tr("{0} function takes two or three arguments.", SUBSTRING), PSQLState.SYNTAX_ERROR);
    }

    public static String sqlucase(List parsedArgs) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("upper(");
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", UCASE), PSQLState.SYNTAX_ERROR);
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlcurdate(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 0) {
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", CURDATE), PSQLState.SYNTAX_ERROR);
        }
        return "current_date";
    }

    public static String sqlcurtime(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 0) {
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", CURTIME), PSQLState.SYNTAX_ERROR);
        }
        return "current_time";
    }

    public static String sqldayname(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYNAME), PSQLState.SYNTAX_ERROR);
        }
        return "to_char(" + parsedArgs.get(0) + ",'Day')";
    }

    public static String sqldayofmonth(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYOFMONTH), PSQLState.SYNTAX_ERROR);
        }
        return "extract(day from " + parsedArgs.get(0) + ")";
    }

    public static String sqldayofweek(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYOFWEEK), PSQLState.SYNTAX_ERROR);
        }
        return "extract(dow from " + parsedArgs.get(0) + ")+1";
    }

    public static String sqldayofyear(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYOFYEAR), PSQLState.SYNTAX_ERROR);
        }
        return "extract(doy from " + parsedArgs.get(0) + ")";
    }

    public static String sqlhour(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", HOUR), PSQLState.SYNTAX_ERROR);
        }
        return "extract(hour from " + parsedArgs.get(0) + ")";
    }

    public static String sqlminute(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", MINUTE), PSQLState.SYNTAX_ERROR);
        }
        return "extract(minute from " + parsedArgs.get(0) + ")";
    }

    public static String sqlmonth(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", MONTH), PSQLState.SYNTAX_ERROR);
        }
        return "extract(month from " + parsedArgs.get(0) + ")";
    }

    public static String sqlmonthname(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", MONTHNAME), PSQLState.SYNTAX_ERROR);
        }
        return "to_char(" + parsedArgs.get(0) + ",'Month')";
    }

    public static String sqlquarter(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", QUARTER), PSQLState.SYNTAX_ERROR);
        }
        return "extract(quarter from " + parsedArgs.get(0) + ")";
    }

    public static String sqlsecond(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", SECOND), PSQLState.SYNTAX_ERROR);
        }
        return "extract(second from " + parsedArgs.get(0) + ")";
    }

    public static String sqlweek(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", WEEK), PSQLState.SYNTAX_ERROR);
        }
        return "extract(week from " + parsedArgs.get(0) + ")";
    }

    public static String sqlyear(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", YEAR), PSQLState.SYNTAX_ERROR);
        }
        return "extract(year from " + parsedArgs.get(0) + ")";
    }

    public static String sqldatabase(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 0) {
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", DATABASE), PSQLState.SYNTAX_ERROR);
        }
        return "current_database()";
    }

    public static String sqlifnull(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", IFNULL), PSQLState.SYNTAX_ERROR);
        }
        return "coalesce(" + parsedArgs.get(0) + "," + parsedArgs.get(1) + ")";
    }

    public static String sqluser(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 0) {
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", USER), PSQLState.SYNTAX_ERROR);
        }
        return USER;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

