/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.screens.BaseChecklistScreen;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.Iterator;
import javax.swing.JSeparator;

public abstract class ServiceScreen
extends BaseChecklistScreen {
    private boolean screenEnabled = true;

    public ServiceScreen(InstallerWizard installerWizard) {
        super(installerWizard);
        this.initScreen();
    }

    public void activate() {
        super.activate();
        this.screenEnabled = false;
        SingleServicePanel singleServicePanel = null;
        Iterator iterator = this.singleCheckPanels.iterator();
        while (iterator.hasNext()) {
            SingleServicePanel singleServicePanel2 = (SingleServicePanel)iterator.next();
            boolean bl = ComponentConfig.isIncludedInSelectedComponents(singleServicePanel2.getServiceConfig().getFile());
            singleServicePanel2.setVisible(bl);
            singleServicePanel2.setSeparatorVisible(bl);
            if (bl) {
                singleServicePanel = singleServicePanel2;
            }
            this.screenEnabled = this.screenEnabled || bl;
        }
        if (singleServicePanel != null && this.singleCheckPanels.indexOf(singleServicePanel) != this.singleCheckPanels.size() - 1) {
            singleServicePanel.setSeparatorVisible(false);
        }
        if (!this.screenEnabled) {
            this.getInstallerWizard().nextScreen();
        }
    }

    protected boolean supportsPrevious() {
        return this.screenEnabled;
    }

    protected void addSingleChecks(GridBagConstraints gridBagConstraints) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        Iterator iterator = installerConfig.getServices().iterator();
        while (iterator.hasNext()) {
            ServiceConfig serviceConfig = (ServiceConfig)iterator.next();
            if (!serviceConfig.isAllowUserChangeStartupType() && !installerConfig.getType().equals("unix")) continue;
            SingleServicePanel singleServicePanel = this.createSingleServicePanel(serviceConfig);
            this.checklistPanel.add((Component)singleServicePanel, gridBagConstraints);
            this.singleCheckPanels.add(singleServicePanel);
            ++gridBagConstraints.gridy;
            if (!iterator.hasNext()) continue;
            gridBagConstraints.insets.left += CHECKBOX_WIDTH;
            gridBagConstraints.insets.right += CHECKBOX_WIDTH;
            JSeparator jSeparator = new JSeparator(0);
            this.checklistPanel.add((Component)jSeparator, gridBagConstraints);
            singleServicePanel.setSeparator(jSeparator);
            gridBagConstraints.insets.left -= CHECKBOX_WIDTH;
            gridBagConstraints.insets.right -= CHECKBOX_WIDTH;
            ++gridBagConstraints.gridy;
        }
    }

    protected SingleServicePanel createSingleServicePanel(ServiceConfig serviceConfig) {
        return null;
    }

    protected class SingleServicePanel
    extends BaseChecklistScreen.SingleCheckPanel {
        private ServiceConfig serviceConfig;
        private JSeparator separator;

        protected SingleServicePanel(ServiceConfig serviceConfig) {
            this.serviceConfig = serviceConfig;
        }

        public ServiceConfig getServiceConfig() {
            return this.serviceConfig;
        }

        public void setSeparator(JSeparator jSeparator) {
            this.separator = jSeparator;
        }

        public void setSeparatorVisible(boolean bl) {
            if (this.separator != null) {
                this.separator.setVisible(bl);
            }
        }
    }
}

