/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.CustomTaskConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.WindowsSpecificConfig;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.screens.BaseChecklistScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class AdditionalTasksScreen
extends BaseChecklistScreen {
    private JCheckBox chkCreateDesktopIcon;
    private JCheckBox chkCreateQuickLaunchIcon;
    private boolean tasks;

    public AdditionalTasksScreen(InstallerWizard installerWizard) {
        super(installerWizard);
        this.initScreen();
    }

    public boolean hasTasks() {
        return this.tasks;
    }

    protected void addSingleChecks(GridBagConstraints gridBagConstraints) {
        boolean bl;
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        WindowsSpecificConfig windowsSpecificConfig = installerConfig.getWindowsSpecificConfig();
        boolean bl2 = installerConfig.isCustomTasksPlaceBefore();
        boolean bl3 = false;
        boolean bl4 = bl = InstallerUtil.isWindows() || InstallerUtil.isMacOS();
        if (bl) {
            boolean bl5 = bl3 = bl3 || installerConfig.isDesktopIconIncluded();
        }
        if (InstallerUtil.isWindows()) {
            bl3 = bl3 || windowsSpecificConfig.isQuicklaunchIconIncluded();
        }
        boolean bl6 = this.tasks = bl3 || installerConfig.getCustomTasks().size() > 0;
        if (bl2) {
            this.addCustomTasks(gridBagConstraints);
            if (bl3) {
                this.addSpacer(gridBagConstraints);
            }
        }
        if (bl && bl3) {
            this.checklistPanel.add((Component)new JLabel(this.messages.getString("CreateIconsGroup")), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.bottom = 0;
            if (installerConfig.isDesktopIconIncluded()) {
                this.checklistPanel.add((Component)this.chkCreateDesktopIcon, gridBagConstraints);
                this.chkCreateDesktopIcon.setSelected(installerConfig.isDesktopIconSelected());
                ++gridBagConstraints.gridy;
            }
            if (InstallerUtil.isWindows() && windowsSpecificConfig.isQuicklaunchIconIncluded()) {
                this.checklistPanel.add((Component)this.chkCreateQuickLaunchIcon, gridBagConstraints);
                this.chkCreateQuickLaunchIcon.setSelected(windowsSpecificConfig.isQuicklaunchIconSelected());
                ++gridBagConstraints.gridy;
            }
        }
        if (!bl2) {
            if (bl3) {
                this.addSpacer(gridBagConstraints);
            }
            this.addCustomTasks(gridBagConstraints);
        }
    }

    private void addCustomTasks(GridBagConstraints gridBagConstraints) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        Iterator iterator = installerConfig.getCustomTasks().iterator();
        gridBagConstraints.insets.bottom = 0;
        boolean bl = true;
        while (iterator.hasNext()) {
            CustomTaskConfig customTaskConfig = (CustomTaskConfig)iterator.next();
            if (!bl && customTaskConfig.isSpacer()) {
                this.addSpacer(gridBagConstraints);
            }
            bl = false;
            CustomTaskCheckPanel customTaskCheckPanel = new CustomTaskCheckPanel(customTaskConfig);
            this.checklistPanel.add((Component)customTaskCheckPanel, gridBagConstraints);
            this.singleCheckPanels.add(customTaskCheckPanel);
            ++gridBagConstraints.gridy;
        }
    }

    public boolean isCreateDesktopIcon() {
        return (InstallerUtil.isWindows() || InstallerUtil.isMacOS()) && InstallerConfig.getCurrentInstance().isDesktopIconIncluded() && this.chkCreateDesktopIcon.isSelected();
    }

    public boolean isCreateQuickLaunchIcon() {
        return InstallerUtil.isWindows() && InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().isQuicklaunchIconIncluded() && this.chkCreateQuickLaunchIcon.isSelected();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(MessageFormat.format(this.messages.getString("SelectTasksLabel2"), this.getApplicationName()), jPanel, gridBagConstraints);
        super.addScreenContent(jPanel, gridBagConstraints);
    }

    private void addSpacer(GridBagConstraints gridBagConstraints) {
        if (InstallerConfig.getCurrentInstance().getCustomTasks().size() > 0) {
            gridBagConstraints.insets.left += CHECKBOX_WIDTH;
            gridBagConstraints.insets.right += CHECKBOX_WIDTH;
            gridBagConstraints.insets.top += 3;
            gridBagConstraints.insets.bottom += 3;
            JSeparator jSeparator = new JSeparator(0);
            this.checklistPanel.add((Component)jSeparator, gridBagConstraints);
            gridBagConstraints.insets.left -= CHECKBOX_WIDTH;
            gridBagConstraints.insets.right -= CHECKBOX_WIDTH;
            gridBagConstraints.insets.top -= 3;
            gridBagConstraints.insets.bottom -= 3;
            ++gridBagConstraints.gridy;
        }
    }

    protected String getTitle() {
        return this.messages.getString("WizardSelectTasks");
    }

    protected String getSubTitle() {
        return this.messages.getString("SelectTasksDesc");
    }

    protected void setupControls() {
        super.setupControls();
        this.chkCreateDesktopIcon = new JCheckBox(this.messages.getString("CreateDesktopIcon"));
        this.chkCreateQuickLaunchIcon = new JCheckBox(this.messages.getString("CreateQuickLaunchIcon"));
    }

    private class CustomTaskCheckPanel
    extends BaseChecklistScreen.SingleCheckPanel {
        private CustomTaskConfig customTaskConfig;
        private JCheckBox chkTask;

        public CustomTaskCheckPanel(CustomTaskConfig customTaskConfig) {
            super(AdditionalTasksScreen.this);
            this.customTaskConfig = customTaskConfig;
            this.setLayout(new BorderLayout());
            this.chkTask = new JCheckBox(customTaskConfig.getDescription(), customTaskConfig.isSelected());
            this.add((Component)this.chkTask, "West");
        }

        public void save() {
            this.customTaskConfig.setSelected(this.chkTask.isSelected());
        }

        public void update() {
            this.chkTask.setSelected(this.customTaskConfig.isSelected());
        }
    }
}

