/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.log.LogFactory;
import org.mortbay.util.B64Code;
import org.mortbay.util.Credential;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class DigestAuthenticator
implements Authenticator {
    static Log log = LogFactory.getLog(class$org$mortbay$http$DigestAuthenticator == null ? (class$org$mortbay$http$DigestAuthenticator = DigestAuthenticator.class$("org.mortbay.http.DigestAuthenticator")) : class$org$mortbay$http$DigestAuthenticator);
    protected long maxNonceAge = 0L;
    protected long nonceSecret = (long)this.hashCode() ^ System.currentTimeMillis();
    protected boolean useStale = false;
    static /* synthetic */ Class class$org$mortbay$http$DigestAuthenticator;

    public Principal authenticate(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        boolean stale = false;
        Principal user = null;
        String credentials = request.getField("Authorization");
        if (credentials != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Credentials: " + credentials));
            }
            QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(credentials, "=, ", true, false);
            Digest digest = new Digest(request.getMethod());
            String last = null;
            String name = null;
            block5: while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                switch (c) {
                    case '=': {
                        name = last;
                        last = tok;
                        continue block5;
                    }
                    case ',': {
                        name = null;
                    }
                    case ' ': {
                        continue block5;
                    }
                }
                last = tok;
                if (name == null) continue;
                if ("username".equalsIgnoreCase(name)) {
                    digest.username = tok;
                    continue;
                }
                if ("realm".equalsIgnoreCase(name)) {
                    digest.realm = tok;
                    continue;
                }
                if ("nonce".equalsIgnoreCase(name)) {
                    digest.nonce = tok;
                    continue;
                }
                if ("nc".equalsIgnoreCase(name)) {
                    digest.nc = tok;
                    continue;
                }
                if ("cnonce".equalsIgnoreCase(name)) {
                    digest.cnonce = tok;
                    continue;
                }
                if ("qop".equalsIgnoreCase(name)) {
                    digest.qop = tok;
                    continue;
                }
                if ("uri".equalsIgnoreCase(name)) {
                    digest.uri = tok;
                    continue;
                }
                if (!"response".equalsIgnoreCase(name)) continue;
                digest.response = tok;
            }
            int n = this.checkNonce(digest.nonce, request);
            if (n > 0) {
                user = realm.authenticate(digest.username, digest, request);
            } else if (n == 0) {
                stale = true;
            }
            if (user == null) {
                log.warn((Object)("AUTH FAILURE: user " + digest.username));
            } else {
                request.setAuthType("DIGEST");
                request.setAuthUser(digest.username);
                request.setUserPrincipal(user);
            }
        }
        if (user == null && response != null) {
            this.sendChallenge(realm, request, response, stale);
        }
        return user;
    }

    public String getAuthMethod() {
        return "DIGEST";
    }

    public void sendChallenge(UserRealm realm, HttpRequest request, HttpResponse response, boolean stale) throws IOException {
        response.setField("WWW-Authenticate", "Digest realm=\"" + realm.getName() + "\", domain=\"" + response.getHttpContext().getContextPath() + "\", nonce=\"" + this.newNonce(request) + "\", algorithm=MD5, qop=\"auth\"" + (this.useStale ? " stale=" + stale : ""));
        response.sendError(401);
    }

    public String newNonce(HttpRequest request) {
        long ts = request.getTimeStamp();
        long sk = this.nonceSecret;
        byte[] nounce = new byte[24];
        for (int i = 0; i < 8; ++i) {
            nounce[i] = (byte)(ts & 0xFFL);
            ts >>= 8;
            nounce[8 + i] = (byte)(sk & 0xFFL);
            sk >>= 8;
        }
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(nounce, 0, 16);
            hash = md.digest();
        }
        catch (Exception e) {
            log.fatal((Object)this, (Throwable)e);
        }
        for (int i = 0; i < hash.length; ++i) {
            nounce[8 + i] = hash[i];
            if (i == 23) break;
        }
        return new String(B64Code.encode(nounce));
    }

    public int checkNonce(String nonce, HttpRequest request) {
        try {
            byte[] n = B64Code.decode(nonce.toCharArray());
            if (n.length != 24) {
                return -1;
            }
            long ts = 0L;
            long sk = this.nonceSecret;
            byte[] n2 = new byte[16];
            for (int i = 0; i < 8; ++i) {
                n2[i] = n[i];
                n2[8 + i] = (byte)(sk & 0xFFL);
                sk >>= 8;
                ts = (ts << 8) + (0xFFL & (long)n[7 - i]);
            }
            long age = request.getTimeStamp() - ts;
            if (log.isDebugEnabled()) {
                log.debug((Object)("age=" + age));
            }
            byte[] hash = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                md.update(n2, 0, 16);
                hash = md.digest();
            }
            catch (Exception e) {
                log.fatal((Object)this, (Throwable)e);
            }
            for (int i = 0; i < 16; ++i) {
                if (n[i + 8] == hash[i]) continue;
                return -1;
            }
            if (this.maxNonceAge > 0L && (age < 0L || age > this.maxNonceAge)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            log.debug((Object)"", (Throwable)e);
            return -1;
        }
    }

    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }

    public void setMaxNonceAge(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
    }

    public long getNonceSecret() {
        return this.nonceSecret;
    }

    public void setNonceSecret(long nonceSecret) {
        this.nonceSecret = nonceSecret;
    }

    public void setUseStale(boolean us) {
        this.useStale = us;
    }

    public boolean getUseStale() {
        return this.useStale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Digest
    extends Credential {
        String method = null;
        String username = null;
        String realm = null;
        String nonce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;

        Digest(String m) {
            this.method = m;
        }

        public boolean check(Object credentials) {
            String password = credentials instanceof String ? (String)credentials : credentials.toString();
            try {
                byte[] ha1;
                MessageDigest md = MessageDigest.getInstance("MD5");
                if (credentials instanceof Credential.MD5) {
                    ha1 = ((Credential.MD5)credentials).getDigest();
                } else {
                    md.update(this.username.getBytes(StringUtil.__ISO_8859_1));
                    md.update((byte)58);
                    md.update(this.realm.getBytes(StringUtil.__ISO_8859_1));
                    md.update((byte)58);
                    md.update(password.getBytes(StringUtil.__ISO_8859_1));
                    ha1 = md.digest();
                }
                md.reset();
                md.update(this.method.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.uri.getBytes(StringUtil.__ISO_8859_1));
                byte[] ha2 = md.digest();
                md.update(TypeUtil.toString(ha1, 16).getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.nonce.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.nc.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.cnonce.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.qop.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(TypeUtil.toString(ha2, 16).getBytes(StringUtil.__ISO_8859_1));
                byte[] digest = md.digest();
                return TypeUtil.toString(digest, 16).equalsIgnoreCase(this.response);
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                return false;
            }
        }

        public String toString() {
            return this.username + "," + this.response;
        }
    }
}

