/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Arrays;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;

public class EventElement
implements EmbeddedPacketExtension {
    private EventElementType type;
    private NodeExtension ext;

    public EventElement(EventElementType eventType, NodeExtension eventExt) {
        this.type = eventType;
        this.ext = eventExt;
    }

    public EventElementType getEventType() {
        return this.type;
    }

    @Override
    public List<PacketExtension> getExtensions() {
        return Arrays.asList(this.getEvent());
    }

    public NodeExtension getEvent() {
        return this.ext;
    }

    public String getElementName() {
        return "event";
    }

    public String getNamespace() {
        return PubSubNamespace.EVENT.getXmlns();
    }

    public String toXML() {
        StringBuilder builder = new StringBuilder("<event xmlns='" + PubSubNamespace.EVENT.getXmlns() + "'>");
        builder.append(this.ext.toXML());
        builder.append("</event>");
        return builder.toString();
    }
}

