/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import com.lti.utils.synchronization.CloseableThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import net.sf.fmj.media.multiplexer.InputStreamPushSourceStream;
import net.sf.fmj.media.multiplexer.StreamPipe;
import net.sf.fmj.utility.IOUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class StreamCopyPushDataSource
extends PushDataSource {
    private static final Logger logger = LoggerSingleton.logger;
    private final ContentDescriptor outputContentDescriptor;
    private final int numTracks;
    private final InputStream[] inputStreams;
    private final Format[] inputFormats;
    private InputStreamPushSourceStream[] pushSourceStreams;
    private WriterThread[] writerThreads;

    public StreamCopyPushDataSource(ContentDescriptor contentDescriptor, int n, InputStream[] inputStreamArray, Format[] formatArray) {
        this.outputContentDescriptor = contentDescriptor;
        this.numTracks = n;
        this.inputStreams = inputStreamArray;
        this.inputFormats = formatArray;
    }

    public void connect() throws IOException {
        logger.finer(this.getClass().getSimpleName() + " connect");
        this.pushSourceStreams = new InputStreamPushSourceStream[this.numTracks];
        this.writerThreads = new WriterThread[this.numTracks];
        for (int i = 0; i < this.numTracks; ++i) {
            StreamPipe streamPipe = new StreamPipe();
            this.pushSourceStreams[i] = new InputStreamPushSourceStream(this.outputContentDescriptor, streamPipe.getInputStream());
            this.writerThreads[i] = new WriterThread(i, this.inputStreams[i], streamPipe.getOutputStream(), this.inputFormats[i]);
            this.writerThreads[i].setName("WriterThread for track " + i);
            this.writerThreads[i].setDaemon(true);
        }
    }

    public void disconnect() {
        logger.finer(this.getClass().getSimpleName() + " disconnect");
    }

    public String getContentType() {
        logger.finer(this.getClass().getSimpleName() + " getContentType");
        return this.outputContentDescriptor.getContentType();
    }

    public Object getControl(String string) {
        logger.finer(this.getClass().getSimpleName() + " getControl");
        return null;
    }

    public Object[] getControls() {
        logger.finer(this.getClass().getSimpleName() + " getControls");
        return new Object[0];
    }

    public Time getDuration() {
        logger.finer(this.getClass().getSimpleName() + " getDuration");
        return Time.TIME_UNKNOWN;
    }

    public PushSourceStream[] getStreams() {
        logger.finer(this.getClass().getSimpleName() + " getStreams");
        return this.pushSourceStreams;
    }

    public void notifyDataAvailable(int n) {
        this.pushSourceStreams[n].notifyDataAvailable();
    }

    public void start() throws IOException {
        logger.finer(this.getClass().getSimpleName() + " start");
        for (int i = 0; i < this.numTracks; ++i) {
            this.writerThreads[i].start();
        }
    }

    public void stop() throws IOException {
        int n;
        logger.finer(this.getClass().getSimpleName() + " stop");
        for (n = 0; n < this.numTracks; ++n) {
            this.writerThreads[n].close();
        }
        try {
            for (n = 0; n < this.numTracks; ++n) {
                this.writerThreads[n].waitUntilClosed();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    public void waitUntilFinished() throws InterruptedException {
        for (int i = 0; i < this.numTracks; ++i) {
            this.writerThreads[i].waitUntilClosed();
        }
    }

    protected void write(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        IOUtils.copyStream(inputStream, outputStream);
    }

    private class WriterThread
    extends CloseableThread {
        private final int trackID;
        private final InputStream in;
        private final OutputStream out;
        private Format format;

        public WriterThread(int n, InputStream inputStream, OutputStream outputStream, Format format) {
            this.trackID = n;
            this.in = inputStream;
            this.out = outputStream;
            this.format = format;
        }

        public void run() {
            try {
                StreamCopyPushDataSource.this.write(this.in, this.out, this.trackID);
                logger.finer("WriterThread closing output stream");
                this.out.close();
            }
            catch (InterruptedIOException interruptedIOException) {
                logger.log(Level.FINE, "" + interruptedIOException, interruptedIOException);
                return;
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
            }
            finally {
                this.setClosed();
            }
        }
    }
}

