/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class UpdateAdvisory
extends ConnCommand {
    public static final int TYPE_MANDATORY_UPDATE = 1;
    public static final int TYPE_RECOMMENDED_UPDATE = 2;
    public static final int TYPE_SYSTEM_BULLETIN = 3;
    public static final int TYPE_OKAY = 4;
    private static final int TYPE_MESSAGE = 11;
    private final int type;
    private final String message;

    protected UpdateAdvisory(SnacPacket packet) {
        super(19);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.type = BinaryTools.getUShort((ByteBlock)snacData, (int)0);
        ByteBlock tlvBlock = snacData.subBlock(2);
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        this.message = chain.getString(11);
    }

    public UpdateAdvisory(int type) {
        this(type, null);
    }

    public UpdateAdvisory(int type, String message) {
        super(19);
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        this.type = type;
        this.message = message;
    }

    public final int getAdvisoryType() {
        return this.type;
    }

    public final String getMessage() {
        return this.message;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.type);
        if (this.message != null) {
            Tlv.getStringInstance(11, this.message).write(out);
        }
        Tlv.getUShortInstance(2, 21).write(out);
        Tlv.getUShortInstance(3, 1200).write(out);
    }

    public String toString() {
        return "UpdateAdvisory: type=" + this.type + ", message=" + this.message;
    }
}

