/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class CacheStatisticsImpl
implements DataSerializable,
CacheStatistics {
    private static final float FLOAT_HUNDRED = 100.0f;
    private static final long NANOSECONDS_IN_A_MICROSECOND = 1000L;
    private static final AtomicLongFieldUpdater<CacheStatisticsImpl> REMOVALS_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheStatisticsImpl.class, "removals");
    private static final AtomicLongFieldUpdater<CacheStatisticsImpl> EXPIRIES_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheStatisticsImpl.class, "expiries");
    private static final AtomicLongFieldUpdater<CacheStatisticsImpl> PUTS_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheStatisticsImpl.class, "puts");
    private static final AtomicLongFieldUpdater<CacheStatisticsImpl> HITS_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheStatisticsImpl.class, "hits");
    private static final AtomicLongFieldUpdater<CacheStatisticsImpl> MISSES_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheStatisticsImpl.class, "misses");
    private static final AtomicLongFieldUpdater<CacheStatisticsImpl> EVICTIONS_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheStatisticsImpl.class, "evictions");
    private static final AtomicLongFieldUpdater<CacheStatisticsImpl> PUT_TIME_TAKEN_NANOS_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheStatisticsImpl.class, "putTimeTakenNanos");
    private static final AtomicLongFieldUpdater<CacheStatisticsImpl> GET_CACHE_TIME_TAKEN_NANOS_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheStatisticsImpl.class, "getCacheTimeTakenNanos");
    private static final AtomicLongFieldUpdater<CacheStatisticsImpl> REMOVE_TIME_TAKEN_NANOS_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheStatisticsImpl.class, "removeTimeTakenNanos");
    private volatile long removals;
    private volatile long expiries;
    private volatile long puts;
    private volatile long hits;
    private volatile long misses;
    private volatile long evictions;
    private volatile long putTimeTakenNanos;
    private volatile long getCacheTimeTakenNanos;
    private volatile long removeTimeTakenNanos;

    @Override
    public long getCacheRemovals() {
        return this.removals;
    }

    public long getCacheExpiries() {
        return this.expiries;
    }

    @Override
    public long getCacheGets() {
        return this.getCacheHits() + this.getCacheMisses();
    }

    @Override
    public long getCachePuts() {
        return this.puts;
    }

    @Override
    public long getCacheHits() {
        return this.hits;
    }

    @Override
    public long getCacheMisses() {
        return this.misses;
    }

    @Override
    public long getCacheEvictions() {
        return this.evictions;
    }

    public long getCachePutTimeTakenNanos() {
        return this.putTimeTakenNanos;
    }

    public long getCacheGetTimeTakenNanos() {
        return this.getCacheTimeTakenNanos;
    }

    public long getCacheRemoveTimeTakenNanos() {
        return this.removeTimeTakenNanos;
    }

    @Override
    public float getCacheHitPercentage() {
        long cacheHits = this.getCacheHits();
        long cacheGets = this.getCacheGets();
        if (cacheHits == 0L || cacheGets == 0L) {
            return 0.0f;
        }
        return (float)cacheHits / (float)cacheGets * 100.0f;
    }

    @Override
    public float getCacheMissPercentage() {
        long cacheMisses = this.getCacheMisses();
        long cacheGets = this.getCacheGets();
        if (cacheMisses == 0L || cacheGets == 0L) {
            return 0.0f;
        }
        return (float)cacheMisses / (float)cacheGets * 100.0f;
    }

    @Override
    public float getAverageGetTime() {
        long cacheGetTimeTakenNanos = this.getCacheGetTimeTakenNanos();
        long cacheGets = this.getCacheGets();
        if (cacheGetTimeTakenNanos == 0L || cacheGets == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)cacheGetTimeTakenNanos / (float)cacheGets / 1000.0f;
    }

    @Override
    public float getAveragePutTime() {
        long cachePutTimeTakenNanos = this.getCachePutTimeTakenNanos();
        long cachePuts = this.getCachePuts();
        if (cachePutTimeTakenNanos == 0L || cachePuts == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)cachePutTimeTakenNanos / (float)cachePuts / 1000.0f;
    }

    @Override
    public float getAverageRemoveTime() {
        long cacheRemoveTimeTakenNanos = this.getCacheRemoveTimeTakenNanos();
        long cacheGets = this.getCacheGets();
        if (cacheRemoveTimeTakenNanos == 0L || cacheGets == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)cacheRemoveTimeTakenNanos / (float)cacheGets / 1000.0f;
    }

    public void clear() {
        this.puts = 0L;
        this.misses = 0L;
        this.removals = 0L;
        this.expiries = 0L;
        this.hits = 0L;
        this.evictions = 0L;
        this.getCacheTimeTakenNanos = 0L;
        this.putTimeTakenNanos = 0L;
        this.removeTimeTakenNanos = 0L;
    }

    public void increaseCacheRemovals(long number) {
        REMOVALS_UPDATER.addAndGet(this, number);
    }

    public void increaseCacheExpiries(long number) {
        EXPIRIES_UPDATER.addAndGet(this, number);
    }

    public void increaseCachePuts(long number) {
        PUTS_UPDATER.addAndGet(this, number);
    }

    public void increaseCacheHits(long number) {
        HITS_UPDATER.addAndGet(this, number);
    }

    public void increaseCacheMisses(long number) {
        MISSES_UPDATER.addAndGet(this, number);
    }

    public void increaseCacheEvictions(long number) {
        EVICTIONS_UPDATER.addAndGet(this, number);
    }

    public void addGetTimeNanos(long duration) {
        while (true) {
            long nanos;
            if ((nanos = this.getCacheTimeTakenNanos) <= Long.MAX_VALUE - duration) {
                if (!GET_CACHE_TIME_TAKEN_NANOS_UPDATER.compareAndSet(this, nanos, nanos + duration)) continue;
                return;
            }
            if (GET_CACHE_TIME_TAKEN_NANOS_UPDATER.compareAndSet(this, nanos, duration)) break;
        }
        this.clear();
    }

    public void addPutTimeNanos(long duration) {
        while (true) {
            long nanos;
            if ((nanos = this.putTimeTakenNanos) <= Long.MAX_VALUE - duration) {
                if (!PUT_TIME_TAKEN_NANOS_UPDATER.compareAndSet(this, nanos, nanos + duration)) continue;
                return;
            }
            if (PUT_TIME_TAKEN_NANOS_UPDATER.compareAndSet(this, nanos, duration)) break;
        }
        this.clear();
    }

    public void addRemoveTimeNanos(long duration) {
        while (true) {
            long nanos;
            if ((nanos = this.removeTimeTakenNanos) <= Long.MAX_VALUE - duration) {
                if (!REMOVE_TIME_TAKEN_NANOS_UPDATER.compareAndSet(this, nanos, nanos + duration)) continue;
                return;
            }
            if (REMOVE_TIME_TAKEN_NANOS_UPDATER.compareAndSet(this, nanos, duration)) break;
        }
        this.clear();
    }

    public CacheStatisticsImpl accumulate(CacheStatisticsImpl other) {
        PUTS_UPDATER.addAndGet(this, other.getCachePuts());
        REMOVALS_UPDATER.addAndGet(this, other.getCacheRemovals());
        EXPIRIES_UPDATER.addAndGet(this, other.getCacheExpiries());
        EVICTIONS_UPDATER.addAndGet(this, other.getCacheEvictions());
        HITS_UPDATER.addAndGet(this, other.getCacheHits());
        MISSES_UPDATER.addAndGet(this, other.getCacheMisses());
        PUT_TIME_TAKEN_NANOS_UPDATER.addAndGet(this, other.getCachePutTimeTakenNanos());
        GET_CACHE_TIME_TAKEN_NANOS_UPDATER.addAndGet(this, other.getCacheGetTimeTakenNanos());
        REMOVE_TIME_TAKEN_NANOS_UPDATER.addAndGet(this, other.getCacheRemoveTimeTakenNanos());
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.puts);
        out.writeLong(this.removals);
        out.writeLong(this.expiries);
        out.writeLong(this.evictions);
        out.writeLong(this.hits);
        out.writeLong(this.misses);
        out.writeLong(this.putTimeTakenNanos);
        out.writeLong(this.getCacheTimeTakenNanos);
        out.writeLong(this.removeTimeTakenNanos);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.puts = in.readLong();
        this.removals = in.readLong();
        this.expiries = in.readLong();
        this.evictions = in.readLong();
        this.hits = in.readLong();
        this.misses = in.readLong();
        this.putTimeTakenNanos = in.readLong();
        this.getCacheTimeTakenNanos = in.readLong();
        this.removeTimeTakenNanos = in.readLong();
    }
}

