/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import ymsg.network.DebugInputStream;
import ymsg.network.YMSG9Packet;

public class YMSG9InputStream
extends BufferedInputStream {
    DebugInputStream dbis = null;

    public YMSG9InputStream(InputStream in) {
        super(in);
        if (in instanceof DebugInputStream) {
            this.dbis = (DebugInputStream)in;
        }
    }

    public YMSG9Packet readPacket() throws IOException {
        int i;
        byte[] header;
        YMSG9Packet p = new YMSG9Packet();
        if (this.dbis != null) {
            this.dbis.debugReset();
        }
        if (this.readBuffer(header = new byte[20]) <= 0) {
            return null;
        }
        p.magic = "" + (char)header[0] + (char)header[1] + (char)header[2] + (char)header[3];
        p.version = this.u2i(header[5]);
        p.length = (this.u2i(header[8]) << 8) + this.u2i(header[9]);
        p.service = (this.u2i(header[10]) << 8) + this.u2i(header[11]);
        p.status = (this.u2i(header[12]) << 24) + (this.u2i(header[13]) << 16) + (this.u2i(header[14]) << 8) + this.u2i(header[15]);
        p.sessionId = (this.u2i(header[16]) << 24) + (this.u2i(header[17]) << 16) + (this.u2i(header[18]) << 8) + this.u2i(header[19]);
        if (!p.magic.equals("YMSG")) {
            throw new IOException("Bad YMSG9 header");
        }
        Vector<String> v = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        byte[] body = new byte[p.length];
        if (this.readBuffer(body) < 0) {
            return null;
        }
        if (this.dbis != null) {
            this.dbis.debugDump();
        }
        int start = 0;
        boolean keyPos = true;
        for (i = 0; i < body.length - 1; ++i) {
            if (this.u2i(body[i]) != 192 || this.u2i(body[i + 1]) != 128) continue;
            String s = new String(body, start, i - start, "UTF-8");
            if (keyPos) {
                if (this.isKey(s = this.cleanse(s))) {
                    v.addElement(s);
                }
            } else {
                v.addElement(s);
            }
            keyPos = !keyPos;
            start = ++i + 1;
        }
        p.body = new String[v.size()];
        p.body = v.toArray(p.body);
        if (this.dbis != null) {
            System.out.println(">>[" + p.body.length + "]");
            for (i = 0; i < p.body.length; i += 2) {
                System.out.println(">>" + p.body[i] + "=" + p.body[i + 1]);
            }
        }
        return p;
    }

    private int u2i(byte b) {
        return b & 0xFF;
    }

    private String cleanse(String s) {
        while (s.length() > 0 && (s.charAt(0) == '\u0000' || s.charAt(0) > '\u007f')) {
            System.out.println(">>Discarding " + s);
            s = s.substring(1);
        }
        return s;
    }

    private boolean isKey(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return s.length() <= 5;
    }

    private int readBuffer(byte[] buff) throws IOException {
        int p;
        int r = 0;
        for (p = 0; p < buff.length; p += r) {
            r = super.read(buff, p, buff.length - p);
            if (r >= 0) continue;
            return (p + 1) * -1;
        }
        return p;
    }
}

