/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.cindy.util.ByteBufferUtils;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.util.Charset;

public abstract class MsnP2PMessage
extends MsnMimeMessage {
    private static final int BINARY_HEADER_LEN = 48;
    private static final int BINARY_FOOTER_LEN = 4;
    private static final String KEY_P2P_DEST = "P2P-Dest";
    private final ByteBuffer binaryHeader = ByteBuffer.allocate(48).order(ByteOrder.LITTLE_ENDIAN);
    private final ByteBuffer binaryFooter = ByteBuffer.allocate(4);

    public MsnP2PMessage() {
        this.setContentType("application/x-msnmsgrp2p");
    }

    public void setP2PDest(String string) {
        this.headers.setProperty(KEY_P2P_DEST, string);
    }

    public String getP2PDest() {
        return this.headers.getProperty(KEY_P2P_DEST);
    }

    public void setAppId(int n) {
        this.binaryFooter.putInt(0, n);
    }

    public int getAppId() {
        return this.binaryFooter.getInt(0);
    }

    public void setSessionId(int n) {
        this.binaryHeader.putInt(0, n);
    }

    public int getSessionId() {
        return this.binaryHeader.getInt(0);
    }

    protected void setOffset(long l) {
        this.binaryHeader.putLong(8, l);
    }

    protected long getOffset() {
        return this.binaryHeader.getLong(8);
    }

    protected void setTotalLength(long l) {
        this.binaryHeader.putLong(16, l);
    }

    protected long getTotalLength() {
        return this.binaryHeader.getLong(16);
    }

    protected void setCurrentLength(int n) {
        this.binaryHeader.putInt(24, n);
    }

    protected int getCurrentLength() {
        return this.binaryHeader.getInt(24);
    }

    protected void setFlag(int n) {
        this.binaryHeader.putInt(28, n);
    }

    protected int getFlag() {
        return this.binaryHeader.getInt(28);
    }

    protected void parseMessage(byte[] byArray) {
        ByteBuffer byteBuffer = Charset.encode("\r\n\r\n");
        int n = ByteBufferUtils.indexOf((ByteBuffer)ByteBuffer.wrap(byArray), (ByteBuffer)byteBuffer);
        String string = n == -1 ? Charset.decode(byArray) : Charset.decode(byArray, 0, n);
        this.headers.parseString(string);
        this.binaryHeader.put(byArray, n += byteBuffer.remaining(), 48);
        this.binaryHeader.flip();
        this.parseP2PBody(ByteBuffer.wrap(byArray, n += 48, byArray.length - n - 4));
        this.binaryFooter.put(byArray, byArray.length - 4, 4);
        this.binaryFooter.flip();
    }

    protected abstract void parseP2PBody(ByteBuffer var1);

    protected abstract byte[] bodyToMessage();
}

