/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FilenameSelector
extends BaseExtendSelector {
    public static final String NAME_KEY = "name";
    public static final String CASE_KEY = "casesensitive";
    public static final String NEGATE_KEY = "negate";
    private String pattern;
    private boolean casesensitive;
    private boolean negated;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{filenameselector name: ");
        stringBuffer.append(this.pattern);
        stringBuffer.append(" negate: ");
        if (this.negated) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append(" casesensitive: ");
        if (this.casesensitive) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setName(String string) {
        if ((string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar)).endsWith(File.separator)) {
            string = string + "**";
        }
        this.pattern = string;
    }

    public void setCasesensitive(boolean bl) {
        this.casesensitive = bl;
    }

    public void setNegate(boolean bl) {
        this.negated = bl;
    }

    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                String string = parameterArray[n].getName();
                if (NAME_KEY.equalsIgnoreCase(string)) {
                    this.setName(parameterArray[n].getValue());
                } else if (CASE_KEY.equalsIgnoreCase(string)) {
                    this.setCasesensitive(Project.toBoolean(parameterArray[n].getValue()));
                } else if (NEGATE_KEY.equalsIgnoreCase(string)) {
                    this.setNegate(Project.toBoolean(parameterArray[n].getValue()));
                } else {
                    this.setError("Invalid parameter " + string);
                }
                ++n;
            }
        }
    }

    public void verifySettings() {
        if (this.pattern == null) {
            this.setError("The name attribute is required");
        }
    }

    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        return SelectorUtils.matchPath(this.pattern, string, this.casesensitive) ^ (this.negated ^ true) ^ true;
    }

    private final /* synthetic */ void this() {
        this.pattern = null;
        this.casesensitive = true;
        this.negated = false;
    }

    public FilenameSelector() {
        this.this();
    }
}

