/*
 * Decompiled with CFR 0.152.
 */
package org.rubycoder.gsm;

public class GSMEncoder {
    private static final byte GSM_MAGIC = 13;
    private static final int[] FAC = new int[]{18431, 20479, 22527, 24575, 26623, 28671, 30719, Short.MAX_VALUE};
    private final int[] gsm_DLB = new int[]{6554, 16384, 26214, Short.MAX_VALUE};
    private static final byte[] bitoff = new byte[]{8, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] gsm_NRFAC = new int[]{29128, 26215, 23832, 21846, 20165, 18725, 17476, 16384};
    private static final int MIN_WORD = Short.MIN_VALUE;
    private static final int MAX_WORD = Short.MAX_VALUE;
    private static final int MIN_LONGWORD = Integer.MIN_VALUE;
    private static final int MAX_LONGWORD = Integer.MAX_VALUE;
    private final int[] dp0 = new int[280];
    private final int[] u = new int[8];
    private final int[][] LARpp = new int[2][8];
    private int j;
    private final int[] e = new int[50];
    private int z1;
    private int L_z2;
    private int mp;
    private int dpOffset;
    private int dppOffset;
    private int bcOffset;
    private int ncOffset;
    private int xmaxcOffset;
    private int eOffset;
    private int xmcOffset;
    private int dOffset;
    private int mcoffset = 0;

    private static int add(int n, int n2) {
        int n3 = n + n2;
        return GSMEncoder.saturate(n3);
    }

    private static int asl(int n, int n2) {
        if (n2 >= 16) {
            return 0;
        }
        if (n2 <= -16) {
            return n < 0 ? -1 : 0;
        }
        if (n2 < 0) {
            return GSMEncoder.asr(n, -n2);
        }
        return n << n2;
    }

    private static int asr(int n, int n2) {
        if (n2 >= 16) {
            return n < 0 ? -1 : 0;
        }
        if (n2 <= -16) {
            return 0;
        }
        if (n2 < 0) {
            return n << -n2;
        }
        return n >> n2;
    }

    private static void Coefficients_40_159(int[] nArray, int[] nArray2) {
        for (int i = 0; i < 8; ++i) {
            nArray2[i] = nArray[i];
        }
    }

    private static void LARp_to_rp(int[] nArray) {
        for (int i = 0; i < 8; ++i) {
            int n;
            if (nArray[i] < 0) {
                int n2 = n = nArray[i] == Short.MIN_VALUE ? Short.MAX_VALUE : -nArray[i];
                nArray[i] = -(n < 11059 ? n << 1 : (n < 20070 ? n + 11059 : GSMEncoder.add(n >> 2, 26112)));
                continue;
            }
            n = nArray[i];
            nArray[i] = n < 11059 ? n << 1 : (n < 20070 ? n + 11059 : GSMEncoder.add(n >> 2, 26112));
        }
    }

    public static void main(String[] stringArray) {
        GSMEncoder gSMEncoder = new GSMEncoder();
        int[] nArray = new int[160];
        gSMEncoder.encode(nArray);
    }

    private static int mult_r(int n, int n2) {
        if (n2 == Short.MIN_VALUE && n == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        int n3 = n * n2 + 16384;
        return GSMEncoder.saturate(n3 >> 15);
    }

    public static void print(String string, int[] nArray) {
        System.out.print("[" + string + ":");
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print("" + nArray[i]);
            if (i < nArray.length - 1) {
                System.out.print(",");
                continue;
            }
            System.out.println("]");
        }
    }

    public static void print(String string, int n) {
        System.out.println("[" + string + ":" + n + "]");
    }

    private static int saturate(int n) {
        return n < Short.MIN_VALUE ? Short.MIN_VALUE : (n > Short.MAX_VALUE ? Short.MAX_VALUE : n);
    }

    private static int sub(int n, int n2) {
        int n3 = n - n2;
        return GSMEncoder.saturate(n3);
    }

    private int abs(int n) {
        return n < 0 ? (n == Short.MIN_VALUE ? Short.MAX_VALUE : -n) : n;
    }

    private void APCM_quantization(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        int n;
        int n2;
        int[] nArray6 = new int[1];
        int[] nArray7 = new int[1];
        int n3 = 0;
        for (n2 = 0; n2 <= 12; ++n2) {
            n = nArray[n2];
            if ((n = this.abs(n)) <= n3) continue;
            n3 = n;
        }
        nArray6[0] = 0;
        n = this.sasr(n3, 9);
        boolean bl = false;
        for (n2 = 0; n2 <= 5; ++n2) {
            bl |= n <= 0;
            n = this.sasr(n, 1);
            assert (nArray6[0] <= 5);
            if (bl) continue;
            nArray6[0] = nArray6[0] + 1;
        }
        assert (nArray6[0] <= 6 && nArray6[0] >= 0);
        n = nArray6[0] + 5;
        assert (n <= 11 && n >= 0);
        int n4 = GSMEncoder.add(this.sasr(n3, n), nArray6[0] << 3);
        this.APCM_quantization_xmaxc_to_exp_mant(n4, nArray6, nArray7);
        assert (nArray6[0] <= 4096 && nArray6[0] >= -4096);
        assert (nArray7[0] >= 0 && nArray7[0] <= 7);
        int n5 = 6 - nArray6[0];
        int n6 = this.gsm_NRFAC[nArray7[0]];
        for (n2 = 0; n2 <= 12; ++n2) {
            assert (n5 >= 0 && n5 < 16);
            n = nArray[n2] << n5;
            n = this.gsm_mult(n, n6);
            n = this.sasr(n, 12);
            nArray2[this.xmcOffset + n2] = n + 4;
        }
        nArray3[0] = nArray7[0];
        nArray4[0] = nArray6[0];
        nArray5[this.xmaxcOffset] = n4;
    }

    private void APCM_quantization_xmaxc_to_exp_mant(int n, int[] nArray, int[] nArray2) {
        int n2;
        int n3 = 0;
        if (n > 15) {
            n3 = this.sasr(n, 3) - 1;
        }
        if ((n2 = n - (n3 << 3)) == 0) {
            n3 = -4;
            n2 = 7;
        } else {
            while (n2 <= 7) {
                n2 = n2 << 1 | 1;
                --n3;
            }
            n2 -= 8;
        }
        assert (n3 >= -4 && n3 <= 6);
        assert (n2 >= 0 && n2 <= 7);
        nArray[0] = n3;
        nArray2[0] = n2;
    }

    private void APCMInverseQuantization(int[] nArray, int n, int n2, int[] nArray2) {
        int n3 = 0;
        assert (n2 >= 0 && n2 <= 7);
        int n4 = this.xmcOffset;
        int n5 = FAC[n2];
        int n6 = GSMEncoder.sub(6, n);
        int n7 = GSMEncoder.asl(1, GSMEncoder.sub(n6, 1));
        int n8 = 13;
        while (n8-- > 0) {
            assert (nArray[n4] <= 7 && nArray[n4] >= 0);
            int n9 = (nArray[n4++] << 1) - 7;
            assert (n9 <= 7 && n9 >= -7);
            n9 <<= 12;
            n9 = GSMEncoder.mult_r(n5, n9);
            n9 = GSMEncoder.add(n9, n7);
            nArray2[n3++] = GSMEncoder.asr(n9, n6);
        }
    }

    private void Autocorrelation(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4 = this.dOffset;
        assert (this.dOffset == 0);
        int n5 = 0;
        for (n3 = 0; n3 <= 159; ++n3) {
            int n6 = this.abs(nArray[n4 + n3]);
            if (n6 <= n5) continue;
            n5 = n6;
        }
        if (n5 == 0) {
            n2 = 0;
        } else {
            assert (n5 > 0);
            n2 = 4 - this.gsm_norm(n5 << 16);
        }
        if (n2 > 0) {
            switch (n2) {
                case 1: {
                    for (n3 = 0; n3 <= 159; ++n3) {
                        nArray[n3] = GSMEncoder.mult_r(nArray[n3], 16384);
                    }
                    break;
                }
                case 2: {
                    for (n3 = 0; n3 <= 159; ++n3) {
                        nArray[n3] = GSMEncoder.mult_r(nArray[n3], 8192);
                    }
                    break;
                }
                case 3: {
                    for (n3 = 0; n3 <= 159; ++n3) {
                        nArray[n3] = GSMEncoder.mult_r(nArray[n3], 4096);
                    }
                    break;
                }
                case 4: {
                    for (n3 = 0; n3 <= 159; ++n3) {
                        nArray[n3] = GSMEncoder.mult_r(nArray[n3], 2048);
                    }
                    break;
                }
            }
        }
        int n7 = 0;
        int n8 = nArray[n7];
        for (n3 = 9; n3 > 0; --n3) {
            nArray2[n3 - 1] = 0;
        }
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i <= n; ++i) {
                int n9 = i;
                nArray2[n9] = nArray2[n9] + n8 * nArray[n7 - i];
            }
            if (n >= 7) continue;
            n8 = nArray[++n7];
        }
        for (int i = 8; i <= 159; ++i) {
            n8 = nArray[++n7];
            for (n = 0; n <= 8; ++n) {
                int n10 = n;
                nArray2[n10] = nArray2[n10] + n8 * nArray[n7 - n];
            }
        }
        for (n3 = 9; n3 > 0; --n3) {
            int n11 = n3 - 1;
            nArray2[n11] = nArray2[n11] << 1;
        }
        if (n2 > 0) {
            assert (n2 <= 4);
            for (n3 = 160; n3 > 0; --n3) {
                int n12 = n4++;
                nArray[n12] = nArray[n12] << n2;
            }
        }
    }

    private void Calculation_of_the_LTP_parameters(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray5 = new int[40];
        int n6 = 0;
        for (n5 = 0; n5 < 40; ++n5) {
            n4 = nArray[this.dOffset + n5];
            if ((n4 = this.abs(n4)) <= n6) continue;
            n6 = n4;
        }
        n4 = 0;
        if (n6 == 0) {
            n3 = 0;
        } else {
            assert (n6 > 0);
            n4 = this.gsm_norm(n6 << 16);
        }
        n3 = n4 > 6 ? 0 : 6 - n4;
        assert (n3 >= 0);
        for (n5 = 0; n5 < 40; ++n5) {
            nArray5[n5] = this.sasr(nArray[this.dOffset + n5], n3);
        }
        int n7 = 0;
        int n8 = 40;
        for (int i = 40; i <= 120; ++i) {
            n2 = nArray5[0] * nArray2[this.dpOffset - i];
            for (int j = 1; j < 40; ++j) {
                n2 += nArray5[j] * nArray2[this.dpOffset + j - i];
            }
            if (n2 <= n7) continue;
            n8 = i;
            n7 = n2;
        }
        nArray4[this.ncOffset] = n8;
        n7 <<= 1;
        assert (n3 <= 100 && n3 >= -100);
        n7 >>= 6 - n3;
        assert (n8 <= 120 && n8 >= 40);
        int n9 = 0;
        for (n5 = 0; n5 <= 39; ++n5) {
            n2 = this.sasr(nArray2[this.dpOffset + n5 - n8], 3);
            n9 += n2 * n2;
        }
        n9 <<= 1;
        if (n7 <= 0) {
            nArray3[this.bcOffset] = 0;
            return;
        }
        if (n7 >= n9) {
            nArray3[this.bcOffset] = 3;
            return;
        }
        n4 = this.gsm_norm(n9);
        int n10 = this.sasr(n7 << n4, 16);
        int n11 = this.sasr(n9 << n4, 16);
        for (n = 0; n <= 2 && n10 > this.gsm_mult(n11, this.gsm_DLB[n]); ++n) {
        }
        nArray3[this.bcOffset] = n;
    }

    private void Coefficients_0_12(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < 8; ++i) {
            nArray3[i] = GSMEncoder.add(this.sasr(nArray[i], 2), this.sasr(nArray2[i], 2));
            nArray3[i] = GSMEncoder.add(nArray3[i], this.sasr(nArray[i], 1));
        }
    }

    private void Coefficients_13_26(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < 8; ++i) {
            nArray3[i] = GSMEncoder.add(this.sasr(nArray[i], 1), this.sasr(nArray2[i], 1));
        }
    }

    private void Coefficients_27_39(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < 8; ++i) {
            nArray3[i] = GSMEncoder.add(this.sasr(nArray[i], 2), this.sasr(nArray2[i], 2));
            nArray3[i] = GSMEncoder.add(nArray3[i], this.sasr(nArray2[i], 1));
        }
    }

    private void DecodingOfTheCodedLogAreaRatios(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = GSMEncoder.add(nArray[n++], -32) << 10;
        n3 = GSMEncoder.sub(n3, 0);
        n3 = GSMEncoder.mult_r(13107, n3);
        nArray2[n2++] = GSMEncoder.add(n3, n3);
        n3 = GSMEncoder.add(nArray[n++], -32) << 10;
        n3 = GSMEncoder.sub(n3, 0);
        n3 = GSMEncoder.mult_r(13107, n3);
        nArray2[n2++] = GSMEncoder.add(n3, n3);
        n3 = GSMEncoder.add(nArray[n++], -16) << 10;
        n3 = GSMEncoder.sub(n3, 4096);
        n3 = GSMEncoder.mult_r(13107, n3);
        nArray2[n2++] = GSMEncoder.add(n3, n3);
        n3 = GSMEncoder.add(nArray[n++], -16) << 10;
        n3 = GSMEncoder.sub(n3, -5120);
        n3 = GSMEncoder.mult_r(13107, n3);
        nArray2[n2++] = GSMEncoder.add(n3, n3);
        n3 = GSMEncoder.add(nArray[n++], -8) << 10;
        n3 = GSMEncoder.sub(n3, 188);
        n3 = GSMEncoder.mult_r(19223, n3);
        nArray2[n2++] = GSMEncoder.add(n3, n3);
        n3 = GSMEncoder.add(nArray[n++], -8) << 10;
        n3 = GSMEncoder.sub(n3, -3584);
        n3 = GSMEncoder.mult_r(17476, n3);
        nArray2[n2++] = GSMEncoder.add(n3, n3);
        n3 = GSMEncoder.add(nArray[n++], -4) << 10;
        n3 = GSMEncoder.sub(n3, -682);
        n3 = GSMEncoder.mult_r(31454, n3);
        nArray2[n2++] = GSMEncoder.add(n3, n3);
        n3 = GSMEncoder.add(nArray[n++], -4) << 10;
        n3 = GSMEncoder.sub(n3, -2288);
        n3 = GSMEncoder.mult_r(29708, n3);
        nArray2[n2++] = GSMEncoder.add(n3, n3);
    }

    public final void encode(byte[] byArray, int[] nArray) {
        int n = 0;
        int[] nArray2 = new int[8];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[4];
        int[] nArray6 = new int[4];
        int[] nArray7 = new int[52];
        this.encoder(nArray, nArray2, nArray3, nArray5, nArray4, nArray6, nArray7);
        byArray[n++] = (byte)(0xD0 | nArray2[0] >> 2 & 0xF);
        byArray[n++] = (byte)((nArray2[0] & 3) << 6 | nArray2[1] & 0x3F);
        byArray[n++] = (byte)((nArray2[2] & 0x1F) << 3 | nArray2[3] >> 2 & 7);
        byArray[n++] = (byte)((nArray2[3] & 3) << 6 | (nArray2[4] & 0xF) << 2 | nArray2[5] >> 2 & 3);
        byArray[n++] = (byte)((nArray2[5] & 3) << 6 | (nArray2[6] & 7) << 3 | nArray2[7] & 7);
        byArray[n++] = (byte)((nArray3[0] & 0x7F) << 1 | nArray5[0] >>> 1 & 1);
        byArray[n++] = (byte)((nArray5[0] & 1) << 7 | (nArray4[0] & 3) << 5 | nArray6[0] >> 1 & 0x1F);
        byArray[n++] = (byte)((nArray6[0] & 1) << 7 | (nArray7[0] & 7) << 4 | (nArray7[1] & 7) << 1 | nArray7[2] >> 2 & 1);
        byArray[n++] = (byte)((nArray7[2] & 3) << 6 | (nArray7[3] & 7) << 3 | nArray7[4] & 7);
        byArray[n++] = (byte)((nArray7[5] & 7) << 5 | (nArray7[6] & 7) << 2 | nArray7[7] >> 1 & 3);
        byArray[n++] = (byte)((nArray7[7] & 1) << 7 | (nArray7[8] & 7) << 4 | (nArray7[9] & 7) << 1 | nArray7[10] >> 2 & 1);
        byArray[n++] = (byte)((nArray7[10] & 3) << 6 | (nArray7[11] & 7) << 3 | nArray7[12] & 7);
        byArray[n++] = (byte)((nArray3[1] & 0x7F) << 1 | nArray5[1] >> 1 & 1);
        byArray[n++] = (byte)((nArray5[1] & 1) << 7 | (nArray4[1] & 3) << 5 | nArray6[1] >> 1 & 0x1F);
        byArray[n++] = (byte)((nArray6[1] & 1) << 7 | (nArray7[13] & 7) << 4 | (nArray7[14] & 7) << 1 | nArray7[15] >> 2 & 1);
        byArray[n++] = (byte)((nArray7[15] & 3) << 6 | (nArray7[16] & 7) << 3 | nArray7[17] & 7);
        byArray[n++] = (byte)((nArray7[18] & 7) << 5 | (nArray7[19] & 7) << 2 | nArray7[20] >> 1 & 3);
        byArray[n++] = (byte)((nArray7[20] & 1) << 7 | (nArray7[21] & 7) << 4 | (nArray7[22] & 7) << 1 | nArray7[23] >> 2 & 1);
        byArray[n++] = (byte)((nArray7[23] & 3) << 6 | (nArray7[24] & 7) << 3 | nArray7[25] & 7);
        byArray[n++] = (byte)((nArray3[2] & 0x7F) << 1 | nArray5[2] >> 1 & 1);
        byArray[n++] = (byte)((nArray5[2] & 1) << 7 | (nArray4[2] & 3) << 5 | nArray6[2] >> 1 & 0x1F);
        byArray[n++] = (byte)((nArray6[2] & 1) << 7 | (nArray7[26] & 7) << 4 | (nArray7[27] & 7) << 1 | nArray7[28] >> 2 & 1);
        byArray[n++] = (byte)((nArray7[28] & 3) << 6 | (nArray7[29] & 7) << 3 | nArray7[30] & 7);
        byArray[n++] = (byte)((nArray7[31] & 7) << 5 | (nArray7[32] & 7) << 2 | nArray7[33] >> 1 & 3);
        byArray[n++] = (byte)((nArray7[33] & 1) << 7 | (nArray7[34] & 7) << 4 | (nArray7[35] & 7) << 1 | nArray7[36] >> 2 & 1);
        byArray[n++] = (byte)((nArray7[36] & 3) << 6 | (nArray7[37] & 7) << 3 | nArray7[38] & 7);
        byArray[n++] = (byte)((nArray3[3] & 0x7F) << 1 | nArray5[3] >> 1 & 1);
        byArray[n++] = (byte)((nArray5[3] & 1) << 7 | (nArray4[3] & 3) << 5 | nArray6[3] >> 1 & 0x1F);
        byArray[n++] = (byte)((nArray6[3] & 1) << 7 | (nArray7[39] & 7) << 4 | (nArray7[40] & 7) << 1 | nArray7[41] >> 2 & 1);
        byArray[n++] = (byte)((nArray7[41] & 3) << 6 | (nArray7[42] & 7) << 3 | nArray7[43] & 7);
        byArray[n++] = (byte)((nArray7[44] & 7) << 5 | (nArray7[45] & 7) << 2 | nArray7[46] >> 1 & 3);
        byArray[n++] = (byte)((nArray7[46] & 1) << 7 | (nArray7[47] & 7) << 4 | (nArray7[48] & 7) << 1 | nArray7[49] >> 2 & 1);
        byArray[n++] = (byte)((nArray7[49] & 3) << 6 | (nArray7[50] & 7) << 3 | nArray7[51] & 7);
    }

    final int[] encode(int[] nArray) {
        byte[] byArray = new byte[33];
        this.encode(byArray, nArray);
        return nArray;
    }

    private void encoder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        int[] nArray8 = this.dp0;
        int[] nArray9 = this.dp0;
        int[] nArray10 = new int[160];
        this.dpOffset = 120;
        this.dppOffset = 120;
        this.dOffset = 0;
        this.ncOffset = 0;
        this.bcOffset = 0;
        this.eOffset = 0;
        this.xmaxcOffset = 0;
        this.xmcOffset = 0;
        this.mcoffset = 0;
        this.GsmPreprocess(nArray, nArray10);
        this.GsmLPCAnalysis(nArray10, nArray2);
        this.Gsm_Short_Term_Analysis_Filter(nArray2, nArray10);
        int n = 0;
        while (n <= 3) {
            this.dOffset = n * 40;
            this.eOffset = 5;
            this.Gsm_Long_Term_Predictor(nArray10, nArray8, this.e, nArray9, nArray3, nArray4);
            this.Gsm_RPE_Encoding(this.e, nArray6, nArray5, nArray7);
            for (int i = 0; i <= 39; ++i) {
                nArray8[this.dpOffset + i] = GSMEncoder.add(this.e[5 + i], nArray9[this.dppOffset + i]);
            }
            this.dpOffset += 40;
            this.dppOffset += 40;
            ++this.ncOffset;
            ++this.bcOffset;
            ++this.xmaxcOffset;
            ++this.mcoffset;
            ++n;
            this.xmcOffset += 13;
        }
        System.arraycopy(this.dp0, 0, this.dp0, 160, 120);
    }

    public void GSM() {
    }

    private int gsm_div(int n, int n2) {
        int n3 = n;
        int n4 = 0;
        int n5 = 15;
        assert (n >= 0 && n2 >= n);
        if (n == 0) {
            return 0;
        }
        while (n5-- > 0) {
            n4 <<= 1;
            if ((n3 <<= 1) < n2) continue;
            n3 -= n2;
            ++n4;
        }
        return n4;
    }

    private void Gsm_Long_Term_Predictor(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        this.Calculation_of_the_LTP_parameters(nArray, nArray2, nArray6, nArray5);
        this.Long_term_analysis_filtering(nArray6[this.bcOffset], nArray5[this.ncOffset], nArray2, nArray, nArray4, nArray3);
    }

    int gsm_mult(int n, int n2) {
        if (n == Short.MIN_VALUE && n2 == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        return n * n2 >> 15;
    }

    private int gsm_norm(int n) {
        assert (n != 0);
        if (n < 0) {
            if (n <= -1073741824) {
                return 0;
            }
            n ^= 0xFFFFFFFF;
        }
        return (n & 0xFFFF0000) != 0 ? ((n & 0xFF000000) != 0 ? -1 + bitoff[0xFF & n >> 24] : 7 + bitoff[0xFF & n >> 16]) : ((n & 0xFF00) != 0 ? 15 + bitoff[0xFF & n >> 8] : 23 + bitoff[0xFF & n]);
    }

    private void Gsm_RPE_Encoding(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[40];
        int[] nArray6 = new int[13];
        int[] nArray7 = new int[13];
        int[] nArray8 = new int[1];
        int[] nArray9 = new int[1];
        this.Weighting_filter(nArray, nArray5);
        this.RPE_grid_selection(nArray5, nArray6, nArray3);
        this.APCM_quantization(nArray6, nArray4, nArray8, nArray9, nArray2);
        this.APCMInverseQuantization(nArray4, nArray9[0], nArray8[0], nArray7);
        this.RPE_grid_positioning(nArray3[this.mcoffset], nArray7, nArray);
    }

    private void Gsm_Short_Term_Analysis_Filter(int[] nArray, int[] nArray2) {
        int[] nArray3 = this.LARpp[this.j];
        int[] nArray4 = this.LARpp[this.j ^= 1];
        int[] nArray5 = new int[8];
        this.DecodingOfTheCodedLogAreaRatios(nArray, nArray3);
        this.Coefficients_0_12(nArray4, nArray3, nArray5);
        GSMEncoder.LARp_to_rp(nArray5);
        this.Short_term_analysis_filtering(nArray5, 13, nArray2, 0);
        this.Coefficients_13_26(nArray4, nArray3, nArray5);
        GSMEncoder.LARp_to_rp(nArray5);
        this.Short_term_analysis_filtering(nArray5, 14, nArray2, 13);
        this.Coefficients_27_39(nArray4, nArray3, nArray5);
        GSMEncoder.LARp_to_rp(nArray5);
        this.Short_term_analysis_filtering(nArray5, 13, nArray2, 27);
        GSMEncoder.Coefficients_40_159(nArray3, nArray5);
        GSMEncoder.LARp_to_rp(nArray5);
        this.Short_term_analysis_filtering(nArray5, 120, nArray2, 40);
    }

    private void GsmLPCAnalysis(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[9];
        this.Autocorrelation(nArray, nArray3);
        this.Reflection_coefficients(nArray3, nArray2);
        this.Transformation_to_Log_Area_Ratios(nArray2);
        this.Quantization_and_coding(nArray2);
    }

    final void GsmPreprocess(int[] nArray, int[] nArray2) {
        int n = 160;
        int n2 = 0;
        int n3 = 0;
        while (n-- > 0) {
            int n4 = this.sasr(nArray[n2], 3) << 2;
            ++n2;
            assert (n4 >= -16384);
            assert (n4 <= 16380);
            int n5 = n4 - this.z1;
            this.z1 = n4;
            assert (n5 != Short.MIN_VALUE);
            int n6 = n5;
            n6 <<= 15;
            int n7 = this.sasr(this.L_z2, 15);
            int n8 = this.L_z2 - (n7 << 15);
            int n9 = n7 * 32735;
            this.L_z2 = (int)this.l_add(n9, n6 += GSMEncoder.mult_r(n8, 32735));
            n9 = (int)this.l_add(this.L_z2, 16384);
            n7 = GSMEncoder.mult_r(this.mp, -28180);
            this.mp = this.sasr(n9, 15);
            nArray2[n3++] = GSMEncoder.add(this.mp, n7);
        }
    }

    private long l_add(int n, int n2) {
        long l;
        long l2;
        long l3 = n < 0 ? (n2 >= 0 ? (long)(n + n2) : ((l2 = (long)(-(n + 1)) + (long)(-(n2 + 1))) >= Integer.MAX_VALUE ? Integer.MIN_VALUE : -l2 - 2L)) : (n2 <= 0 ? (long)(n + n2) : ((l = (long)n + (long)n2) >= Integer.MAX_VALUE ? Integer.MAX_VALUE : l));
        return l3;
    }

    void Long_term_analysis_filtering(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        switch (n) {
            case 0: {
                for (int i = 0; i <= 39; ++i) {
                    nArray3[this.dppOffset + i] = GSMEncoder.mult_r(3277, nArray[this.dpOffset + i - n2]);
                    nArray4[this.eOffset + i] = GSMEncoder.sub(nArray2[this.dOffset + i], nArray3[this.dppOffset + i]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i <= 39; ++i) {
                    nArray3[this.dppOffset + i] = GSMEncoder.mult_r(11469, nArray[this.dpOffset + i - n2]);
                    nArray4[this.eOffset + i] = GSMEncoder.sub(nArray2[this.dOffset + i], nArray3[this.dppOffset + i]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i <= 39; ++i) {
                    nArray3[this.dppOffset + i] = GSMEncoder.mult_r(21299, nArray[this.dpOffset + i - n2]);
                    nArray4[this.eOffset + i] = GSMEncoder.sub(nArray2[this.dOffset + i], nArray3[this.dppOffset + i]);
                }
                break;
            }
            case 3: {
                for (int i = 0; i <= 39; ++i) {
                    nArray3[this.dppOffset + i] = GSMEncoder.mult_r(Short.MAX_VALUE, nArray[this.dpOffset + i - n2]);
                    nArray4[this.eOffset + i] = GSMEncoder.sub(nArray2[this.dOffset + i], nArray3[this.dppOffset + i]);
                }
                break;
            }
        }
    }

    private void Quantization_and_coding(int[] nArray) {
        int n = 0;
        int n2 = this.gsm_mult(20480, nArray[n]);
        n2 = GSMEncoder.add(n2, 0);
        n2 = GSMEncoder.add(n2, 256);
        nArray[n] = (n2 = this.sasr(n2, 9)) > 31 ? 63 : (n2 < -32 ? 0 : n2 - -32);
        n2 = this.gsm_mult(20480, nArray[++n]);
        n2 = GSMEncoder.add(n2, 0);
        n2 = GSMEncoder.add(n2, 256);
        n2 = this.sasr(n2, 9);
        nArray[n] = n2 > 31 ? 63 : (n2 < -32 ? 0 : n2 - -32);
        n2 = this.gsm_mult(20480, nArray[++n]);
        n2 = GSMEncoder.add(n2, 2048);
        n2 = GSMEncoder.add(n2, 256);
        n2 = this.sasr(n2, 9);
        nArray[n] = n2 > 15 ? 31 : (n2 < -16 ? 0 : n2 - -16);
        n2 = this.gsm_mult(20480, nArray[++n]);
        n2 = GSMEncoder.add(n2, -2560);
        n2 = GSMEncoder.add(n2, 256);
        n2 = this.sasr(n2, 9);
        nArray[n] = n2 > 15 ? 31 : (n2 < -16 ? 0 : n2 - -16);
        n2 = this.gsm_mult(13964, nArray[++n]);
        n2 = GSMEncoder.add(n2, 94);
        n2 = GSMEncoder.add(n2, 256);
        n2 = this.sasr(n2, 9);
        nArray[n] = n2 > 7 ? 15 : (n2 < -8 ? 0 : n2 - -8);
        n2 = this.gsm_mult(15360, nArray[++n]);
        n2 = GSMEncoder.add(n2, -1792);
        n2 = GSMEncoder.add(n2, 256);
        n2 = this.sasr(n2, 9);
        nArray[n] = n2 > 7 ? 15 : (n2 < -8 ? 0 : n2 - -8);
        n2 = this.gsm_mult(8534, nArray[++n]);
        n2 = GSMEncoder.add(n2, -341);
        n2 = GSMEncoder.add(n2, 256);
        n2 = this.sasr(n2, 9);
        nArray[n] = n2 > 3 ? 7 : (n2 < -4 ? 0 : n2 - -4);
        n2 = this.gsm_mult(9036, nArray[++n]);
        n2 = GSMEncoder.add(n2, -1144);
        n2 = GSMEncoder.add(n2, 256);
        n2 = this.sasr(n2, 9);
        nArray[n] = n2 > 3 ? 7 : (n2 < -4 ? 0 : n2 - -4);
        ++n;
    }

    private void Reflection_coefficients(int[] nArray, int[] nArray2) {
        int n;
        int n2 = 0;
        int[] nArray3 = new int[9];
        int[] nArray4 = new int[9];
        int[] nArray5 = new int[9];
        if (nArray[0] == 0) {
            for (int i = 8; i > 0; --i) {
                nArray2[n2++] = 0;
            }
            return;
        }
        assert (nArray[0] != 0);
        int n3 = this.gsm_norm(nArray[0]);
        assert (n3 >= 0 && n3 < 32);
        for (n = 0; n <= 8; ++n) {
            nArray3[n] = this.sasr(nArray[n] << n3, 16);
        }
        for (n = 1; n <= 7; ++n) {
            nArray5[n] = nArray3[n];
        }
        for (n = 0; n <= 8; ++n) {
            nArray4[n] = nArray3[n];
        }
        int n4 = 1;
        while (n4 <= 8) {
            n3 = nArray4[1];
            if (nArray4[0] < (n3 = this.abs(n3))) {
                for (n = n4; n <= 8; ++n) {
                    nArray2[n2++] = 0;
                }
                return;
            }
            nArray2[n2] = this.gsm_div(n3, nArray4[0]);
            assert (nArray2[n2] >= 0);
            if (nArray4[1] > 0) {
                nArray2[n2] = -nArray2[n2];
            }
            assert (nArray2[n2] != Short.MIN_VALUE);
            if (n4 == 8) {
                return;
            }
            n3 = GSMEncoder.mult_r(nArray4[1], nArray2[n2]);
            nArray4[0] = GSMEncoder.add(nArray4[0], n3);
            for (int i = 1; i <= 8 - n4; ++i) {
                n3 = GSMEncoder.mult_r(nArray5[i], nArray2[n2]);
                nArray4[i] = GSMEncoder.add(nArray4[i + 1], n3);
                n3 = GSMEncoder.mult_r(nArray4[i + 1], nArray2[n2]);
                nArray5[i] = GSMEncoder.add(nArray5[i], n3);
            }
            ++n4;
            ++n2;
        }
    }

    private void RPE_grid_positioning(int n, int[] nArray, int[] nArray2) {
        int n2 = 13;
        int n3 = this.eOffset;
        int n4 = 0;
        switch (n) {
            case 3: {
                nArray2[n3++] = 0;
            }
            case 2: {
                nArray2[n3++] = 0;
            }
            case 1: {
                nArray2[n3++] = 0;
            }
            case 0: {
                nArray2[n3++] = nArray[n4++];
                --n2;
            }
        }
        do {
            nArray2[n3++] = 0;
            nArray2[n3++] = 0;
            nArray2[n3++] = nArray[n4++];
        } while (--n2 > 0);
        while (++n < 4) {
            nArray2[n3++] = 0;
        }
    }

    private void RPE_grid_selection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 1; n2 <= 12; ++n2) {
            n = this.sasr(nArray[3 * n2], 2);
            n5 += n * n;
        }
        int n6 = n5;
        n = this.sasr(nArray[0], 2);
        n5 += n * n;
        n3 = n5 <<= 1;
        n5 = 0;
        for (n2 = 0; n2 <= 12; ++n2) {
            n = this.sasr(nArray[1 + 3 * n2], 2);
            n5 += n * n;
        }
        if ((n5 <<= 1) > n3) {
            n4 = 1;
            n3 = n5;
        }
        n5 = 0;
        for (n2 = 0; n2 <= 12; ++n2) {
            n = this.sasr(nArray[2 + 3 * n2], 2);
            n5 += n * n;
        }
        if ((n5 <<= 1) > n3) {
            n4 = 2;
            n3 = n5;
        }
        n5 = n6;
        n = this.sasr(nArray[39], 2);
        n5 += n * n;
        if ((n5 <<= 1) > n3) {
            n4 = 3;
            n3 = n5;
        }
        for (int i = 0; i <= 12; ++i) {
            nArray2[i] = nArray[n4 + 3 * i];
        }
        nArray3[this.mcoffset] = n4;
    }

    private int sasr(int n, int n2) {
        return n >= 0 ? n >> n2 : ~(-(n + 1) >> n2);
    }

    private void Short_term_analysis_filtering(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = n2;
        while (n-- > 0) {
            int n4;
            int n5 = n4 = nArray2[n3];
            for (int i = 0; i < 8; ++i) {
                int n6 = this.u[i];
                int n7 = nArray[i];
                this.u[i] = n4;
                int n8 = GSMEncoder.mult_r(n7, n5);
                n4 = GSMEncoder.add(n6, n8);
                n8 = GSMEncoder.mult_r(n7, n6);
                n5 = GSMEncoder.add(n5, n8);
            }
            nArray2[n3] = n5;
            ++n3;
        }
    }

    private void Transformation_to_Log_Area_Ratios(int[] nArray) {
        int n = 0;
        int n2 = 1;
        while (n2 <= 8) {
            int n3 = nArray[n];
            n3 = this.abs(n3);
            assert (n3 >= 0);
            if (n3 < 22118) {
                n3 >>= 1;
            } else if (n3 < 31130) {
                assert (n3 >= 11059);
                n3 -= 11059;
            } else {
                assert (n3 >= 26112);
                n3 -= 26112;
                n3 <<= 2;
            }
            int n4 = nArray[n] = nArray[n] < 0 ? -n3 : n3;
            assert (nArray[n] != Short.MIN_VALUE);
            ++n2;
            ++n;
        }
    }

    private void Weighting_filter(int[] nArray, int[] nArray2) {
        int n = this.eOffset - 5;
        for (int i = 0; i <= 39; ++i) {
            int n2 = 4096;
            n2 += nArray[n + i] * -134 + nArray[n + i + 1] * -374 + nArray[n + i + 3] * 2054 + nArray[n + i + 4] * 5741 + nArray[n + i + 5] * 8192 + nArray[n + i + 6] * 5741 + nArray[n + i + 7] * 2054 + nArray[n + i + 9] * -374 + nArray[n + i + 10] * -134;
            nArray2[i] = (n2 = this.sasr(n2, 13)) < Short.MIN_VALUE ? Short.MIN_VALUE : (n2 > Short.MAX_VALUE ? Short.MAX_VALUE : n2);
        }
    }
}

