/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import net.sf.fmj.media.RegistryDefaults;
import net.sf.fmj.registry.RegistryContents;
import net.sf.fmj.registry.RegistryIOFactory;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.PlugInInfo;
import net.sf.fmj.utility.PlugInUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    private static final Logger logger = LoggerSingleton.logger;
    private static final int[] REGISTRY_FORMATS = new int[]{0, 1};
    private static final int DEFAULT_REGISTRY_WRITE_FORMAT = 0;
    private static Registry registry = null;
    private static Object registryMutex = new Object();
    private final RegistryContents registryContents = new RegistryContents();
    private static final boolean READD_JAVAX = false;
    public static final int NUM_PLUGIN_TYPES = 5;
    private final boolean disableCommit;
    private static final String SYSTEM_PROPERTY_DISABLE_COMMIT = "net.sf.fmj.utility.JmfRegistry.disableCommit";
    private static final String SYSTEM_PROPERTY_DISABLE_LOAD = "net.sf.fmj.utility.JmfRegistry.disableLoad";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry getInstance() {
        Object object = registryMutex;
        synchronized (object) {
            if (null == registry) {
                registry = new Registry();
            }
            return registry;
        }
    }

    private Registry() {
        String string = Boolean.TRUE.toString();
        String string2 = Boolean.FALSE.toString();
        this.disableCommit = System.getProperty(SYSTEM_PROPERTY_DISABLE_COMMIT, string2).equals(string);
        try {
            if (System.getProperty(SYSTEM_PROPERTY_DISABLE_LOAD, string2).equals(string)) {
                this.setDefaults();
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!this.load()) {
            logger.fine("Using registry defaults.");
            this.setDefaults();
        }
    }

    public synchronized boolean addDevice(CaptureDeviceInfo captureDeviceInfo) {
        return this.registryContents.captureDeviceInfoList.add(captureDeviceInfo);
    }

    public synchronized void addMimeType(String string, String string2) {
        this.registryContents.mimeTable.addMimeType(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws IOException {
        if (this.disableCommit) {
            return;
        }
        File file = this.getRegistryFile(0);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            RegistryIOFactory.createRegistryIO(0, this.registryContents).write(fileOutputStream);
            fileOutputStream.flush();
        }
        finally {
            fileOutputStream.close();
        }
        logger.info("Wrote registry file: " + file.getAbsolutePath());
    }

    public synchronized Vector<String> getContentPrefixList() {
        return (Vector)this.registryContents.contentPrefixList.clone();
    }

    public synchronized String getDefaultExtension(String string) {
        return this.registryContents.mimeTable.getDefaultExtension(string);
    }

    public synchronized Vector<CaptureDeviceInfo> getDeviceList() {
        return (Vector)this.registryContents.captureDeviceInfoList.clone();
    }

    public synchronized List<String> getExtensions(String string) {
        return this.registryContents.mimeTable.getExtensions(string);
    }

    public synchronized Hashtable<String, String> getMimeTable() {
        return this.registryContents.mimeTable.getMimeTable();
    }

    public synchronized String getMimeType(String string) {
        return this.registryContents.mimeTable.getMimeType(string);
    }

    public synchronized List<String> getPluginList(int n) {
        Vector<String> vector = this.registryContents.plugins[n - 1];
        return (List)vector.clone();
    }

    public synchronized Vector<String> getProtocolPrefixList() {
        return (Vector)this.registryContents.protocolPrefixList.clone();
    }

    private File getRegistryFile(int n) {
        String string = System.getProperty("net.sf.fmj.utility.JmfRegistry.filename", n == 1 ? ".fmj.registry.properties" : ".fmj.registry.xml");
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.home"), string);
        }
        return file;
    }

    private InputStream getRegistryResourceStream(int n) {
        return Registry.class.getResourceAsStream(n == 1 ? "/fmj.registry.properties" : "/fmj.registry.xml");
    }

    private synchronized boolean load() {
        for (int n : REGISTRY_FORMATS) {
            if (!this.loadFromResource(n)) continue;
            return true;
        }
        for (int n : REGISTRY_FORMATS) {
            if (!this.loadFromFile(n)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean loadFromFile(int n) {
        try {
            File file = this.getRegistryFile(n);
            if (file.isFile() && file.length() > 0L) {
                FileInputStream fileInputStream = new FileInputStream(file);
                RegistryIOFactory.createRegistryIO(n, this.registryContents).load(fileInputStream);
                logger.info("Loaded registry from file: " + file.getAbsolutePath());
                return true;
            }
        }
        catch (Throwable throwable) {
            logger.warning("Problem loading registry from file: " + throwable.getMessage());
        }
        return false;
    }

    private synchronized boolean loadFromResource(int n) {
        try {
            InputStream inputStream = this.getRegistryResourceStream(n);
            if (inputStream == null) {
                return false;
            }
            RegistryIOFactory.createRegistryIO(n, this.registryContents).load(inputStream);
            logger.info("Loaded registry from resource, format: " + (n == 1 ? "Properties" : "XML"));
            return true;
        }
        catch (Throwable throwable) {
            logger.warning("Problem loading registry from resource: " + throwable.getMessage());
            return false;
        }
    }

    public synchronized boolean removeDevice(CaptureDeviceInfo captureDeviceInfo) {
        return this.registryContents.captureDeviceInfoList.remove(captureDeviceInfo);
    }

    public synchronized boolean removeMimeType(String string) {
        return this.registryContents.mimeTable.removeMimeType(string);
    }

    public synchronized void setContentPrefixList(List<String> list) {
        this.registryContents.contentPrefixList.clear();
        this.registryContents.contentPrefixList.addAll(list);
    }

    private void setDefaults() {
        int n = RegistryDefaults.getDefaultFlags();
        this.registryContents.protocolPrefixList.addAll(RegistryDefaults.protocolPrefixList(n));
        this.registryContents.contentPrefixList.addAll(RegistryDefaults.contentPrefixList(n));
        List<Object> list = RegistryDefaults.plugInList(n);
        for (Object object : list) {
            PlugInInfo plugInInfo;
            if (object instanceof PlugInInfo) {
                plugInInfo = (PlugInInfo)object;
                this.registryContents.plugins[plugInInfo.type - 1].add(plugInInfo.className);
                continue;
            }
            plugInInfo = PlugInUtility.getPlugInInfo((String)object);
            if (plugInInfo == null) continue;
            this.registryContents.plugins[plugInInfo.type - 1].add(plugInInfo.className);
        }
    }

    public synchronized void setPluginList(int n, List<String> list) {
        Vector<String> vector = this.registryContents.plugins[n - 1];
        vector.clear();
        vector.addAll(list);
    }

    public synchronized void setProtocolPrefixList(List<String> list) {
        this.registryContents.protocolPrefixList.clear();
        this.registryContents.protocolPrefixList.addAll(list);
    }
}

