/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.media.Buffer;
import net.sf.fmj.media.BufferQueueInputStream;
import net.sf.fmj.utility.LoggerSingleton;

public class StreamPipe {
    private static final Logger logger = LoggerSingleton.logger;
    private final BufferQueueInputStream is = new BufferQueueInputStream();
    private final MyOutputStream os = new MyOutputStream();

    private Buffer createBuffer(byte[] byArray, int n, int n2) {
        Buffer buffer = new Buffer();
        buffer.setData(byArray);
        buffer.setOffset(n);
        buffer.setLength(n2);
        return buffer;
    }

    private Buffer createEOMBuffer() {
        Buffer buffer = new Buffer();
        buffer.setData(new byte[0]);
        buffer.setOffset(0);
        buffer.setLength(0);
        buffer.setEOM(true);
        return buffer;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    private class MyOutputStream
    extends OutputStream {
        private MyOutputStream() {
        }

        public void close() throws IOException {
            logger.finer("MyOutputStream Closing, putting EOM buffer");
            StreamPipe.this.is.blockingPut(StreamPipe.this.createEOMBuffer());
            super.close();
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            StreamPipe.this.is.blockingPut(StreamPipe.this.createBuffer(byArray, n, n2));
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n});
        }
    }
}

